/*
 * $Id: AbstractButtonRenderer.java,v 1.3 2006/11/09 19:08:57 oeuillot Exp $
 */
package org.rcfaces.renderkit.html.internal;

import javax.faces.component.UIComponent;

import org.rcfaces.core.component.capability.IDisabledCapability;
import org.rcfaces.core.internal.renderkit.WriterException;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/09 19:08:57 $
 */
public abstract class AbstractButtonRenderer extends AbstractCssRenderer {

    private static final String REVISION = "$Revision: 1.3 $";

    protected String getButtonType(UIComponent component) {
        return "button";
    }

    protected final IHtmlWriter writeButtonAttributes(IHtmlWriter writer)
            throws WriterException {
        UIComponent component = writer.getComponentRenderContext()
                .getComponent();

        return writeButtonAttributes(writer, component.getId());
    }

    protected final IHtmlWriter writeButtonAttributes(IHtmlWriter writer,
            String id) throws WriterException {
        UIComponent component = writer.getComponentRenderContext()
                .getComponent();

        if (id != null) {
            writer.writeName(id);
        }

        String type = getButtonType(component);
        if (type != null) {
            writer.writeType(type);
        }

        if (component instanceof IDisabledCapability) {
            writeEnabled(writer, (IDisabledCapability) component);
        }

        return writer;
    }
}