/*
 * $Id: IHtmlRenderContext.java,v 1.6 2006/12/08 17:26:13 oeuillot Exp $
 */
package org.rcfaces.renderkit.html.internal;

import org.rcfaces.core.internal.component.IAsyncRenderComponent;
import org.rcfaces.core.internal.renderkit.IRenderContext;
import org.rcfaces.core.internal.renderkit.WriterException;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.6 $ $Date: 2006/12/08 17:26:13 $
 */
public interface IHtmlRenderContext extends IRenderContext {

    String JAVASCRIPT_TYPE = "text/javascript";

    String JAVASCRIPT_CHARSET = "UTF-8";

    String JAVASCRIPT_CDATA_BEGIN = "//<![CDATA[";

    String JAVASCRIPT_CDATA_END = "//]]>";

    String CSS_TYPE = "text/css";

    String HTML_TYPE = "text/html";

    IHtmlProcessContext getHtmlProcessContext();

    IJavaScriptWriter removeJavaScriptWriter(IHtmlWriter writer);

    IJavaScriptWriter getJavaScriptWriter(IHtmlWriter writer,
            IJavaScriptComponent javaScriptComponent) throws WriterException;

    void pushInteractiveRenderComponent(IHtmlWriter writer);

    IJavaScriptRenderContext getJavaScriptRenderContext();

    IAsyncRenderComponent getCurrentInteractiveRenderComponent();

    String getCurrentInteractiveRenderComponentClientId();

    Object saveRenderContextState();

    boolean canUseLazyTag();

    boolean isAsyncRenderEnable();

    boolean isDisabledContextMenu();

    void setDisabledContextMenu(boolean state);

    String getInvalidBrowserURL();

    void setInvalidBrowserURL(String invalidBrowserURL);
}