/*
 * $Id: FlatBorderRenderer.java,v 1.3 2006/11/10 14:15:43 oeuillot Exp $
 * 
 */
package org.rcfaces.renderkit.html.internal.border;

import org.rcfaces.core.internal.renderkit.WriterException;
import org.rcfaces.renderkit.html.internal.IHtmlWriter;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/10 14:15:43 $
 */
public class FlatBorderRenderer extends AbstractHtmlBorderRenderer {
    private static final String REVISION = "$Revision: 1.3 $";

    private static final String FLAT_BORDER_CLASS = "fb_flat";

    public void initialize(IHtmlWriter writer, String width, String height,
            int horizontalSpan, int verticalSpan, boolean disabled,
            boolean selected) throws WriterException {
        super.initialize(writer, width, height, horizontalSpan, verticalSpan,
                disabled, selected);

        writer.writeAttribute("v:flatMode", "true");
    }

    protected boolean hasBorder() {
        return true;
    }

    protected String getClassName() {
        return FLAT_BORDER_CLASS;
    }

}
