/*
 * $Id: f_hiddenValue.js,v 1.2 2006/11/09 19:08:56 oeuillot Exp $
 */
 
/**
 * Hidden value component.
 *
 * @class public f_hiddenValue extends f_eventTarget, HTMLElement, fa_serializable, fa_clientData, fa_value
 */
 
 var __prototype = {
	/**
	 * Retourne <code>true</code> if the component is value
	 *
	 * @method public
	 * @return String Or <code>null</code> if not defined !
	 */
	f_getValue: function() {
		return this.value;
	},
	/**
	 * Set value state.
	 *
	 * @method public
	 * @param optional String value
	 * @return void
	 */
	f_setValue: function(value) {
		if (value===undefined) {
			value="";
		}
	
		var oldValue=this.value;	
		this.value=value;
		
		if (this.f_performPropertyChange) {
			this.f_performPropertyChange(f_prop.VALUE, value, oldValue);
		}
	}
}
 
 
var f_hiddenValue = new f_class("f_hiddenValue", null, null, __prototype, f_eventTarget, fa_serializable, fa_clientData);
