/*
 * $Id: f_messageObject.js,v 1.3 2006/11/09 19:08:56 oeuillot Exp $
 */

/**
 * Class Message Object
 *
 * @class final f_messageObject extends Object
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/09 19:08:56 $
 */
var __static = {
	/**
	 * @field public static final number
	 */
   	SEVERITY_INFO:  0,

 	/**
	 * @field public static final number
	 */
    SEVERITY_WARN:  1,

	/**
	 * @field public static final number
	 */
    SEVERITY_ERROR: 2,

	/**
	 * @field public static final number
	 */
    SEVERITY_FATAL: 3,
    
	f_getName: function() {
		return "f_messageObject";
	}
}

function f_messageObject(severity, summary, detail) {
	f_core.Assert(typeof(severity)=="number", "Bad type of severity");
	f_core.Assert(summary, "Bad summary");

	this._severity=severity;
	this._summary=summary;
	this._detail=detail;
}

f_messageObject.prototype = {
/*
	f_finalize: function() {
		this._severity=undefined; // number
		this._summary=undefined; // string
		this._detail=undefined; // string
	},
*/
	
	/**
	 * @method public 
	 * @return number Severity
	 */
	f_getSeverity: function() {
		return this._severity;
	},
	
	/**
	 * @method public 
	 * @return String Summary
	 */
	f_getSummary: function() {
		return this._summary;
	},
	
	/**
	 * @method public 
	 * @return String Detail
	 */
	f_getDetail: function() {
		if (this._detail) {
			return this._detail;
		}
		
		return this._summary;
	}
}


for(var p in __static) {
	f_messageObject[p]=__static[p];
}
