/*
 * $Id: fa_message.js,v 1.6 2006/12/18 13:30:33 oeuillot Exp $
 */

/**
 * Aspect Message
 *
 * @aspect fa_message
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.6 $ $Date: 2006/12/18 13:30:33 $
 */

var __prototype = {
	fa_message: function() {
		this._styleClass=f_core.GetAttribute(this, "v:styleClass");
		if (!this._styleClass) {
			this._styleClass=this.className;
		}

		if (window.f_messageContext) {
			var messageContext=f_messageContext.Get(this);
			
			var messages=messageContext.f_listMessages(this);
			
			messageContext.f_addMessageListener(this);
			
			if (messages.length) {
				this.f_performMessageChanges(messageContext);
			}
		}
	},
	
	/**
	 * @method protected
	 * @return boolean
	 */
	f_hasSeverityClassName: function() {

		var classSpecified=this._classSpecified;
		
		if (classSpecified!==undefined) {
			return classSpecified;
		}
		
		this._fatalStyleClass=f_core.GetAttribute(this, "v:fatalStyleClass");
		this._errorStyleClass=f_core.GetAttribute(this, "v:errorStyleClass");
		this._warnStyleClass=f_core.GetAttribute(this, "v:warnStyleClass");
		this._infoStyleClass=f_core.GetAttribute(this, "v:infoStyleClass");
		
		classSpecified=this._fatalStyleClass || this._errorStyleClass || this._warnStyleClass || this._infoStyleClass;
		this._classSpecified=classSpecified;

		if (classSpecified) {
			return true;
		}
		
		var styleClass=this._styleClass;
		
		this._fatalStyleClass=styleClass+"_fatal";
		this._errorStyleClass=styleClass+"_error";
		this._warnStyleClass=styleClass+"_warn";
		this._infoStyleClass=styleClass+"_info";

		return false;
	},
	
	/*
	f_finalize: function() {
		// this._classSpecified=undefined; // boolean
		// this._styleClass=undefined; // string
		
		// this._fatalStyleClass=undefined;  // string
		// this._errorStyleClass=undefined; // string
		// this._warnStyleClass=undefined; // string
		// this._infoStyleClass=undefined; // string
	},
	*/

	/**
	 * @method public 
	 * @return String
	 */
	f_getFatalStyleClass: function() {
		this.f_hasSeverityClassName();

		return this._fatalStyleClass;
	},
	/**
	 * @method public 
	 * @return String
	 */
	f_getErrorStyleClass: function() {
		this.f_hasSeverityClassName();

		return this._errorStyleClass;
	},
	/**
	 * @method public 
	 * @return String
	 */
	f_getWarnStyleClass: function() {
		this.f_hasSeverityClassName();
		
		return this._warnStyleClass;
	},
	/**
	 * @method public 
	 * @return String
	 */
	f_getInfoStyleClass: function() {
		this.f_hasSeverityClassName();
		
		return this._infoStyleClass;
	},
	/**
	 * @method protected final
	 * @param number severity
	 * @return String style class name.
	 */
	f_getStyleClassFromSeverity: function(severity) {
		f_core.Assert(typeof(severity)=="number", "Invalid severity parameter ('"+severity+"')");
		
		var className=null;
		
		switch(severity) {
		case f_messageObject.SEVERITY_FATAL:
			className=this.f_getFatalStyleClass();
			if (className) {
				return className;
			}

		case f_messageObject.SEVERITY_ERROR:
			className=this.f_getErrorStyleClass();
			if (className) {
				return className;
			}

		case f_messageObject.SEVERITY_WARN:
			className=this.f_getWarnStyleClass();
			if (className) {
				return className;
			}

		case f_messageObject.SEVERITY_INFO:
			className=this.f_getInfoStyleClass();
			if (className) {
				return className;
			}
		}
		
		return null;
	},
	
	f_performMessageChanges: f_class.ABSTRACT	
}

var fa_message=new f_aspect("fa_message", null, __prototype);
