/*
 * $Id: CheckButton3StatesRenderer.java,v 1.4 2006/12/18 13:30:33 oeuillot Exp $
 * 
 */
package org.rcfaces.renderkit.html.internal.renderer;

import javax.faces.component.UIComponent;

import org.rcfaces.core.internal.renderkit.IComponentWriter;
import org.rcfaces.core.internal.renderkit.WriterException;
import org.rcfaces.renderkit.html.internal.AbstractInputRenderer;
import org.rcfaces.renderkit.html.internal.IAccessibilityRoles;
import org.rcfaces.renderkit.html.internal.IHtmlWriter;
import org.rcfaces.renderkit.html.internal.JavaScriptClasses;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.4 $ $Date: 2006/12/18 13:30:33 $
 */
public class CheckButton3StatesRenderer extends AbstractInputRenderer {
    private static final String REVISION = "$Revision: 1.4 $";

    public void encodeBegin(IComponentWriter writer) throws WriterException {
        super.encodeBegin(writer);

        IHtmlWriter htmlWriter = (IHtmlWriter) writer;

        htmlWriter.writeText("Composant: checkButton3States");

        htmlWriter.writeRole(IAccessibilityRoles.CHECK_BOX_3_STATE);
    }

    protected String getInputType(UIComponent component) {
        return "image";
    }

    protected String getJavaScriptClassName() {
        return JavaScriptClasses.CHECK_BUTTON_3_STATES;
    }
}
