/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.UUID;
import reactivemongo.api.bson.BSONBinary$;
import reactivemongo.api.bson.BSONReader;
import reactivemongo.api.bson.BSONValue;
import reactivemongo.api.bson.Subtype;
import reactivemongo.api.bson.buffer.ReadableBuffer;
import reactivemongo.api.bson.buffer.ReadableBuffer$;
import scala.Option;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\f\u0018\u0005yA\u0011\"\u000b\u0001\u0003\u0006\u0004%\ta\u0006\u0016\t\u0011E\u0002!\u0011!Q\u0001\n-B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\to\u0001\u0011\t\u0011)A\u0005i!1\u0001\b\u0001C\u0001/eBq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004C\u0001\u0001\u0006Ia\u0010\u0005\b\u0007\u0002\u0011\r\u0011\"\u0001E\u0011\u0019A\u0005\u0001)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\"Ia\n\u0001EC\u0002\u0013\u00053D\u0010\u0005\t\u001f\u0002A)\u0019!C!}!)\u0001\u000b\u0001C!#\"A!\f\u0001EC\u0002\u0013\u00053lB\u0003h/!\u0005\u0001NB\u0003\u0017/!\u0005\u0011\u000eC\u00039!\u0011\u0005!\u000eC\u0003l!\u0011\u0005A\u000eC\u0003s!\u0011\u00051\u000fC\u0003s!\u0011\u0005a\u000fC\u0004\u0002\u0004A!\t!!\u0002\u0003\u0015\t\u001bvJ\u0014\"j]\u0006\u0014\u0018P\u0003\u0002\u00193\u0005!!m]8o\u0015\tQ2$A\u0002ba&T\u0011\u0001H\u0001\u000ee\u0016\f7\r^5wK6|gnZ8\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0018\u0013\tAsCA\u0005C'>se+\u00197vK\u0006)a/\u00197vKV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002//\u00051!-\u001e4gKJL!\u0001M\u0017\u0003\u001dI+\u0017\rZ1cY\u0016\u0014UO\u001a4fe\u00061a/\u00197vK\u0002\nqa];cif\u0004X-F\u00015!\t1S'\u0003\u00027/\t91+\u001e2usB,\u0017\u0001C:vERL\b/\u001a\u0011\u0002\rqJg.\u001b;?)\rQ4\b\u0010\t\u0003M\u0001AQ!K\u0003A\u0002-BQAM\u0003A\u0002Q\nAaY8eKV\tq\b\u0005\u0002!\u0001&\u0011\u0011)\t\u0002\u0004\u0013:$\u0018!B2pI\u0016\u0004\u0013\u0001\u00032zi\u0016\u001cu\u000eZ3\u0016\u0003\u0015\u0003\"\u0001\t$\n\u0005\u001d\u000b#\u0001\u0002\"zi\u0016\f\u0011BY=uK\u000e{G-\u001a\u0011\u0002\u0013\tLH/Z!se\u0006LX#A&\u0011\u0007\u0001bU)\u0003\u0002NC\t)\u0011I\u001d:bs\u0006A!-\u001f;f'&TX-\u0001\u0005iCND7i\u001c3f\u0003\u0019)\u0017/^1mgR\u0011!+\u0016\t\u0003AMK!\u0001V\u0011\u0003\u000f\t{w\u000e\\3b]\")a+\u0004a\u0001/\u0006!A\u000f[1u!\t\u0001\u0003,\u0003\u0002ZC\t\u0019\u0011I\\=\u0002\u0011Q|7\u000b\u001e:j]\u001e,\u0012\u0001\u0018\t\u0003;\u0012t!A\u00182\u0011\u0005}\u000bS\"\u00011\u000b\u0005\u0005l\u0012A\u0002\u001fs_>$h(\u0003\u0002dC\u00051\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u0019\u0017%\u0001\u0006C'>s%)\u001b8bef\u0004\"A\n\t\u0014\u0005AyB#\u00015\u0002\u000fUt\u0017\r\u001d9msR\u0011Q\u000e\u001d\t\u0004A9$\u0014BA8\"\u0005\u0019y\u0005\u000f^5p]\")\u0011O\u0005a\u0001u\u00051!-\u001b8bef\fQ!\u00199qYf$2A\u000f;v\u0011\u0015I3\u00031\u0001L\u0011\u0015\u00114\u00031\u00015)\tQt\u000fC\u0003y)\u0001\u0007\u00110\u0001\u0002jIB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\u0005kRLGNC\u0001\u007f\u0003\u0011Q\u0017M^1\n\u0007\u0005\u00051P\u0001\u0003V+&#\u0015A\u00029sKR$\u0018\u0010F\u0002]\u0003\u000fAa!!\u0003\u0016\u0001\u0004Q\u0014a\u00012j]\u0002")
public final class BSONBinary
implements BSONValue {
    private int byteSize;
    private int hashCode;
    private String toString;
    private final ByteBuffer value;
    private final Subtype subtype;
    private final int code;
    private final byte byteCode;
    private volatile byte bitmap$0;

    public static String pretty(BSONBinary bSONBinary) {
        return BSONBinary$.MODULE$.pretty(bSONBinary);
    }

    public static BSONBinary apply(UUID uUID) {
        return BSONBinary$.MODULE$.apply(uUID);
    }

    public static BSONBinary apply(byte[] byArray, Subtype subtype) {
        return BSONBinary$.MODULE$.apply(byArray, subtype);
    }

    public static Option<Subtype> unapply(BSONBinary bSONBinary) {
        return BSONBinary$.MODULE$.unapply(bSONBinary);
    }

    @Override
    public final <T> Try<T> asTry(BSONReader<T> reader) {
        return BSONValue.asTry$(this, reader);
    }

    @Override
    public final <T> Option<T> asOpt(BSONReader<T> reader) {
        return BSONValue.asOpt$(this, reader);
    }

    @Override
    public Try<Object> asBoolean() {
        return BSONValue.asBoolean$(this);
    }

    @Override
    public Try<BigDecimal> asDecimal() {
        return BSONValue.asDecimal$(this);
    }

    @Override
    public Try<Instant> asDateTime() {
        return BSONValue.asDateTime$(this);
    }

    @Override
    public Try<Object> toDouble() {
        return BSONValue.toDouble$(this);
    }

    @Override
    public Try<Object> toFloat() {
        return BSONValue.toFloat$(this);
    }

    @Override
    public Try<Object> asLong() {
        return BSONValue.asLong$(this);
    }

    @Override
    public Try<Object> asInt() {
        return BSONValue.asInt$(this);
    }

    @Override
    public Try<String> asString() {
        return BSONValue.asString$(this);
    }

    public ByteBuffer value() {
        return this.value;
    }

    public Subtype subtype() {
        return this.subtype;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public byte byteCode() {
        return this.byteCode;
    }

    public byte[] byteArray() {
        return ReadableBuffer$.MODULE$.readArray$extension(ReadableBuffer$.MODULE$.duplicate$extension(this.value()), ReadableBuffer$.MODULE$.size$extension(this.value()));
    }

    private int byteSize$lzycompute() {
        BSONBinary bSONBinary = this;
        synchronized (bSONBinary) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.byteSize = 5 + ReadableBuffer$.MODULE$.readable$extension(this.value());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.byteSize;
    }

    @Override
    public int byteSize() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.byteSize$lzycompute() : this.byteSize;
    }

    private int hashCode$lzycompute() {
        BSONBinary bSONBinary = this;
        synchronized (bSONBinary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                int nh = MurmurHash3$.MODULE$.mix(-889275714, Statics.anyHash((Object)this.subtype()));
                this.hashCode = MurmurHash3$.MODULE$.mixLast(nh, ReadableBuffer$.MODULE$.hashCode$extension(this.value()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hashCode;
    }

    public int hashCode() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hashCode$lzycompute() : this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof BSONBinary)) return false;
        BSONBinary bSONBinary = (BSONBinary)object;
        Subtype subtype = this.subtype();
        Subtype subtype2 = bSONBinary.subtype();
        if (subtype == null) {
            if (subtype2 != null) {
                return false;
            }
        } else if (!subtype.equals(subtype2)) return false;
        ByteBuffer byteBuffer = this.value();
        ByteBuffer byteBuffer2 = bSONBinary.value();
        if (byteBuffer == null) {
            if (byteBuffer2 == null) return true;
        } else if (((Object)byteBuffer).equals(byteBuffer2)) return true;
        if (!ReadableBuffer$.MODULE$.equals$extension(ReadableBuffer$.MODULE$.duplicate$extension(this.value()), new ReadableBuffer(ReadableBuffer$.MODULE$.duplicate$extension(bSONBinary.value())))) return false;
        return true;
    }

    private String toString$lzycompute() {
        BSONBinary bSONBinary = this;
        synchronized (bSONBinary) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.toString = new StringBuilder(21).append("BSONBinary(").append(this.subtype()).append(", size = ").append(ReadableBuffer$.MODULE$.readable$extension(this.value())).append(")").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.toString;
    }

    public String toString() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.toString$lzycompute() : this.toString;
    }

    public BSONBinary(ByteBuffer value, Subtype subtype) {
        this.value = value;
        this.subtype = subtype;
        BSONValue.$init$(this);
        this.code = 5;
        this.byteCode = (byte)5;
    }
}

