/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.math.BigDecimal;
import java.math.MathContext;
import reactivemongo.api.bson.BSONDecimal;
import reactivemongo.api.bson.Decimal128$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

public final class BSONDecimal$ {
    public static BSONDecimal$ MODULE$;
    private final BSONDecimal PositiveInf;
    private final BSONDecimal NegativeInf;
    private final BSONDecimal NegativeNaN;
    private final BSONDecimal NaN;
    private final BSONDecimal PositiveZero;
    private final BSONDecimal NegativeZero;

    static {
        new BSONDecimal$();
    }

    public BSONDecimal apply(long high, long low) {
        return new BSONDecimal(high, low);
    }

    public Try<BSONDecimal> fromBigDecimal(BigDecimal value) {
        return Decimal128$.MODULE$.fromBigDecimal(value, value.signum() == -1);
    }

    public Try<BSONDecimal> fromBigDecimal(scala.math.BigDecimal value) {
        return Decimal128$.MODULE$.fromBigDecimal(value.bigDecimal(), value.signum() == -1);
    }

    public Try<BSONDecimal> fromLong(long high) {
        return this.fromBigDecimal(new BigDecimal(high, MathContext.DECIMAL128));
    }

    public Try<BSONDecimal> parse(String repr) {
        return Decimal128$.MODULE$.parse(repr);
    }

    public Try<scala.math.BigDecimal> toBigDecimal(BSONDecimal decimal) {
        return Decimal128$.MODULE$.toBigDecimal(decimal).map((Function1 & java.io.Serializable & Serializable)x$25 -> package$.MODULE$.BigDecimal().apply(x$25));
    }

    public Option<Tuple2<Object, Object>> unapply(Object that) {
        None$ none$;
        Object object = that;
        if (object instanceof BSONDecimal) {
            BSONDecimal bSONDecimal = (BSONDecimal)object;
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)bSONDecimal.high())), (Object)BoxesRunTime.boxToLong((long)bSONDecimal.low())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String pretty(BSONDecimal dec) {
        String string;
        Try<scala.math.BigDecimal> try_ = dec.asDecimal();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            scala.math.BigDecimal v = (scala.math.BigDecimal)success.value();
            string = new StringBuilder(15).append("NumberDecimal(").append(v).append(")").toString();
        } else {
            string = "NumberDecimal(NaN)";
        }
        return string;
    }

    public BSONDecimal PositiveInf() {
        return this.PositiveInf;
    }

    public BSONDecimal NegativeInf() {
        return this.NegativeInf;
    }

    public BSONDecimal NegativeNaN() {
        return this.NegativeNaN;
    }

    public BSONDecimal NaN() {
        return this.NaN;
    }

    public BSONDecimal PositiveZero() {
        return this.PositiveZero;
    }

    public BSONDecimal NegativeZero() {
        return this.NegativeZero;
    }

    private BSONDecimal$() {
        MODULE$ = this;
        this.PositiveInf = this.apply(Decimal128$.MODULE$.InfMask(), 0L);
        this.NegativeInf = this.apply(Decimal128$.MODULE$.InfMask() | Decimal128$.MODULE$.SignBitMask(), 0L);
        this.NegativeNaN = this.apply(Decimal128$.MODULE$.NaNMask() | Decimal128$.MODULE$.SignBitMask(), 0L);
        this.NaN = this.apply(Decimal128$.MODULE$.NaNMask(), 0L);
        this.PositiveZero = this.apply(0x3040000000000000L, 0L);
        this.NegativeZero = this.apply(-5746593124524752896L, 0L);
    }
}

