/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import reactivemongo.api.bson.BSONDecimal;
import reactivemongo.api.bson.BSONDecimal$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyInt;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Decimal128$ {
    public static Decimal128$ MODULE$;
    private final long InfMask;
    private final long NaNMask;
    private final long SignBitMask;
    private final int MinExponent;
    private final int MaxExponent;
    private final int ExponentOffset;
    private final int MaxBitLength;
    private final Set<String> PositiveInfStrings;
    private final Set<String> NegativeInfStrings;

    static {
        new Decimal128$();
    }

    public long InfMask() {
        return this.InfMask;
    }

    public long NaNMask() {
        return this.NaNMask;
    }

    public long SignBitMask() {
        return this.SignBitMask;
    }

    public Try<BSONDecimal> parse(String repr) {
        Object object;
        String normalized;
        String string = normalized = repr.toLowerCase();
        String string2 = "nan";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = new Try<BSONDecimal>((Object)BSONDecimal$.MODULE$.NaN());
        } else {
            String string3 = normalized;
            String string4 = "-nan";
            object = !(string3 != null ? !string3.equals(string4) : string4 != null) ? new Success((Object)BSONDecimal$.MODULE$.NegativeNaN()) : (this.PositiveInfStrings().contains((Object)normalized) ? new Success((Object)BSONDecimal$.MODULE$.PositiveInf()) : (this.NegativeInfStrings().contains((Object)normalized) ? new Success((Object)BSONDecimal$.MODULE$.NegativeInf()) : this.fromBigDecimal(new BigDecimal(repr), new StringOps(Predef$.MODULE$.augmentString(repr)).headOption().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Decimal128$.$anonfun$parse$1(BoxesRunTime.unboxToChar((Object)x$1)))))));
        }
        return object;
    }

    public Try<BSONDecimal> fromBigDecimal(BigDecimal value, boolean negative) {
        return this.clampRounded(value).flatMap((Function1 & Serializable & scala.Serializable)clamped -> {
            int exponent = -clamped.scale();
            return (exponent < MODULE$.MinExponent() || exponent > MODULE$.MaxExponent() ? new Failure((Throwable)new IllegalArgumentException(new StringBuilder(26).append("Exponent is out of range: ").append(exponent).toString())) : new Success((Object)clamped.unscaledValue())).flatMap((Function1 & Serializable & scala.Serializable)unscaled -> (unscaled.bitLength() > MODULE$.MaxBitLength() ? new Failure((Throwable)new IllegalArgumentException(new StringBuilder(34).append("Unscaled clamped is out of range: ").append(unscaled).toString())) : new Success((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
                BigInteger significand = unscaled.abs();
                int bitLength = significand.bitLength();
                int lowLimit = Math.min(64, bitLength);
                long localLow = this.computeLow$1(0, 0L, lowLimit, significand);
                long biasedExponent = exponent + MODULE$.ExponentOffset();
                long localHigh = this.computeHigh$1(64, 0L, bitLength, significand) | biasedExponent << 49;
                return clamped.signum() == -1 || negative ? BSONDecimal$.MODULE$.apply(localHigh | MODULE$.SignBitMask(), localLow) : BSONDecimal$.MODULE$.apply(localHigh, localLow);
            }));
        });
    }

    public Try<BigDecimal> toBigDecimal(BSONDecimal decimal) throws ArithmeticException {
        Object object;
        if (decimal.isNaN()) {
            object = new Failure((Throwable)new ArithmeticException("NaN can not be converted to a BigDecimal"));
        } else if (decimal.isInfinite()) {
            object = new Failure((Throwable)new ArithmeticException("Infinity can not be converted to a BigDecimal"));
        } else {
            BigDecimal bigDecimal = this.noNegativeZero(decimal);
            object = decimal.isNegative() && bigDecimal.signum() == 0 ? new Failure((Throwable)new ArithmeticException("Negative zero can not be converted to a BigDecimal")) : new Success((Object)bigDecimal);
        }
        return object;
    }

    private boolean highest(BSONDecimal decimal) {
        return (decimal.high() & 0x6000000000000000L) == 0x6000000000000000L;
    }

    public BigDecimal noNegativeZero(BSONDecimal decimal) {
        BigDecimal bigDecimal;
        boolean hest = this.highest(decimal);
        long exponent = hest ? ((decimal.high() & 0x1FFFE00000000000L) >>> 47) - (long)this.ExponentOffset() : ((decimal.high() & 0x7FFF800000000000L) >>> 49) - (long)this.ExponentOffset();
        int scale = -((int)exponent);
        if (hest) {
            bigDecimal = BigDecimal.valueOf(0L, scale);
        } else {
            int signum = decimal.isNegative() ? -1 : 1;
            bigDecimal = new BigDecimal(new BigInteger(signum, this.toBytes(decimal)), scale);
        }
        return bigDecimal;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] toBytes(BSONDecimal decimal) {
        void var2_2;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(15, ClassTag$.MODULE$.Byte());
        this.lowBytes$1(14, 255L, bytes, decimal);
        this.highBytes$1(6, 255L, bytes, decimal);
        bytes[0] = (byte)((decimal.high() & 0x1000000000000L) >>> 48);
        return var2_2;
    }

    public String toString(BSONDecimal decimal) {
        return decimal.isNaN() ? "NaN" : (decimal.isInfinite() ? (decimal.isNegative() ? "-Infinity" : "Infinity") : this.bigDecimalString(decimal));
    }

    private String bigDecimalString(BSONDecimal decimal) {
        scala.collection.mutable.StringBuilder stringBuilder;
        scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder();
        BigDecimal value = this.noNegativeZero(decimal);
        String significand = value.unscaledValue().abs().toString();
        Object object = decimal.isNegative() ? buffer.$plus$eq('-') : BoxedUnit.UNIT;
        int exponent = -value.scale();
        int normalizedExpo = exponent + (significand.length() - 1);
        if (exponent <= 0 && normalizedExpo >= -6) {
            if (exponent == 0) {
                stringBuilder = buffer.$plus$plus$eq(significand);
            } else {
                int pad = -exponent - significand.length();
                if (pad >= 0) {
                    buffer.$plus$plus$eq("0.");
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pad).foreach((Function1 & Serializable & scala.Serializable)x$2 -> buffer.$plus$eq('0'));
                    stringBuilder = buffer.appendAll((char[])new StringOps(Predef$.MODULE$.augmentString(significand)).toArray(ClassTag$.MODULE$.Char()), 0, significand.length());
                } else {
                    char[] sarray = (char[])new StringOps(Predef$.MODULE$.augmentString(significand)).toArray(ClassTag$.MODULE$.Char());
                    buffer.appendAll(sarray, 0, -pad);
                    buffer.$plus$eq('.');
                    stringBuilder = buffer.appendAll(sarray, -pad, RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(exponent)));
                }
            }
        } else {
            BoxedUnit boxedUnit;
            buffer.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(significand)).take(1));
            if (significand.length() > 1) {
                buffer.$plus$eq('.');
                boxedUnit = buffer.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(significand)).drop(1));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            buffer.$plus$eq('E');
            Object object2 = normalizedExpo > 0 ? buffer.$plus$eq('+') : BoxedUnit.UNIT;
            stringBuilder = buffer.$plus$plus$eq(Integer.toString(normalizedExpo));
        }
        return buffer.result();
    }

    private Try<BigDecimal> clampRounded(BigDecimal value) {
        Object object;
        int scale = value.scale();
        if (-scale > this.MaxExponent()) {
            LazyInt diff$lzy = new LazyInt();
            BigInteger unscaled = value.unscaledValue();
            object = unscaled.equals(BigInteger.ZERO) ? new Success((Object)new BigDecimal(unscaled, -this.MaxExponent())) : (this.diff$1(diff$lzy, scale) + value.precision() > 34 ? new Failure((Throwable)new NumberFormatException(new StringBuilder(26).append("Exponent is out of range: ").append(value).toString())) : Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> BigInteger.TEN.pow(this.diff$1(diff$lzy, scale))).map((Function1 & Serializable & scala.Serializable)multiplier -> new BigDecimal(unscaled.multiply((BigInteger)multiplier), scale + this.diff$1(diff$lzy, scale))));
        } else if (-scale < this.MinExponent()) {
            int diff = scale + this.MinExponent();
            Try<Object> undiscardedPrecision = this.exactRounding(value, diff);
            Try divisor = undiscardedPrecision.map((Function1 & Serializable & scala.Serializable)x0$1 -> Decimal128$.$anonfun$clampRounded$3(diff, BoxesRunTime.unboxToInt((Object)x0$1)));
            object = divisor.map((Function1 & Serializable & scala.Serializable)d -> new BigDecimal(value.unscaledValue().divide((BigInteger)d), scale - diff));
        } else {
            object = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> value.round(MathContext.DECIMAL128)).flatMap((Function1 & Serializable & scala.Serializable)rounded -> {
                int extraPrecision = value.precision() - rounded.precision();
                return extraPrecision > 0 ? MODULE$.exactRounding(value, extraPrecision).map((Function1 & Serializable & scala.Serializable)x$3 -> rounded) : new Success(rounded);
            });
        }
        return object;
    }

    private Try<Object> exactRounding(BigDecimal value, int precision) {
        String significand = value.unscaledValue().abs().toString();
        int undiscardedPrecision = Math.max(0, significand.length() - precision);
        int limit = significand.length();
        return this.ensure$1(undiscardedPrecision, limit, undiscardedPrecision, significand, value);
    }

    public int MinExponent() {
        return this.MinExponent;
    }

    public int MaxExponent() {
        return this.MaxExponent;
    }

    public int ExponentOffset() {
        return this.ExponentOffset;
    }

    public int MaxBitLength() {
        return this.MaxBitLength;
    }

    public Set<String> PositiveInfStrings() {
        return this.PositiveInfStrings;
    }

    public Set<String> NegativeInfStrings() {
        return this.NegativeInfStrings;
    }

    public static final /* synthetic */ boolean $anonfun$parse$1(char x$1) {
        return x$1 == '-';
    }

    private final long computeLow$1(int i, long localLow, int lowLimit$1, BigInteger significand$1) {
        while (i != lowLimit$1) {
            long upd;
            localLow = upd = significand$1.testBit(i) ? localLow | 1L << i : localLow;
            ++i;
        }
        return localLow;
    }

    private final long computeHigh$1(int i, long localHigh, int bitLength$1, BigInteger significand$1) {
        while (i < bitLength$1) {
            long upd;
            localHigh = upd = significand$1.testBit(i) ? localHigh | 1L << i - 64 : localHigh;
            ++i;
        }
        return localHigh;
    }

    private final void lowBytes$1(int i, long mask, byte[] bytes$1, BSONDecimal decimal$1) {
        while (i >= 7) {
            bytes$1[i] = (byte)((decimal$1.low() & mask) >>> (14 - i << 3));
            mask <<= 8;
            --i;
        }
    }

    private final void highBytes$1(int i, long mask, byte[] bytes$1, BSONDecimal decimal$1) {
        while (i >= 1) {
            bytes$1[i] = (byte)((decimal$1.high() & mask) >>> (6 - i << 3));
            mask <<= 8;
            --i;
        }
    }

    private final /* synthetic */ int diff$lzycompute$1(LazyInt diff$lzy$1, int scale$1) {
        int n;
        LazyInt lazyInt = diff$lzy$1;
        synchronized (lazyInt) {
            n = diff$lzy$1.initialized() ? diff$lzy$1.value() : diff$lzy$1.initialize(-scale$1 - this.MaxExponent());
        }
        return n;
    }

    private final int diff$1(LazyInt diff$lzy$1, int scale$1) {
        return diff$lzy$1.initialized() ? diff$lzy$1.value() : this.diff$lzycompute$1(diff$lzy$1, scale$1);
    }

    public static final /* synthetic */ BigInteger $anonfun$clampRounded$3(int diff$2, int x0$1) {
        BigInteger bigInteger;
        int n = x0$1;
        switch (n) {
            case 0: {
                bigInteger = BigInteger.ONE;
                break;
            }
            default: {
                bigInteger = BigInteger.TEN.pow(diff$2);
                break;
            }
        }
        return bigInteger;
    }

    public static final /* synthetic */ boolean $anonfun$exactRounding$1(char x$4) {
        return x$4 == '0';
    }

    private final Try ensure$1(int i, int limit$1, int undiscardedPrecision$1, String significand$2, BigDecimal value$2) {
        Success success;
        while (true) {
            if (i == limit$1) {
                success = new Success((Object)BoxesRunTime.boxToInteger((int)undiscardedPrecision$1));
                break;
            }
            if (!new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(significand$2)).drop(i))).headOption().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Decimal128$.$anonfun$exactRounding$1(BoxesRunTime.unboxToChar((Object)x$4))))) {
                success = new Failure((Throwable)new NumberFormatException(new StringBuilder(20).append("Inexact rounding of ").append(value$2).toString()));
                break;
            }
            ++i;
        }
        return success;
    }

    private Decimal128$() {
        MODULE$ = this;
        this.InfMask = 0x7800000000000000L;
        this.NaNMask = 0x7C00000000000000L;
        this.SignBitMask = Long.MIN_VALUE;
        this.MinExponent = -6176;
        this.MaxExponent = 6111;
        this.ExponentOffset = 6176;
        this.MaxBitLength = 113;
        this.PositiveInfStrings = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inf", "+inf", "infinity", "+infinity"}));
        this.NegativeInfStrings = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-inf", "-infinity"}));
    }
}

