/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.bson;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import reactivemongo.bson.BSONObjectID;
import reactivemongo.bson.utils.Converters$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;

public final class BSONObjectID$
implements Serializable {
    public static final BSONObjectID$ MODULE$;
    private final int maxCounterValue;
    private final AtomicInteger increment;
    private final byte[] machineId;

    static {
        new BSONObjectID$();
    }

    public BSONObjectID apply(byte[] array) {
        if (array.length != 12) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wrong byte array for an ObjectId (size ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)array.length)})));
        }
        return new BSONObjectID(Arrays.copyOf(array, 12));
    }

    public Option<byte[]> unapply(BSONObjectID id) {
        return new Some((Object)id.valueAsArray());
    }

    public Try<BSONObjectID> parse(String id) {
        return id.length() != 24 ? new Failure((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ObjectId (length != 24): '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})))) : Try$.MODULE$.apply((Function0)new Serializable(id){
            public static final long serialVersionUID = 0L;
            private final String id$1;

            public final BSONObjectID apply() {
                return new BSONObjectID(Converters$.MODULE$.str2Hex(this.id$1));
            }
            {
                this.id$1 = id$1;
            }
        });
    }

    public BSONObjectID generate() {
        return this.fromTime(System.currentTimeMillis(), false);
    }

    public BSONObjectID fromTime(long timeMillis, boolean fillOnlyTimestamp) {
        byte[] id = new byte[12];
        int timestamp = (int)(timeMillis / 1000L);
        id[0] = (byte)(timestamp >>> 24);
        id[1] = (byte)(timestamp >> 16 & 0xFF);
        id[2] = (byte)(timestamp >> 8 & 0xFF);
        id[3] = (byte)(timestamp & 0xFF);
        if (!fillOnlyTimestamp) {
            id[4] = this.machineId()[0];
            id[5] = this.machineId()[1];
            id[6] = this.machineId()[2];
            int pid = System.identityHashCode(this);
            id[7] = (byte)(pid & 0xFF);
            id[8] = (byte)(pid >> 8 & 0xFF);
            int c = this.counter();
            id[9] = (byte)(c >> 16 & 0xFF);
            id[10] = (byte)(c >> 8 & 0xFF);
            id[11] = (byte)(c & 0xFF);
        }
        return this.apply(id);
    }

    public boolean fromTime$default$2() {
        return true;
    }

    private int maxCounterValue() {
        return this.maxCounterValue;
    }

    private AtomicInteger increment() {
        return this.increment;
    }

    private int counter() {
        return (this.increment().getAndIncrement() + this.maxCounterValue()) % this.maxCounterValue();
    }

    private byte[] machineId() {
        return this.machineId;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final String reactivemongo$bson$BSONObjectID$$p$1(String n) {
        return System.getProperty(n);
    }

    private BSONObjectID$() {
        byte[] byArray;
        MODULE$ = this;
        this.maxCounterValue = 0x1000000;
        this.increment = new AtomicInteger(Random$.MODULE$.nextInt(this.maxCounterValue()));
        boolean validPlatform = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean correctVersion = (double)new StringOps(Predef$.MODULE$.augmentString(BSONObjectID$.MODULE$.reactivemongo$bson$BSONObjectID$$p$1("java.version").substring(0, 3))).toFloat() >= 1.8;
                boolean noIpv6 = new StringOps(Predef$.MODULE$.augmentString(BSONObjectID$.MODULE$.reactivemongo$bson$BSONObjectID$$p$1("java.net.preferIPv4Stack"))).toBoolean();
                String string = BSONObjectID$.MODULE$.reactivemongo$bson$BSONObjectID$$p$1("os.name");
                boolean isLinux = string != null && string.equals("Linux");
                return !isLinux || correctVersion || noIpv6;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        SecurityManager sec = System.getSecurityManager();
        boolean permitted = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(sec){
            public static final long serialVersionUID = 0L;
            private final SecurityManager sec$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.sec$1.checkPermission(new NetPermission("getNetworkInformation"));
            }
            {
                this.sec$1 = sec$1;
            }
        }).toOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BoxedUnit x$11) {
                return true;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        if (validPlatform && permitted) {
            Enumeration<NetworkInterface> networkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            Iterator networkInterfaces = (Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(networkInterfacesEnum).asScala();
            byte[] ha = (byte[])networkInterfaces.find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(NetworkInterface ha) {
                    return Try$.MODULE$.apply((Function0)new Serializable(this, ha){
                        public static final long serialVersionUID = 0L;
                        private final NetworkInterface ha$1;

                        public final byte[] apply() {
                            return this.ha$1.getHardwareAddress();
                        }
                        {
                            this.ha$1 = ha$1;
                        }
                    }).isSuccess() && ha.getHardwareAddress() != null && ha.getHardwareAddress().length == 6;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(NetworkInterface x$12) {
                    return x$12.getHardwareAddress();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte[] apply() {
                    return InetAddress.getLocalHost().getHostName().getBytes("UTF-8");
                }
            });
            byArray = (byte[])Predef$.MODULE$.byteArrayOps(Converters$.MODULE$.md5(ha)).take(3);
        } else {
            int threadId = (int)Thread.currentThread().getId();
            byte[] arr = new byte[]{(byte)(threadId & 0xFF), (byte)(threadId >> 8 & 0xFF), (byte)(threadId >> 16 & 0xFF)};
            byArray = arr;
        }
        this.machineId = byArray;
    }
}

