/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.bson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import reactivemongo.bson.BSONDecimal;
import reactivemongo.bson.BSONDecimal$;
import reactivemongo.bson.Decimal128$;
import reactivemongo.bson.Decimal128$$anonfun$fromBigDecimal$1$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileByteRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Decimal128$ {
    public static final Decimal128$ MODULE$;
    private final long InfMask;
    private final long NaNMask;
    private final long SignBitMask;
    private final int MinExponent;
    private final int MaxExponent;
    private final int ExponentOffset;
    private final int MaxBitLength;
    private final Set<String> PositiveInfStrings;
    private final Set<String> NegativeInfStrings;

    static {
        new Decimal128$();
    }

    public long InfMask() {
        return this.InfMask;
    }

    public long NaNMask() {
        return this.NaNMask;
    }

    public long SignBitMask() {
        return this.SignBitMask;
    }

    public Try<BSONDecimal> parse(String repr) {
        Object object;
        String normalized;
        String string = normalized = repr.toLowerCase();
        if (string != null && string.equals("nan")) {
            object = new Try<BSONDecimal>((Object)BSONDecimal$.MODULE$.NaN());
        } else {
            String string2 = normalized;
            object = string2 != null && string2.equals("-nan") ? new Success((Object)BSONDecimal$.MODULE$.NegativeNaN()) : (this.PositiveInfStrings().contains((Object)normalized) ? new Success((Object)BSONDecimal$.MODULE$.PositiveInf()) : (this.NegativeInfStrings().contains((Object)normalized) ? new Success((Object)BSONDecimal$.MODULE$.NegativeInf()) : this.fromBigDecimal(new BigDecimal(repr), new StringOps(Predef$.MODULE$.augmentString(repr)).headOption().exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$1) {
                    return x$1 == '-';
                }
            }))));
        }
        return object;
    }

    public Try<BSONDecimal> fromBigDecimal(BigDecimal value, boolean negative) {
        return this.clampRounded(value).flatMap((Function1)new Serializable(negative){
            public static final long serialVersionUID = 0L;
            public final boolean negative$1;

            public final Try<BSONDecimal> apply(BigDecimal clamped) {
                int exponent = -clamped.scale();
                return ((Try)(exponent < Decimal128$.MODULE$.MinExponent() || exponent > Decimal128$.MODULE$.MaxExponent() ? new Failure((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exponent is out of range: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)exponent)})))) : new Success((Object)clamped.unscaledValue()))).flatMap((Function1)new Serializable(this, exponent, clamped){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.fromBigDecimal.1 $outer;
                    public final int exponent$1;
                    public final BigDecimal clamped$1;

                    public final Try<BSONDecimal> apply(BigInteger unscaled) {
                        return ((Try)(unscaled.bitLength() > Decimal128$.MODULE$.MaxBitLength() ? new Failure((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unscaled clamped is out of range: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unscaled})))) : new Success((Object)BoxedUnit.UNIT))).map((Function1)new Serializable(this, unscaled){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$fromBigDecimal$1$$anonfun$apply$1 $outer;
                            private final BigInteger unscaled$2;

                            public final BSONDecimal apply(BoxedUnit _) {
                                BigInteger significand = this.unscaled$2.abs();
                                int bitLength = significand.bitLength();
                                int lowLimit = Math.min(64, bitLength);
                                long localLow = this.computeLow$1(0, 0L, significand, lowLimit);
                                long biasedExponent = this.$outer.exponent$1 + Decimal128$.MODULE$.ExponentOffset();
                                long localHigh = this.computeHigh$1(64, 0L, significand, bitLength) | biasedExponent << 49;
                                return this.$outer.clamped$1.signum() == -1 || this.$outer.reactivemongo$bson$Decimal128$$anonfun$$anonfun$$$outer().negative$1 ? BSONDecimal$.MODULE$.apply(localHigh | Decimal128$.MODULE$.SignBitMask(), localLow) : BSONDecimal$.MODULE$.apply(localHigh, localLow);
                            }

                            private final long computeLow$1(int i, long localLow, BigInteger significand$1, int lowLimit$1) {
                                while (i != lowLimit$1) {
                                    long upd;
                                    localLow = upd = significand$1.testBit(i) ? localLow | 1L << i : localLow;
                                    ++i;
                                }
                                return localLow;
                            }

                            private final long computeHigh$1(int i, long localHigh, BigInteger significand$1, int bitLength$1) {
                                while (i < bitLength$1) {
                                    long upd;
                                    localHigh = upd = significand$1.testBit(i) ? localHigh | 1L << i - 64 : localHigh;
                                    ++i;
                                }
                                return localHigh;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.unscaled$2 = unscaled$2;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.fromBigDecimal.1 reactivemongo$bson$Decimal128$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.exponent$1 = exponent$1;
                        this.clamped$1 = clamped$1;
                    }
                });
            }
            {
                this.negative$1 = negative$1;
            }
        });
    }

    public Try<BigDecimal> toBigDecimal(BSONDecimal decimal) throws ArithmeticException {
        Object object;
        if (decimal.isNaN()) {
            object = new Failure((Throwable)new ArithmeticException("NaN can not be converted to a BigDecimal"));
        } else if (decimal.isInfinite()) {
            object = new Failure((Throwable)new ArithmeticException("Infinity can not be converted to a BigDecimal"));
        } else {
            BigDecimal bigDecimal = this.noNegativeZero(decimal);
            object = decimal.isNegative() && bigDecimal.signum() == 0 ? new Failure((Throwable)new ArithmeticException("Negative zero can not be converted to a BigDecimal")) : new Success((Object)bigDecimal);
        }
        return object;
    }

    private boolean highest(BSONDecimal decimal) {
        return (decimal.high() & 0x6000000000000000L) == 0x6000000000000000L;
    }

    public BigDecimal noNegativeZero(BSONDecimal decimal) {
        BigDecimal bigDecimal;
        boolean hest = this.highest(decimal);
        long exponent = hest ? ((decimal.high() & 0x1FFFE00000000000L) >>> 47) - (long)this.ExponentOffset() : ((decimal.high() & 0x7FFF800000000000L) >>> 49) - (long)this.ExponentOffset();
        int scale = -((int)exponent);
        if (hest) {
            bigDecimal = BigDecimal.valueOf(0L, scale);
        } else {
            int signum = decimal.isNegative() ? -1 : 1;
            bigDecimal = new BigDecimal(new BigInteger(signum, this.toBytes(decimal)), scale);
        }
        return bigDecimal;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] toBytes(BSONDecimal decimal) {
        void var2_2;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(15, ClassTag$.MODULE$.Byte());
        this.lowBytes$1(14, 255L, decimal, bytes);
        this.highBytes$1(6, 255L, decimal, bytes);
        bytes[0] = (byte)((decimal.high() & 0x1000000000000L) >>> 48);
        return var2_2;
    }

    public String toString(BSONDecimal decimal) {
        return decimal.isNaN() ? "NaN" : (decimal.isInfinite() ? (decimal.isNegative() ? "-Infinity" : "Infinity") : this.bigDecimalString(decimal));
    }

    private String bigDecimalString(BSONDecimal decimal) {
        StringBuilder stringBuilder;
        StringBuilder buffer = package$.MODULE$.StringBuilder().newBuilder();
        BigDecimal value = this.noNegativeZero(decimal);
        String significand = value.unscaledValue().abs().toString();
        Object object = decimal.isNegative() ? buffer.$plus$eq('-') : BoxedUnit.UNIT;
        int exponent = -value.scale();
        int normalizedExpo = exponent + (significand.length() - 1);
        if (exponent <= 0 && normalizedExpo >= -6) {
            if (exponent == 0) {
                stringBuilder = buffer.$plus$plus$eq(significand);
            } else {
                int pad = -exponent - significand.length();
                if (pad >= 0) {
                    buffer.$plus$plus$eq("0.");
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pad).foreach((Function1)new Serializable(buffer){
                        public static final long serialVersionUID = 0L;
                        private final StringBuilder buffer$1;

                        public final StringBuilder apply(int i) {
                            return this.buffer$1.$plus$eq('0');
                        }
                        {
                            this.buffer$1 = buffer$1;
                        }
                    });
                    stringBuilder = buffer.appendAll((char[])new StringOps(Predef$.MODULE$.augmentString(significand)).toArray(ClassTag$.MODULE$.Char()), 0, significand.length());
                } else {
                    char[] sarray = (char[])new StringOps(Predef$.MODULE$.augmentString(significand)).toArray(ClassTag$.MODULE$.Char());
                    buffer.appendAll(sarray, 0, -pad);
                    buffer.$plus$eq('.');
                    stringBuilder = buffer.appendAll(sarray, -pad, RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(exponent)));
                }
            }
        } else {
            BoxedUnit boxedUnit;
            buffer.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(significand)).take(1));
            if (significand.length() > 1) {
                buffer.$plus$eq('.');
                boxedUnit = buffer.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(significand)).drop(1));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            buffer.$plus$eq('E');
            Object object2 = normalizedExpo > 0 ? buffer.$plus$eq('+') : BoxedUnit.UNIT;
            stringBuilder = buffer.$plus$plus$eq(((Object)BoxesRunTime.boxToInteger((int)normalizedExpo)).toString());
        }
        return buffer.result();
    }

    private Try<BigDecimal> clampRounded(BigDecimal value) {
        Object object;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        int scale = value.scale();
        if (-scale > this.MaxExponent()) {
            IntRef diff$lzy = IntRef.zero();
            BigInteger unscaled = value.unscaledValue();
            object = unscaled.equals(BigInteger.ZERO) ? new Success((Object)new BigDecimal(unscaled, -this.MaxExponent())) : (this.reactivemongo$bson$Decimal128$$diff$1(scale, diff$lzy, bitmap$0) + value.precision() > 34 ? new Failure((Throwable)new NumberFormatException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exponent is out of range: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})))) : Try$.MODULE$.apply((Function0)new Serializable(scale, diff$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final int scale$1;
                private final IntRef diff$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final BigInteger apply() {
                    return BigInteger.TEN.pow(Decimal128$.MODULE$.reactivemongo$bson$Decimal128$$diff$1(this.scale$1, this.diff$lzy$1, this.bitmap$0$1));
                }
                {
                    this.scale$1 = scale$1;
                    this.diff$lzy$1 = diff$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).map((Function1)new Serializable(scale, diff$lzy, unscaled, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final int scale$1;
                private final IntRef diff$lzy$1;
                private final BigInteger unscaled$1;
                private final VolatileByteRef bitmap$0$1;

                public final BigDecimal apply(BigInteger multiplier) {
                    return new BigDecimal(this.unscaled$1.multiply(multiplier), this.scale$1 + Decimal128$.MODULE$.reactivemongo$bson$Decimal128$$diff$1(this.scale$1, this.diff$lzy$1, this.bitmap$0$1));
                }
                {
                    this.scale$1 = scale$1;
                    this.diff$lzy$1 = diff$lzy$1;
                    this.unscaled$1 = unscaled$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }));
        } else if (-scale < this.MinExponent()) {
            int diff = scale + this.MinExponent();
            Try<Object> undiscardedPrecision = this.reactivemongo$bson$Decimal128$$exactRounding(value, diff);
            Try divisor = undiscardedPrecision.map((Function1)new Serializable(diff){
                public static final long serialVersionUID = 0L;
                private final int diff$2;

                public final BigInteger apply(int x0$1) {
                    BigInteger bigInteger;
                    switch (x0$1) {
                        default: {
                            bigInteger = BigInteger.TEN.pow(this.diff$2);
                            break;
                        }
                        case 0: {
                            bigInteger = BigInteger.ONE;
                        }
                    }
                    return bigInteger;
                }
                {
                    this.diff$2 = diff$2;
                }
            });
            object = divisor.map((Function1)new Serializable(value, scale, diff){
                public static final long serialVersionUID = 0L;
                private final BigDecimal value$1;
                private final int scale$1;
                private final int diff$2;

                public final BigDecimal apply(BigInteger d) {
                    return new BigDecimal(this.value$1.unscaledValue().divide(d), this.scale$1 - this.diff$2);
                }
                {
                    this.value$1 = value$1;
                    this.scale$1 = scale$1;
                    this.diff$2 = diff$2;
                }
            });
        } else {
            object = Try$.MODULE$.apply((Function0)new Serializable(value){
                public static final long serialVersionUID = 0L;
                private final BigDecimal value$1;

                public final BigDecimal apply() {
                    return this.value$1.round(MathContext.DECIMAL128);
                }
                {
                    this.value$1 = value$1;
                }
            }).flatMap((Function1)new Serializable(value){
                public static final long serialVersionUID = 0L;
                private final BigDecimal value$1;

                public final Try<BigDecimal> apply(BigDecimal rounded) {
                    int extraPrecision = this.value$1.precision() - rounded.precision();
                    return extraPrecision > 0 ? Decimal128$.MODULE$.reactivemongo$bson$Decimal128$$exactRounding(this.value$1, extraPrecision).map((Function1)new Serializable(this, rounded){
                        public static final long serialVersionUID = 0L;
                        private final BigDecimal rounded$1;

                        public final BigDecimal apply(int x$2) {
                            return this.rounded$1;
                        }
                        {
                            this.rounded$1 = rounded$1;
                        }
                    }) : new Success((Object)rounded);
                }
                {
                    this.value$1 = value$1;
                }
            });
        }
        return object;
    }

    public Try<Object> reactivemongo$bson$Decimal128$$exactRounding(BigDecimal value, int precision) {
        String significand = value.unscaledValue().abs().toString();
        int undiscardedPrecision = Math.max(0, significand.length() - precision);
        int limit = significand.length();
        return this.ensure$1(undiscardedPrecision, value, significand, undiscardedPrecision, limit);
    }

    public int MinExponent() {
        return this.MinExponent;
    }

    public int MaxExponent() {
        return this.MaxExponent;
    }

    public int ExponentOffset() {
        return this.ExponentOffset;
    }

    public int MaxBitLength() {
        return this.MaxBitLength;
    }

    public Set<String> PositiveInfStrings() {
        return this.PositiveInfStrings;
    }

    public Set<String> NegativeInfStrings() {
        return this.NegativeInfStrings;
    }

    private final void lowBytes$1(int i, long mask, BSONDecimal decimal$1, byte[] bytes$1) {
        while (i >= 7) {
            bytes$1[i] = (byte)((decimal$1.low() & mask) >>> (14 - i << 3));
            mask <<= 8;
            --i;
        }
    }

    private final void highBytes$1(int i, long mask, BSONDecimal decimal$1, byte[] bytes$1) {
        while (i >= 1) {
            bytes$1[i] = (byte)((decimal$1.high() & mask) >>> (6 - i << 3));
            mask <<= 8;
            --i;
        }
    }

    private final int diff$lzycompute$1(int scale$1, IntRef diff$lzy$1, VolatileByteRef bitmap$0$1) {
        Decimal128$ decimal128$ = this;
        synchronized (decimal128$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                diff$lzy$1.elem = -scale$1 - this.MaxExponent();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return diff$lzy$1.elem;
        }
    }

    public final int reactivemongo$bson$Decimal128$$diff$1(int scale$1, IntRef diff$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.diff$lzycompute$1(scale$1, diff$lzy$1, bitmap$0$1) : diff$lzy$1.elem;
    }

    private final Try ensure$1(int i, BigDecimal value$2, String significand$2, int undiscardedPrecision$1, int limit$1) {
        Success success;
        block2: {
            while (true) {
                if (i == limit$1) {
                    success = new Success((Object)BoxesRunTime.boxToInteger((int)undiscardedPrecision$1));
                    break block2;
                }
                if (!new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(significand$2)).drop(i))).headOption().exists((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$3) {
                        return x$3 == '0';
                    }
                })) break;
                ++i;
            }
            success = new Failure((Throwable)new NumberFormatException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inexact rounding of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value$2}))));
        }
        return success;
    }

    private Decimal128$() {
        MODULE$ = this;
        this.InfMask = 0x7800000000000000L;
        this.NaNMask = 0x7C00000000000000L;
        this.SignBitMask = Long.MIN_VALUE;
        this.MinExponent = -6176;
        this.MaxExponent = 6111;
        this.ExponentOffset = 6176;
        this.MaxBitLength = 113;
        this.PositiveInfStrings = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inf", "+inf", "infinity", "+infinity"}));
        this.NegativeInfStrings = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-inf", "-infinity"}));
    }
}

