/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson.collection;

import java.io.Serializable;
import java.nio.ByteBuffer;
import reactivemongo.api.SerializationPack;
import reactivemongo.api.bson.BSONDocument;
import reactivemongo.api.bson.BSONDocument$;
import reactivemongo.api.bson.BSONDocumentReader;
import reactivemongo.api.bson.BSONDocumentReader$;
import reactivemongo.api.bson.BSONDocumentWriter;
import reactivemongo.api.bson.BSONDocumentWriter$;
import reactivemongo.api.bson.BSONReader;
import reactivemongo.api.bson.BSONReader$;
import reactivemongo.api.bson.BSONValue;
import reactivemongo.api.bson.buffer.ReadableBuffer$;
import reactivemongo.api.bson.collection.BSONSerializationPack$Builder$;
import reactivemongo.api.bson.collection.BSONSerializationPack$Decoder$;
import reactivemongo.api.bson.package$;
import reactivemongo.core.protocol.Response;
import reactivemongo.io.netty.buffer.ByteBuf;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class BSONSerializationPack$
implements SerializationPack {
    public static BSONSerializationPack$ MODULE$;
    private BSONDocumentReader<BSONDocument> IdentityReader;
    private BSONDocumentWriter<BSONDocument> IdentityWriter;
    private final ClassTag<BSONDocument> IsDocument;
    private final ClassTag<BSONValue> IsValue;
    private final BSONReader<BSONValue> narrowIdentityReader;
    private final SerializationPack.Builder<BSONSerializationPack$> newBuilder;
    private final SerializationPack.Decoder<BSONSerializationPack$> newDecoder;
    private volatile byte bitmap$0;

    static {
        new BSONSerializationPack$();
    }

    @Override
    public final <A> A readAndDeserialize(ByteBuffer buffer, Object reader) {
        return (A)SerializationPack.readAndDeserialize$((SerializationPack)this, buffer, reader);
    }

    @Override
    public final <A> ByteBuf serializeAndWrite(ByteBuf buffer, A document, Object writer) {
        return SerializationPack.serializeAndWrite$(this, buffer, document, writer);
    }

    @Override
    public final <A> Object readerOpt(Function1<Object, Option<A>> f) {
        return SerializationPack.readerOpt$(this, f);
    }

    public ClassTag<BSONDocument> IsDocument() {
        return this.IsDocument;
    }

    public ClassTag<BSONValue> IsValue() {
        return this.IsValue;
    }

    private BSONDocumentReader<BSONDocument> IdentityReader$lzycompute() {
        BSONSerializationPack$ bSONSerializationPack$ = this;
        synchronized (bSONSerializationPack$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.IdentityReader = package$.MODULE$.bsonDocumentReader();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.IdentityReader;
    }

    public BSONDocumentReader<BSONDocument> IdentityReader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.IdentityReader$lzycompute() : this.IdentityReader;
    }

    private BSONDocumentWriter<BSONDocument> IdentityWriter$lzycompute() {
        BSONSerializationPack$ bSONSerializationPack$ = this;
        synchronized (bSONSerializationPack$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.IdentityWriter = package$.MODULE$.bsonDocumentWriter();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.IdentityWriter;
    }

    public BSONDocumentWriter<BSONDocument> IdentityWriter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.IdentityWriter$lzycompute() : this.IdentityWriter;
    }

    public <A> BSONDocument serialize(A a, BSONDocumentWriter<A> writer) {
        BSONDocument doc;
        Try try_ = writer.writeTry(a);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                throw cause;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        BSONDocument bSONDocument = doc = (BSONDocument)success.value();
        return bSONDocument;
    }

    public <A> A deserialize(BSONDocument document, BSONDocumentReader<A> reader) {
        Object a;
        Try try_ = reader.readTry((BSONValue)document);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                throw cause;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Object object = a = success.value();
        return (A)object;
    }

    public ByteBuf writeToBuffer(ByteBuf buffer, BSONDocument document) {
        return reactivemongo.api.bson.buffer.package$.MODULE$.DefaultBufferHandler().writeDocument(document, buffer);
    }

    public BSONDocument readFromBuffer(ByteBuffer buffer) {
        return reactivemongo.api.bson.buffer.package$.MODULE$.DefaultBufferHandler().readDocument(buffer);
    }

    public <A> A readAndDeserialize(Response response, BSONDocumentReader<A> reader) {
        A a;
        Response response2 = response;
        if (response2 instanceof Response.Successful) {
            A a2;
            Response.Successful successful = (Response.Successful)response2;
            ByteBuf docs = successful._documents();
            Option<BSONDocument> option = successful.first();
            if (option instanceof Some) {
                Some some = (Some)option;
                BSONDocument preloaded = (BSONDocument)some.value();
                a2 = this.deserialize(preloaded, reader);
            } else {
                a2 = this.readAndDeserialize(ReadableBuffer$.MODULE$.apply(docs), reader);
            }
            a = a2;
        } else {
            a = this.readAndDeserialize(ReadableBuffer$.MODULE$.apply(response.documents()), reader);
        }
        return a;
    }

    public <A> BSONDocumentWriter<A> writer(Function1<A, BSONDocument> f) {
        return BSONDocumentWriter$.MODULE$.apply(f);
    }

    public boolean isEmpty(BSONDocument document) {
        return document.isEmpty();
    }

    public <T> BSONReader<T> widenReader(BSONReader<T> r) {
        return r;
    }

    public <A> Try<A> readValue(BSONValue value2, BSONReader<A> reader) {
        return reader.readTry(value2);
    }

    public <A> BSONDocumentReader<A> reader(Function1<BSONDocument, A> f) {
        return BSONDocumentReader$.MODULE$.apply(f);
    }

    public <A, B> BSONDocumentReader<B> afterReader(BSONDocumentReader<A> r, Function1<A, B> f) {
        return r.afterRead(f);
    }

    public int bsonSize(BSONValue value2) {
        return value2.byteSize();
    }

    public BSONReader<BSONValue> narrowIdentityReader() {
        return this.narrowIdentityReader;
    }

    public SerializationPack.Builder<BSONSerializationPack$> newBuilder() {
        return this.newBuilder;
    }

    public SerializationPack.Decoder<BSONSerializationPack$> newDecoder() {
        return this.newDecoder;
    }

    public String pretty(BSONDocument doc) {
        return BSONDocument$.MODULE$.pretty(doc);
    }

    private BSONSerializationPack$() {
        MODULE$ = this;
        SerializationPack.$init$(this);
        this.IsDocument = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(BSONDocument.class));
        this.IsValue = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(BSONValue.class));
        this.narrowIdentityReader = BSONReader$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x -> (BSONValue)Predef$.MODULE$.identity(x));
        this.newBuilder = BSONSerializationPack$Builder$.MODULE$;
        this.newDecoder = BSONSerializationPack$Decoder$.MODULE$;
    }
}

