/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel;

import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelException;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.CompleteChannelFuture;

public class FailedChannelFuture
extends CompleteChannelFuture {
    private final Throwable cause;

    public FailedChannelFuture(Channel channel, Throwable cause) {
        super(channel);
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isSuccess() {
        return false;
    }

    public ChannelFuture sync() throws InterruptedException {
        this.rethrow();
        return this;
    }

    public ChannelFuture syncUninterruptibly() {
        this.rethrow();
        return this;
    }

    private void rethrow() {
        if (this.cause instanceof RuntimeException) {
            throw (RuntimeException)this.cause;
        }
        if (this.cause instanceof Error) {
            throw (Error)this.cause;
        }
        throw new ChannelException(this.cause);
    }
}

