/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import shaded.netty.channel.ChannelException;
import shaded.netty.channel.ChannelFactory;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.ChannelSink;
import shaded.netty.channel.Channels;
import shaded.netty.channel.socket.nio.NioSocketChannel;
import shaded.netty.channel.socket.nio.NioWorker;
import shaded.netty.logging.InternalLogger;
import shaded.netty.logging.InternalLoggerFactory;
import shaded.netty.util.Timeout;

final class NioClientSocketChannel
extends NioSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketChannel.class);
    volatile ChannelFuture connectFuture;
    volatile boolean boundManually;
    long connectDeadlineNanos;
    volatile SocketAddress requestedRemoteAddress;
    volatile Timeout timoutTimer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SocketChannel newSocket() {
        SocketChannel socket;
        try {
            socket = SocketChannel.open();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
        boolean success = false;
        try {
            try {
                socket.configureBlocking(false);
                return socket;
            }
            catch (IOException e) {
                throw new ChannelException("Failed to enter non-blocking mode.", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (success) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) throw throwable;
                logger.warn("Failed to close a partially initialized socket.", e);
            }
            throw throwable;
        }
    }

    NioClientSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioWorker worker) {
        super(null, factory, pipeline, sink, NioClientSocketChannel.newSocket(), worker);
        Channels.fireChannelOpen(this);
    }
}

