/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel.socket.nio;

import java.net.SocketAddress;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelEvent;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.ChannelState;
import shaded.netty.channel.ChannelStateEvent;
import shaded.netty.channel.MessageEvent;
import shaded.netty.channel.socket.nio.AbstractNioChannelSink;
import shaded.netty.channel.socket.nio.NioServerBoss;
import shaded.netty.channel.socket.nio.NioServerSocketChannel;
import shaded.netty.channel.socket.nio.NioSocketChannel;

class NioServerSocketPipelineSink
extends AbstractNioChannelSink {
    NioServerSocketPipelineSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            NioServerSocketPipelineSink.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            NioServerSocketPipelineSink.handleAcceptedSocket(e);
        }
    }

    private static void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    ((NioServerBoss)channel.boss).bind(channel, future, (SocketAddress)value);
                    break;
                }
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }
}

