/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel.socket.oio;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.socket.DatagramChannel;
import shaded.netty.channel.socket.DatagramChannelFactory;
import shaded.netty.channel.socket.oio.OioDatagramChannel;
import shaded.netty.channel.socket.oio.OioDatagramPipelineSink;
import shaded.netty.util.ThreadNameDeterminer;
import shaded.netty.util.internal.ExecutorUtil;

public class OioDatagramChannelFactory
implements DatagramChannelFactory {
    private final Executor workerExecutor;
    final OioDatagramPipelineSink sink;
    private boolean shutdownExecutor;

    public OioDatagramChannelFactory() {
        this(Executors.newCachedThreadPool());
        this.shutdownExecutor = true;
    }

    public OioDatagramChannelFactory(Executor workerExecutor) {
        this(workerExecutor, null);
    }

    public OioDatagramChannelFactory(Executor workerExecutor, ThreadNameDeterminer determiner) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioDatagramPipelineSink(workerExecutor, determiner);
    }

    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new OioDatagramChannel(this, pipeline, this.sink);
    }

    public void shutdown() {
        if (this.shutdownExecutor) {
            ExecutorUtil.shutdownNow(this.workerExecutor);
        }
    }

    public void releaseExternalResources() {
        ExecutorUtil.shutdownNow(this.workerExecutor);
    }
}

