/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.base64;

import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelHandler;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.handler.codec.base64.Base64;
import shaded.netty.handler.codec.base64.Base64Dialect;
import shaded.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class Base64Encoder
extends OneToOneEncoder {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer src = (ChannelBuffer)msg;
        return Base64.encode(src, src.readerIndex(), src.readableBytes(), this.breakLines, this.dialect);
    }
}

