/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.compression;

import shaded.netty.handler.codec.compression.CompressionException;
import shaded.netty.handler.codec.compression.ZlibWrapper;
import shaded.netty.util.internal.jzlib.JZlib;
import shaded.netty.util.internal.jzlib.ZStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZlibUtil {
    static void fail(ZStream z, String message, int resultCode) {
        throw ZlibUtil.exception(z, message, resultCode);
    }

    static CompressionException exception(ZStream z, String message, int resultCode) {
        return new CompressionException(message + " (" + resultCode + ')' + (z.msg != null ? ": " + z.msg : ""));
    }

    static Enum<?> convertWrapperType(ZlibWrapper wrapper) {
        Enum<?> convertedWrapperType;
        switch (wrapper) {
            case NONE: {
                convertedWrapperType = JZlib.W_NONE;
                break;
            }
            case ZLIB: {
                convertedWrapperType = JZlib.W_ZLIB;
                break;
            }
            case GZIP: {
                convertedWrapperType = JZlib.W_GZIP;
                break;
            }
            case ZLIB_OR_NONE: {
                convertedWrapperType = JZlib.W_ZLIB_OR_NONE;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return convertedWrapperType;
    }

    static int wrapperOverhead(ZlibWrapper wrapper) {
        int overhead;
        switch (wrapper) {
            case NONE: {
                overhead = 0;
                break;
            }
            case ZLIB: 
            case ZLIB_OR_NONE: {
                overhead = 2;
                break;
            }
            case GZIP: {
                overhead = 10;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return overhead;
    }

    private ZlibUtil() {
    }
}

