/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.http.websocketx;

import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.buffer.ChannelBuffers;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelFutureListener;
import shaded.netty.handler.codec.http.DefaultHttpResponse;
import shaded.netty.handler.codec.http.HttpRequest;
import shaded.netty.handler.codec.http.HttpResponseStatus;
import shaded.netty.handler.codec.http.HttpVersion;
import shaded.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import shaded.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import shaded.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import shaded.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import shaded.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import shaded.netty.handler.codec.http.websocketx.WebSocketUtil;
import shaded.netty.handler.codec.http.websocketx.WebSocketVersion;
import shaded.netty.logging.InternalLogger;
import shaded.netty.logging.InternalLoggerFactory;
import shaded.netty.util.CharsetUtil;

public class WebSocketServerHandshaker07
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker07.class);
    public static final String WEBSOCKET_07_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker07(String webSocketURL, String subprotocols, boolean allowExtensions, long maxFramePayloadLength) {
        super(WebSocketVersion.V07, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 7 server handshake", channel.getId()));
        }
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        String key = req.headers().get("Sec-WebSocket-Key");
        if (key == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_07_ACCEPT_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer(acceptSeed, CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 7 Server Handshake key: %s. Response: %s.", key, accept));
        }
        res.setStatus(HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.headers().add("Upgrade", "WebSocket".toLowerCase());
        res.headers().add("Connection", "Upgrade");
        res.headers().add("Sec-WebSocket-Accept", accept);
        String subprotocols = req.headers().get("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
            }
            res.headers().add("Sec-WebSocket-Protocol", selectedSubprotocol);
            this.setSelectedSubprotocol(selectedSubprotocol);
        }
        return this.writeHandshakeResponse(channel, res, new WebSocket07FrameEncoder(false), new WebSocket07FrameDecoder(true, this.allowExtensions, this.getMaxFramePayloadLength()));
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        ChannelFuture future = channel.write(frame);
        future.addListener(ChannelFutureListener.CLOSE);
        return future;
    }
}

