/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import shaded.netty.channel.ChannelEvent;
import shaded.netty.channel.ChannelHandler;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.channel.ChannelState;
import shaded.netty.channel.ChannelStateEvent;
import shaded.netty.handler.ipfilter.IpFilteringHandlerImpl;

@ChannelHandler.Sharable
public class OneIpFilterHandler
extends IpFilteringHandlerImpl {
    private final ConcurrentMap<InetAddress, Boolean> connectedSet = new ConcurrentHashMap<InetAddress, Boolean>();

    protected boolean accept(ChannelHandlerContext ctx, ChannelEvent e, InetSocketAddress inetSocketAddress) throws Exception {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (this.connectedSet.containsKey(inetAddress)) {
            return false;
        }
        this.connectedSet.put(inetAddress, Boolean.TRUE);
        return true;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent evt;
        super.handleUpstream(ctx, e);
        if (e instanceof ChannelStateEvent && (evt = (ChannelStateEvent)e).getState() == ChannelState.CONNECTED && evt.getValue() == null && this.isBlocked(ctx)) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getChannel().getRemoteAddress();
            this.connectedSet.remove(inetSocketAddress.getAddress());
        }
    }
}

