/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.com.google.common.util.concurrent;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactivemongo.com.google.common.annotations.GwtCompatible;

@GwtCompatible(emulated=true)
abstract class InterruptibleTask
implements Runnable {
    private static final AtomicReferenceFieldUpdater<InterruptibleTask, Thread> RUNNER = AtomicReferenceFieldUpdater.newUpdater(InterruptibleTask.class, Thread.class, "runner");
    private volatile Thread runner;
    private volatile boolean doneInterrupting;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (!RUNNER.compareAndSet(this, null, Thread.currentThread())) {
            return;
        }
        try {
            this.runInterruptibly();
        }
        finally {
            if (this.wasInterrupted()) {
                while (!this.doneInterrupting) {
                    Thread.yield();
                }
            }
        }
    }

    abstract void runInterruptibly();

    abstract boolean wasInterrupted();

    final void interruptTask() {
        Thread currentRunner = this.runner;
        if (currentRunner != null) {
            currentRunner.interrupt();
        }
        this.doneInterrupting = true;
    }
}

