/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.io.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketOption;
import java.nio.channels.NetworkChannel;
import java.util.Set;
import reactivemongo.io.netty.channel.ChannelException;
import reactivemongo.io.netty.channel.ChannelOption;

public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    private NioChannelOption(SocketOption<T> option) {
        super(option.name());
        this.option = option;
    }

    public static <T> ChannelOption<T> of(SocketOption<T> option) {
        return new NioChannelOption<T>(option);
    }

    static <T> boolean setOption(NetworkChannel channel, NioChannelOption<T> option, T value) {
        if (!channel.supportedOptions().contains(option.option)) {
            return false;
        }
        try {
            channel.setOption(option.option, value);
            return true;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    static <T> T getOption(NetworkChannel channel, NioChannelOption<T> option) {
        if (!channel.supportedOptions().contains(option.option)) {
            return null;
        }
        try {
            return channel.getOption(option.option);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    static ChannelOption[] getOptions(NetworkChannel channel) {
        Set<SocketOption<?>> supportedOpts = channel.supportedOptions();
        ChannelOption[] extraOpts = new ChannelOption[supportedOpts.size()];
        int i = 0;
        for (SocketOption<?> opt : supportedOpts) {
            extraOpts[i++] = new NioChannelOption(opt);
        }
        return extraOpts;
    }
}

