/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.actors;

import akka.actor.ActorRef;
import akka.actor.package$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactivemongo.api.BSONSerializationPack$;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.commands.Command$;
import reactivemongo.api.commands.IsMasterCommand;
import reactivemongo.api.commands.LastError;
import reactivemongo.api.commands.bson.BSONGetLastErrorImplicits$LastErrorReader$;
import reactivemongo.api.commands.bson.BSONIsMasterCommand$;
import reactivemongo.api.commands.bson.BSONIsMasterCommandImplicits$IsMasterResultReader$;
import reactivemongo.api.commands.bson.BSONIsMasterCommandImplicits$IsMasterWriter$;
import reactivemongo.bson.BSONDocument;
import reactivemongo.bson.BSONReader;
import reactivemongo.bson.BSONValue;
import reactivemongo.bson.BSONValue$;
import reactivemongo.bson.buffer.ReadableBuffer;
import reactivemongo.bson.lowlevel.BooleanField;
import reactivemongo.bson.lowlevel.DoubleField;
import reactivemongo.bson.lowlevel.Field;
import reactivemongo.bson.lowlevel.IntField;
import reactivemongo.bson.lowlevel.LazyField;
import reactivemongo.bson.lowlevel.LowLevelBsonDocReader;
import reactivemongo.core.actors.AuthRequest;
import reactivemongo.core.actors.AwaitingResponse;
import reactivemongo.core.actors.ChannelClosed;
import reactivemongo.core.actors.ChannelConnected;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.actors.ChannelUnavailable;
import reactivemongo.core.actors.ChannelUnavailable$;
import reactivemongo.core.actors.CheckedWriteRequestExpectingResponse;
import reactivemongo.core.actors.Close$;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.ConnectAll$;
import reactivemongo.core.actors.Exceptions$ChannelNotFound$;
import reactivemongo.core.actors.Exceptions$ClosedException$;
import reactivemongo.core.actors.Exceptions$PrimaryUnavailableException$;
import reactivemongo.core.actors.ExpectingResponse$;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.MongoDBSystem$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$3$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$4$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$5$;
import reactivemongo.core.actors.PrimaryAvailable;
import reactivemongo.core.actors.PrimaryUnavailable$;
import reactivemongo.core.actors.RefreshAllNodes$;
import reactivemongo.core.actors.RegisterMonitor$;
import reactivemongo.core.actors.RequestId$;
import reactivemongo.core.actors.RequestMakerExpectingResponse;
import reactivemongo.core.actors.SetAvailable;
import reactivemongo.core.actors.SetUnavailable$;
import reactivemongo.core.commands.CommandError;
import reactivemongo.core.commands.SuccessfulAuthentication;
import reactivemongo.core.errors.DatabaseException;
import reactivemongo.core.errors.GenericDriverException;
import reactivemongo.core.netty.ChannelBufferReadableBuffer;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.core.nodeset.Authenticated;
import reactivemongo.core.nodeset.Authenticating;
import reactivemongo.core.nodeset.Authenticating$;
import reactivemongo.core.nodeset.ChannelFactory;
import reactivemongo.core.nodeset.Connection;
import reactivemongo.core.nodeset.ConnectionStatus;
import reactivemongo.core.nodeset.ConnectionStatus$Connected$;
import reactivemongo.core.nodeset.ConnectionStatus$Disconnected$;
import reactivemongo.core.nodeset.Node;
import reactivemongo.core.nodeset.Node$;
import reactivemongo.core.nodeset.NodeSet;
import reactivemongo.core.nodeset.NodeStatus;
import reactivemongo.core.nodeset.NodeStatus$Primary$;
import reactivemongo.core.nodeset.NodeStatus$Uninitialized$;
import reactivemongo.core.nodeset.NodeStatus$Unknown$;
import reactivemongo.core.nodeset.PingInfo;
import reactivemongo.core.nodeset.PingInfo$;
import reactivemongo.core.nodeset.ProtocolMetadata;
import reactivemongo.core.nodeset.ProtocolMetadata$;
import reactivemongo.core.nodeset.QueryableNodeStatus;
import reactivemongo.core.protocol.CheckedWriteRequest;
import reactivemongo.core.protocol.GetMore;
import reactivemongo.core.protocol.KillCursors;
import reactivemongo.core.protocol.MongoWireVersion$;
import reactivemongo.core.protocol.Query;
import reactivemongo.core.protocol.QueryFlags$;
import reactivemongo.core.protocol.Request;
import reactivemongo.core.protocol.RequestMaker;
import reactivemongo.core.protocol.RequestOp;
import reactivemongo.core.protocol.Response;
import reactivemongo.core.protocol.Response$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.VolatileObjectRef;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.group.ChannelGroupFuture;
import shaded.netty.channel.group.ChannelGroupFutureListener;
import shaded.netty.channel.group.DefaultChannelGroup;

public abstract class MongoDBSystem$class {
    public static final Connection authenticateConnection(MongoDBSystem $this, Connection connection2, Seq auths) {
        Connection connection3;
        block4: {
            while (connection2.authenticating().isEmpty()) {
                Connection connection4;
                Option option = auths.headOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Authenticate nextAuth = (Authenticate)some.x();
                    if (connection2.isAuthenticated(nextAuth.db(), nextAuth.user())) {
                        auths = (Seq)auths.tail();
                        continue;
                    }
                    connection4 = $this.sendAuthenticate(connection2, nextAuth);
                } else {
                    connection4 = connection2;
                }
                connection3 = connection4;
                break block4;
            }
            connection3 = connection2;
        }
        return connection3;
    }

    public static final Node reactivemongo$core$actors$MongoDBSystem$$authenticateNode(MongoDBSystem $this, Node node, Seq auths) {
        Vector x$27 = (Vector)node.connections().map((Function1)new Serializable($this, auths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Seq auths$1;

            public final Connection apply(Connection x0$1) {
                Connection connection2 = x0$1;
                ConnectionStatus connectionStatus = connection2.status();
                ConnectionStatus$Connected$ connectionStatus$Connected$ = ConnectionStatus$Connected$.MODULE$;
                Connection connection3 = !(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Connected$) : connectionStatus$Connected$ != null) ? this.$outer.authenticateConnection(connection2, (Seq<Authenticate>)this.auths$1) : connection2;
                return connection3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.auths$1 = auths$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        String x$28 = node.copy$default$1();
        NodeStatus x$29 = node.copy$default$2();
        Set<Authenticated> x$30 = node.copy$default$4();
        Option<BSONDocument> x$31 = node.copy$default$5();
        ProtocolMetadata x$32 = node.copy$default$6();
        PingInfo x$33 = node.copy$default$7();
        boolean x$34 = node.copy$default$8();
        return node.copy(x$28, x$29, (Vector<Connection>)x$27, x$30, x$31, x$32, x$33, x$34);
    }

    public static final NodeSet reactivemongo$core$actors$MongoDBSystem$$authenticateNodeSet(MongoDBSystem $this, NodeSet nodeSet) {
        Vector x$35 = (Vector)nodeSet.nodes().map((Function1)new Serializable($this, nodeSet){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final NodeSet nodeSet$1;

            public final Node apply(Node x0$2) {
                Node node = x0$2;
                Node node2 = node != null && node.status() instanceof QueryableNodeStatus ? MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$authenticateNode(this.$outer, node, this.nodeSet$1.authenticates().toSeq()) : node;
                return node2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nodeSet$1 = nodeSet$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Option<String> x$36 = nodeSet.copy$default$1();
        Option<Object> x$37 = nodeSet.copy$default$2();
        Set<Authenticate> x$38 = nodeSet.copy$default$4();
        return nodeSet.copy(x$36, x$37, (Vector<Node>)x$35, x$38);
    }

    public static Node reactivemongo$core$actors$MongoDBSystem$$unauthenticate(MongoDBSystem $this, Node node, Vector connections) {
        NodeStatus$Unknown$ x$39 = NodeStatus$Unknown$.MODULE$;
        Vector x$40 = connections;
        Set x$41 = connections.isEmpty() ? Predef$.MODULE$.Set().empty() : node.authenticated();
        String x$42 = node.copy$default$1();
        Option<BSONDocument> x$43 = node.copy$default$5();
        ProtocolMetadata x$44 = node.copy$default$6();
        PingInfo x$45 = node.copy$default$7();
        boolean x$46 = node.copy$default$8();
        return node.copy(x$42, x$39, (Vector<Connection>)x$40, (Set<Authenticated>)x$41, x$43, x$44, x$45, x$46);
    }

    public static void reactivemongo$core$actors$MongoDBSystem$$stopWhenDisconnected(MongoDBSystem $this, String state, Object msg) {
        int remainingConnections = BoxesRunTime.unboxToInt((Object)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(int open, Node node) {
                return open + node.connections().size();
            }
        }));
        if (MongoDBSystem$.MODULE$.logger().isDebugEnabled()) {
            int disconnected = BoxesRunTime.unboxToInt((Object)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(int open, Node node) {
                    return open + node.connections().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Connection x$1) {
                            ConnectionStatus connectionStatus = x$1.status();
                            ConnectionStatus$Disconnected$ connectionStatus$Disconnected$ = ConnectionStatus$Disconnected$.MODULE$;
                            return !(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Disconnected$) : connectionStatus$Disconnected$ != null);
                        }
                    });
                }
            }));
            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this, state, msg, remainingConnections, disconnected){
                public static final long serialVersionUID = 0L;
                private final String state$1;
                private final Object msg$1;
                private final int remainingConnections$1;
                private final int disconnected$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(State: ", ") Received ", " remainingConnections = ", ", disconnected = ", ", connected = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state$1, this.msg$1, BoxesRunTime.boxToInteger((int)this.remainingConnections$1), BoxesRunTime.boxToInteger((int)this.disconnected$1), BoxesRunTime.boxToInteger((int)(this.remainingConnections$1 - this.disconnected$1))}));
                }
                {
                    this.state$1 = state$1;
                    this.msg$1 = msg$1;
                    this.remainingConnections$1 = remainingConnections$1;
                    this.disconnected$1 = disconnected$1;
                }
            });
        }
        if (remainingConnections == 0) {
            $this.reactivemongo$core$actors$MongoDBSystem$$monitors().foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final void apply(ActorRef x$2) {
                    package$.MODULE$.actorRef2Scala(x$2).$bang((Object)Closed$.MODULE$, this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is stopping"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.self()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            $this.context().stop($this.self());
        }
    }

    public static NodeSet updateNodeSetOnDisconnect(MongoDBSystem $this, int channelId) {
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateNodeByChannelId(channelId, (Function1<Node, Node>)new Serializable($this, channelId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            public final int channelId$4;

            public final Node apply(Node node) {
                Vector connections = (Vector)node.connections().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.updateNodeSetOnDisconnect.1 $outer;

                    public final Connection apply(Connection connection2) {
                        Connection connection3;
                        if (BoxesRunTime.equalsNumObject((Number)connection2.channel().getId(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.channelId$4))) {
                            ConnectionStatus$Disconnected$ x$47 = ConnectionStatus$Disconnected$.MODULE$;
                            Channel x$48 = connection2.copy$default$1();
                            Set<Authenticated> x$49 = connection2.copy$default$3();
                            Option<Authenticating> x$50 = connection2.copy$default$4();
                            connection3 = connection2.copy(x$48, x$47, x$49, x$50);
                        } else {
                            connection3 = connection2;
                        }
                        return connection3;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Vector$.MODULE$.canBuildFrom());
                return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$unauthenticate(this.$outer, node, connections);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.channelId$4 = channelId$4;
            }
        }));
    }

    public static Either reactivemongo$core$actors$MongoDBSystem$$lastError(MongoDBSystem $this, Response response) {
        Try try_;
        block4: {
            Left left;
            block3: {
                block2: {
                    try_ = BSONValue.ExtendedBSONValue$.MODULE$.asTry$extension(BSONValue$.MODULE$.ExtendedBSONValue((BSONValue)Response$.MODULE$.parse(response).next()), (BSONReader)BSONGetLastErrorImplicits$LastErrorReader$.MODULE$);
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    left = scala.package$.MODULE$.Left().apply((Object)err);
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                LastError err = (LastError)success.value();
                left = scala.package$.MODULE$.Right().apply((Object)err);
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    public static PartialFunction receive(MongoDBSystem $this) {
        return $this.reactivemongo$core$actors$MongoDBSystem$$processing().orElse($this.authReceive()).orElse($this.reactivemongo$core$actors$MongoDBSystem$$fallback());
    }

    public static void onPrimaryUnavailable(MongoDBSystem $this) {
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)RefreshAllNodes$.MODULE$, $this.self());
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateAll((Function1<Node, Node>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Node apply(Node node) {
                Node node2;
                NodeStatus nodeStatus = node.status();
                NodeStatus$Primary$ nodeStatus$Primary$ = NodeStatus$Primary$.MODULE$;
                if (!(nodeStatus != null ? !nodeStatus.equals(nodeStatus$Primary$) : nodeStatus$Primary$ != null)) {
                    NodeStatus$Unknown$ x$71 = NodeStatus$Unknown$.MODULE$;
                    String x$72 = node.copy$default$1();
                    Vector<Connection> x$73 = node.copy$default$3();
                    Set<Authenticated> x$74 = node.copy$default$4();
                    Option<BSONDocument> x$75 = node.copy$default$5();
                    ProtocolMetadata x$76 = node.copy$default$6();
                    PingInfo x$77 = node.copy$default$7();
                    boolean x$78 = node.copy$default$8();
                    node2 = node.copy(x$72, x$71, x$73, x$74, x$75, x$76, x$77, x$78);
                } else {
                    node2 = node;
                }
                return node2;
            }
        }));
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors($this, PrimaryUnavailable$.MODULE$);
    }

    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(MongoDBSystem $this, NodeSet nodeSet) {
        $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet_$eq(nodeSet);
        return nodeSet;
    }

    private static NodeSet updateAuthenticate(MongoDBSystem $this, int channelId, Authenticate replyTo, Option auth) {
        NodeSet nodeSet;
        NodeSet ns = $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateByChannelId(channelId, (Function1<Connection, Connection>)new Serializable($this, auth){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Option auth$1;

            public final Connection apply(Connection con) {
                Set authed;
                Set x$79 = authed = (Set)this.auth$1.map((Function1)new Serializable(this, con){
                    public static final long serialVersionUID = 0L;
                    private final Connection con$1;

                    public final Set<Authenticated> apply(Authenticated x$18) {
                        return (Set)this.con$1.authenticated().$plus((Object)x$18);
                    }
                    {
                        this.con$1 = con$1;
                    }
                }).getOrElse((Function0)new Serializable(this, con){
                    public static final long serialVersionUID = 0L;
                    private final Connection con$1;

                    public final Set<Authenticated> apply() {
                        return this.con$1.authenticated();
                    }
                    {
                        this.con$1 = con$1;
                    }
                });
                None$ x$80 = None$.MODULE$;
                Channel x$81 = con.copy$default$1();
                ConnectionStatus x$82 = con.copy$default$2();
                return this.$outer.authenticateConnection(con.copy(x$81, x$82, (Set<Authenticated>)x$79, (Option<Authenticating>)x$80), (Seq<Authenticate>)this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().authenticates().toSeq());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.auth$1 = auth$1;
            }
        }, (Function1<Node, Node>)new Serializable($this, auth){
            public static final long serialVersionUID = 0L;
            private final Option auth$1;

            public final Node apply(Node node) {
                Set x$83 = (Set)this.auth$1.map((Function1)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$5;

                    public final Set<Authenticated> apply(Authenticated x$19) {
                        return (Set)this.node$5.authenticated().$plus((Object)x$19);
                    }
                    {
                        this.node$5 = node$5;
                    }
                }).getOrElse((Function0)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$5;

                    public final Set<Authenticated> apply() {
                        return this.node$5.authenticated();
                    }
                    {
                        this.node$5 = node$5;
                    }
                });
                String x$84 = node.copy$default$1();
                NodeStatus x$85 = node.copy$default$2();
                Vector<Connection> x$86 = node.copy$default$3();
                Option<BSONDocument> x$87 = node.copy$default$5();
                ProtocolMetadata x$88 = node.copy$default$6();
                PingInfo x$89 = node.copy$default$7();
                boolean x$90 = node.copy$default$8();
                return node.copy(x$84, x$85, x$86, (Set<Authenticated>)x$83, x$87, x$88, x$89, x$90);
            }
            {
                this.auth$1 = auth$1;
            }
        });
        if (auth.isDefined()) {
            nodeSet = ns;
        } else {
            Set x$91 = (Set)ns.authenticates().$minus((Object)replyTo);
            Option<String> x$92 = ns.copy$default$1();
            Option<Object> x$93 = ns.copy$default$2();
            Vector<Node> x$94 = ns.copy$default$3();
            nodeSet = ns.copy(x$92, x$93, x$94, (Set<Authenticate>)x$91);
        }
        return nodeSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeSet authenticationResponse(MongoDBSystem $this, Response response, Function1 check) {
        NodeSet nodeSet;
        Some some;
        Authenticating a;
        Option<Tuple3<String, String, String>> option;
        Option auth = $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().pickByChannelId(response.info().channelId()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<Authenticating> apply(Tuple2<Node, Connection> x$20) {
                return ((Connection)x$20._2()).authenticating();
            }
        });
        Option option2 = auth;
        if (option2 instanceof Some && !(option = Authenticating$.MODULE$.unapply(a = (Authenticating)(some = (Some)option2).x())).isEmpty()) {
            None$ none$;
            String db = (String)((Tuple3)option.get())._1();
            String user = (String)((Tuple3)option.get())._2();
            String pass = (String)((Tuple3)option.get())._3();
            Authenticate originalAuthenticate = new Authenticate(db, user, pass);
            Either either = (Either)check.apply((Object)response);
            if (either instanceof Right) {
                Right right = (Right)either;
                SuccessfulAuthentication successfulAuthentication = (SuccessfulAuthentication)right.b();
                $this.reactivemongo$core$actors$MongoDBSystem$$AuthRequestsManager().handleAuthResult(originalAuthenticate, successfulAuthentication);
                if ($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().isReachable()) {
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors($this, new SetAvailable($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().protocolMetadata()));
                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "The node set is now authenticated";
                        }
                    });
                }
                if ($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().primary().isDefined()) {
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors($this, new PrimaryAvailable($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().protocolMetadata()));
                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "The primary is now authenticated";
                        }
                    });
                }
                none$ = new Some((Object)new Authenticated(db, user));
            } else {
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Left left = (Left)either;
                CommandError error = (CommandError)left.a();
                $this.reactivemongo$core$actors$MongoDBSystem$$AuthRequestsManager().handleAuthResult(originalAuthenticate, (Throwable)((Object)error));
                none$ = None$.MODULE$;
            }
            None$ authenticated = none$;
            nodeSet = MongoDBSystem$class.updateAuthenticate($this, response.info().channelId(), originalAuthenticate, (Option)authenticated);
            return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, nodeSet);
        } else {
            MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable($this, option2){
                public static final long serialVersionUID = 0L;
                private final Option x1$6;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication result: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$6}));
                }
                {
                    this.x1$6 = x1$6;
                }
            });
            nodeSet = $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet();
        }
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, nodeSet);
    }

    private static boolean secondaryOK(MongoDBSystem $this, Request message2) {
        Query query;
        int flags;
        RequestOp requestOp;
        boolean bl;
        return !message2.op().requiresPrimary() && (bl = (requestOp = message2.op()) instanceof Query ? ((flags = (query = (Query)requestOp).flags()) & QueryFlags$.MODULE$.SlaveOk()) != 0 : (requestOp instanceof KillCursors ? true : requestOp instanceof GetMore));
    }

    public static Try reactivemongo$core$actors$MongoDBSystem$$pickChannel(MongoDBSystem $this, Request request) {
        return request.channelIdHint().isDefined() ? (Try)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().pickByChannelId(BoxesRunTime.unboxToInt((Object)request.channelIdHint().get())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Success<Tuple2<Node, Connection>> apply(Tuple2<Node, Connection> x$21) {
                return new Success(x$21);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Failure<Nothing$> apply() {
                return new Failure((Throwable)Exceptions$ChannelNotFound$.MODULE$);
            }
        }) : (Try)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().pick(request.readPreference()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Success<Tuple2<Node, Connection>> apply(Tuple2<Node, Connection> x$22) {
                return new Success(x$22);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Failure<Nothing$> apply() {
                return new Failure((Throwable)Exceptions$PrimaryUnavailableException$.MODULE$);
            }
        });
    }

    public static NodeSet whenAuthenticating(MongoDBSystem $this, int channelId, Function1 f) {
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateConnectionByChannelId(channelId, (Function1<Connection, Connection>)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            public final Function1 f$1;

            public final Connection apply(Connection connection2) {
                return (Connection)connection2.authenticating().fold((Function0)new Serializable(this, connection2){
                    public static final long serialVersionUID = 0L;
                    private final Connection connection$3;

                    public final Connection apply() {
                        return this.connection$3;
                    }
                    {
                        this.connection$3 = connection$3;
                    }
                }, (Function1)new Serializable(this, connection2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.whenAuthenticating.1 $outer;
                    private final Connection connection$3;

                    public final Connection apply(Authenticating authenticating) {
                        return (Connection)this.$outer.f$1.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.connection$3), (Object)authenticating));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.connection$3 = connection$3;
                    }
                });
            }
            {
                this.f$1 = f$1;
            }
        }));
    }

    public static void postStop(MongoDBSystem $this) {
        $this.reactivemongo$core$actors$MongoDBSystem$$connectAllJob().cancel();
        $this.reactivemongo$core$actors$MongoDBSystem$$refreshAllJob().cancel();
        ChannelGroupFutureListener listener = new ChannelGroupFutureListener($this){
            private final ChannelFactory factory;
            private final ListBuffer<ActorRef> monitorActors;

            public ChannelFactory factory() {
                return this.factory;
            }

            public ListBuffer<ActorRef> monitorActors() {
                return this.monitorActors;
            }

            public void operationComplete(ChannelGroupFuture future) {
                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Netty says all channels are closed.";
                    }
                });
                this.factory().channelFactory().releaseExternalResources();
            }
            {
                this.factory = $outer.channelFactory();
                this.monitorActors = $outer.reactivemongo$core$actors$MongoDBSystem$$monitors();
            }
        };
        $this.allChannelGroup($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet()).close().addListener(listener);
        $this.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<Object, AwaitingResponse> x0$4) {
                AwaitingResponse r;
                Tuple2<Object, AwaitingResponse> tuple2 = x0$4;
                Object object = tuple2 != null && !(r = (AwaitingResponse)tuple2._2()).promise().isCompleted() ? r.promise().failure((Throwable)Exceptions$ClosedException$.MODULE$) : BoxedUnit.UNIT;
                return object;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().empty();
        MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MongoDBSystem ", " stopped."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.self()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(MongoDBSystem $this, Object message2) {
        $this.reactivemongo$core$actors$MongoDBSystem$$monitors().foreach((Function1)new Serializable($this, message2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Object message$1;

            public final void apply(ActorRef x$23) {
                package$.MODULE$.actorRef2Scala(x$23).$bang(this.message$1, this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$1 = message$1;
            }
        });
    }

    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$connectAll(MongoDBSystem $this, NodeSet nodeSet) {
        nodeSet.nodes().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Vector<ChannelFuture> apply(Node node) {
                return (Vector)node.connections().withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Connection connection2) {
                        return !connection2.channel().isConnected();
                    }
                }).map((Function1)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$6;

                    public final ChannelFuture apply(Connection connection2) {
                        return connection2.channel().connect((SocketAddress)new InetSocketAddress(this.node$6.host(), this.node$6.port()));
                    }
                    {
                        this.node$6 = node$6;
                    }
                }, Vector$.MODULE$.canBuildFrom());
            }
        }, Vector$.MODULE$.canBuildFrom());
        return nodeSet;
    }

    public static Node sendIsMaster(MongoDBSystem $this, Node node, int id) {
        return (Node)node.connected().headOption().map((Function1)new Serializable($this, node, id){
            public static final long serialVersionUID = 0L;
            private final Node node$7;
            private final int id$1;

            public final Node apply(Connection channel) {
                Tuple2<RequestMaker, Object> tuple2 = Command$.MODULE$.buildRequestMaker(BSONSerializationPack$.MODULE$, BSONIsMasterCommand$.MODULE$.IsMaster(), BSONIsMasterCommandImplicits$IsMasterWriter$.MODULE$, ReadPreference$.MODULE$.primaryPreferred(), "admin");
                if (tuple2 != null) {
                    Node node;
                    RequestMaker isMaster;
                    RequestMaker requestMaker;
                    RequestMaker isMaster2 = requestMaker = (isMaster = (RequestMaker)tuple2._1());
                    channel.send(isMaster2.apply(this.id$1));
                    if (this.node$7.pingInfo().lastIsMasterId() == -1) {
                        long x$95 = System.currentTimeMillis();
                        int x$96 = this.id$1;
                        long x$97 = this.node$7.pingInfo().copy$default$1();
                        PingInfo x$98 = this.node$7.pingInfo().copy(x$97, x$95, x$96);
                        String x$99 = this.node$7.copy$default$1();
                        NodeStatus x$100 = this.node$7.copy$default$2();
                        Vector<Connection> x$101 = this.node$7.copy$default$3();
                        Set<Authenticated> x$102 = this.node$7.copy$default$4();
                        Option<BSONDocument> x$103 = this.node$7.copy$default$5();
                        ProtocolMetadata x$104 = this.node$7.copy$default$6();
                        boolean x$105 = this.node$7.copy$default$8();
                        node = this.node$7.copy(x$99, x$100, x$101, x$102, x$103, x$104, x$98, x$105);
                    } else if (this.node$7.pingInfo().lastIsMasterId() >= PingInfo$.MODULE$.pingTimeout()) {
                        long x$106 = System.currentTimeMillis();
                        int x$107 = this.id$1;
                        long x$108 = Long.MAX_VALUE;
                        PingInfo x$109 = this.node$7.pingInfo().copy(x$108, x$106, x$107);
                        String x$110 = this.node$7.copy$default$1();
                        NodeStatus x$111 = this.node$7.copy$default$2();
                        Vector<Connection> x$112 = this.node$7.copy$default$3();
                        Set<Authenticated> x$113 = this.node$7.copy$default$4();
                        Option<BSONDocument> x$114 = this.node$7.copy$default$5();
                        ProtocolMetadata x$115 = this.node$7.copy$default$6();
                        boolean x$116 = this.node$7.copy$default$8();
                        node = this.node$7.copy(x$110, x$111, x$112, x$113, x$114, x$115, x$109, x$116);
                    } else {
                        node = this.node$7;
                    }
                    return node;
                }
                throw new MatchError(tuple2);
            }
            {
                this.node$7 = node$7;
                this.id$1 = id$1;
            }
        }).getOrElse((Function0)new Serializable($this, node){
            public static final long serialVersionUID = 0L;
            private final Node node$7;

            public final Node apply() {
                return this.node$7;
            }
            {
                this.node$7 = node$7;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static DefaultChannelGroup allChannelGroup(MongoDBSystem $this, NodeSet nodeSet) {
        void var2_2;
        DefaultChannelGroup result2 = new DefaultChannelGroup();
        nodeSet.nodes().foreach((Function1)new Serializable($this, result2){
            public static final long serialVersionUID = 0L;
            public final DefaultChannelGroup result$1;

            public final void apply(Node node) {
                node.connections().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.allChannelGroup.1 $outer;

                    public final boolean apply(Connection connection2) {
                        return this.$outer.result$1.add(connection2.channel());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.result$1 = result$1;
            }
        });
        return var2_2;
    }

    public static void $init$(MongoDBSystem $this) {
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$cFactory_$eq($this.channelFactory());
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$awaitingResponses_$eq((LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$monitors_$eq((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$ec_$eq($this.context().system().dispatcher());
        int ms = $this.options().monitorRefreshMS() / 5;
        FiniteDuration interval = ms < 100 ? new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds() : new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt($this.options().monitorRefreshMS())).milliseconds();
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$connectAllJob_$eq($this.context().system().scheduler().schedule(interval, interval, $this.self(), (Object)ConnectAll$.MODULE$, (ExecutionContext)$this.ec(), $this.self()));
        FiniteDuration interval2 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt($this.options().monitorRefreshMS())).milliseconds();
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$refreshAllJob_$eq($this.context().system().scheduler().schedule(interval2, interval2, $this.self(), (Object)RefreshAllNodes$.MODULE$, (ExecutionContext)$this.ec(), $this.self()));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$closing_$eq((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (A1 instanceof RequestMaker) {
                    RequestMaker requestMaker = (RequestMaker)A1;
                    MongoDBSystem$.MODULE$.logger().error((Function0<String>)new Serializable(this, requestMaker){
                        public static final long serialVersionUID = 0L;
                        private final RequestMaker x2$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received a non-expecting response request during closing process: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1}));
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else if (RegisterMonitor$.MODULE$.equals(A1)) {
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$monitors().$plus$eq((Object)this.$outer.sender());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Option<Promise<Response>> option = ExpectingResponse$.MODULE$.unapply(A1);
                    if (option.isEmpty()) {
                        if (A1 instanceof ChannelClosed) {
                            ChannelClosed channelClosed = (ChannelClosed)A1;
                            int channelId = channelClosed.channelId();
                            MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(this.$outer, this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateNodeByChannelId(channelId, (Function1<Node, Node>)new Serializable(this, channelId){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$.anonfun.3 $outer;
                                public final int channelId$1;

                                public final Node apply(Node node) {
                                    return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$unauthenticate(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), node, (Vector)node.connections().filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ MongoDBSystem$$anonfun$3$.anonfun.applyOrElse.3 $outer;

                                        public final boolean apply(Connection x$3) {
                                            return !BoxesRunTime.equalsNumObject((Number)x$3.channel().getId(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.channelId$1));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.channelId$1 = channelId$1;
                                }
                            }));
                            MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$stopWhenDisconnected(this.$outer, "Closing", channelClosed);
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (A1 instanceof ChannelDisconnected) {
                            BoxedUnit boxedUnit2;
                            ChannelDisconnected channelDisconnected = (ChannelDisconnected)A1;
                            int channelId = channelDisconnected.channelId();
                            this.$outer.updateNodeSetOnDisconnect(channelId);
                            if (MongoDBSystem$.MODULE$.logger().isDebugEnabled()) {
                                int remainingConnections = BoxesRunTime.unboxToInt((Object)this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(int open, Node node) {
                                        return open + node.connections().size();
                                    }
                                }));
                                int disconnected = BoxesRunTime.unboxToInt((Object)this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(int open, Node node) {
                                        return open + node.connections().count((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(Connection x$4) {
                                                ConnectionStatus connectionStatus = x$4.status();
                                                ConnectionStatus$Disconnected$ connectionStatus$Disconnected$ = ConnectionStatus$Disconnected$.MODULE$;
                                                return !(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Disconnected$) : connectionStatus$Disconnected$ != null);
                                            }
                                        });
                                    }
                                }));
                                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, remainingConnections, disconnected, channelDisconnected){
                                    public static final long serialVersionUID = 0L;
                                    private final int remainingConnections$2;
                                    private final int disconnected$2;
                                    private final ChannelDisconnected x9$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(State: Closing) Received ", ", remainingConnections = ", ", disconnected = ", ", connected = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x9$1, BoxesRunTime.boxToInteger((int)this.remainingConnections$2), BoxesRunTime.boxToInteger((int)this.disconnected$2), BoxesRunTime.boxToInteger((int)(this.remainingConnections$2 - this.disconnected$2))}));
                                    }
                                    {
                                        this.remainingConnections$2 = remainingConnections$2;
                                        this.disconnected$2 = disconnected$2;
                                        this.x9$1 = x9$1;
                                    }
                                });
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit2;
                        } else if (A1 instanceof ChannelConnected) {
                            ChannelConnected channelConnected = (ChannelConnected)A1;
                            int channelId = channelConnected.channelId();
                            MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable(this, channelConnected){
                                public static final long serialVersionUID = 0L;
                                private final ChannelConnected x10$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(State: Closing) SPURIOUS ", " (ignored, channel closed)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x10$1}));
                                }
                                {
                                    this.x10$1 = x10$1;
                                }
                            });
                            this.$outer.updateNodeSetOnDisconnect(channelId);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            MongoDBSystem$.MODULE$.logger().error((Function0<String>)new Serializable(this, A1){
                                public static final long serialVersionUID = 0L;
                                private final Object x1$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(State: Closing) UNHANDLED MESSAGE: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                                }
                                {
                                    this.x1$1 = x1$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        Promise promise = (Promise)option.get();
                        MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, A1){
                            public static final long serialVersionUID = 0L;
                            private final Object x1$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received an expecting response request during closing process: ", ", completing its promise with a failure"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                            }
                            {
                                this.x1$1 = x1$1;
                            }
                        });
                        promise.failure((Throwable)Exceptions$ClosedException$.MODULE$);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Object x1) {
                Option<Promise<Response>> option;
                Object object = x1;
                boolean bl = object instanceof RequestMaker ? true : (RegisterMonitor$.MODULE$.equals(object) ? true : ((option = ExpectingResponse$.MODULE$.unapply(object)).isEmpty() ? (object instanceof ChannelClosed ? true : (object instanceof ChannelDisconnected ? true : (object instanceof ChannelConnected ? true : true))) : true));
                return bl;
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$processing_$eq((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ChannelUnavailable channelUnavailable;
                Option<Object> option;
                void var4_15;
                A1 A1 = x2;
                if (RegisterMonitor$.MODULE$.equals(A1)) {
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$monitors().$plus$eq((Object)this.$outer.sender());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (Close$.MODULE$.equals(A1)) {
                    BoxedUnit boxedUnit;
                    MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Received Close message, going to close connections and moving on stage Closing";
                        }
                    });
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$connectAllJob().cancel();
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$refreshAllJob().cancel();
                    ChannelGroupFutureListener listener = new ChannelGroupFutureListener(this){
                        private final ChannelFactory factory;
                        private final ListBuffer<ActorRef> monitorActors;

                        public ChannelFactory factory() {
                            return this.factory;
                        }

                        public ListBuffer<ActorRef> monitorActors() {
                            return this.monitorActors;
                        }

                        public void operationComplete(ChannelGroupFuture future) {
                            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Netty says all channels are closed.";
                                }
                            });
                            try {
                                this.factory().channelFactory().releaseExternalResources();
                            }
                            catch (Throwable throwable) {
                                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "fails to release channel resources";
                                    }
                                }, (Function0<Throwable>)new Serializable(this, throwable){
                                    public static final long serialVersionUID = 0L;
                                    private final Throwable err$1;

                                    public final Throwable apply() {
                                        return this.err$1;
                                    }
                                    {
                                        this.err$1 = err$1;
                                    }
                                });
                            }
                        }
                        {
                            this.factory = $outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().channelFactory();
                            this.monitorActors = $outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$monitors();
                        }
                    };
                    this.$outer.allChannelGroup(this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet()).close().addListener(listener);
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Tuple2<Object, AwaitingResponse> pair) {
                            Promise<Response> promise = ((AwaitingResponse)pair._2()).promise();
                            return promise.isCompleted() ? BoxedUnit.UNIT : promise.failure((Throwable)Exceptions$ClosedException$.MODULE$);
                        }
                    });
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().empty();
                    int connectedCon = BoxesRunTime.unboxToInt((Object)this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(int x$5, Node x$6) {
                            return x$5 + x$6.connected().size();
                        }
                    }));
                    this.$outer.context().become(this.$outer.closing());
                    if (connectedCon == 0) {
                        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$stopWhenDisconnected(this.$outer, "Processing", Close$.MODULE$);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return var4_15;
                }
                if (A1 instanceof RequestMaker) {
                    RequestMaker requestMaker = (RequestMaker)A1;
                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, requestMaker){
                        public static final long serialVersionUID = 0L;
                        private final RequestMaker x2$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transmiting a request: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$2}));
                        }
                        {
                            this.x2$2 = x2$2;
                        }
                    });
                    Request r = requestMaker.apply(RequestId$.MODULE$.common().next());
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$pickChannel(this.$outer, r).map((Function1)new Serializable(this, r){
                        public static final long serialVersionUID = 0L;
                        private final Request r$1;

                        public final ChannelFuture apply(Tuple2<Node, Connection> x$7) {
                            return ((Connection)x$7._2()).send(this.r$1);
                        }
                        {
                            this.r$1 = r$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (A1 instanceof RequestMakerExpectingResponse) {
                    RequestMakerExpectingResponse requestMakerExpectingResponse = (RequestMakerExpectingResponse)A1;
                    RequestMaker maker = requestMakerExpectingResponse.requestMaker();
                    int reqId = RequestId$.MODULE$.common().next();
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, reqId, requestMakerExpectingResponse){
                        public static final long serialVersionUID = 0L;
                        private final int reqId$1;
                        private final RequestMakerExpectingResponse x7$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received a request expecting a response (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.reqId$1), this.x7$1}));
                        }
                        {
                            this.reqId$1 = reqId$1;
                            this.x7$1 = x7$1;
                        }
                    });
                    Request request = maker.apply(reqId);
                    Try try_ = MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$pickChannel(this.$outer, request);
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable error = failure.exception();
                        MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, requestMakerExpectingResponse){
                            public static final long serialVersionUID = 0L;
                            private final RequestMakerExpectingResponse x7$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No channel, error with promise ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x7$1.promise()}));
                            }
                            {
                                this.x7$1 = x7$1;
                            }
                        });
                        requestMakerExpectingResponse.promise().failure(error);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                        Success success = (Success)try_;
                        Tuple2 tuple2 = (Tuple2)success.value();
                        if (tuple2 == null) throw new MatchError((Object)try_);
                        Node node = (Node)tuple2._1();
                        Connection connection2 = (Connection)tuple2._2();
                        MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, reqId, request, node, connection2){
                            public static final long serialVersionUID = 0L;
                            private final int reqId$1;
                            private final Request request$1;
                            private final Node node$1;
                            private final Connection connection$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending request (", ") expecting response by connection ", " of node ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.reqId$1), this.connection$1, this.node$1.name(), this.request$1}));
                            }
                            {
                                this.reqId$1 = reqId$1;
                                this.request$1 = request$1;
                                this.node$1 = node$1;
                                this.connection$1 = connection$1;
                            }
                        });
                        if (request.op().expectsResponse()) {
                            this.$outer.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)request.requestID())), (Object)new AwaitingResponse(reqId, Predef$.MODULE$.Integer2int(connection2.channel().getId()), requestMakerExpectingResponse.promise(), false, requestMakerExpectingResponse.isMongo26WriteOp())));
                            MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, reqId){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;
                                private final int reqId$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"registering awaiting response for requestID ", ", awaitingResponses: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.reqId$1), this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$awaitingResponses()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.reqId$1 = reqId$1;
                                }
                            });
                        } else {
                            MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, reqId){
                                public static final long serialVersionUID = 0L;
                                private final int reqId$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NOT registering awaiting response for requestID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.reqId$1)}));
                                }
                                {
                                    this.reqId$1 = reqId$1;
                                }
                            });
                        }
                        connection2.send(request);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (A1 instanceof CheckedWriteRequestExpectingResponse) {
                    Tuple2 tuple2;
                    CheckedWriteRequestExpectingResponse checkedWriteRequestExpectingResponse = (CheckedWriteRequestExpectingResponse)A1;
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Received a checked write request";
                        }
                    });
                    CheckedWriteRequest checkedWriteRequest = checkedWriteRequestExpectingResponse.checkedWriteRequest();
                    int requestId = RequestId$.MODULE$.common().next();
                    Tuple2<RequestMaker, RequestMaker> tuple = checkedWriteRequest.apply();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((RequestMaker)tuple._1()).apply(requestId)), (Object)((RequestMaker)tuple._2()).apply(requestId));
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    Request request = (Request)tuple22._1();
                    Request writeConcern = (Request)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)request, (Object)writeConcern);
                    Request request2 = (Request)tuple23._1();
                    Request writeConcern2 = (Request)tuple23._2();
                    Try try_ = MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$pickChannel(this.$outer, request2);
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable error = failure.exception();
                        checkedWriteRequestExpectingResponse.promise().failure(error);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                        Success success = (Success)try_;
                        Tuple2 tuple24 = (Tuple2)success.value();
                        if (tuple24 == null) throw new MatchError((Object)try_);
                        Node node = (Node)tuple24._1();
                        Connection connection3 = (Connection)tuple24._2();
                        MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, request2, node, connection3){
                            public static final long serialVersionUID = 0L;
                            private final Request request$2;
                            private final Node node$2;
                            private final Connection connection$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending request expecting response ", " by connection ", " of node ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$2, this.connection$2, this.node$2.name()}));
                            }
                            {
                                this.request$2 = request$2;
                                this.node$2 = node$2;
                                this.connection$2 = connection$2;
                            }
                        });
                        this.$outer.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)requestId)), (Object)new AwaitingResponse(requestId, Predef$.MODULE$.Integer2int(connection3.channel().getId()), checkedWriteRequestExpectingResponse.promise(), true, false)));
                        MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, requestId){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;
                            private final int requestId$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"registering awaiting response for requestID ", ", awaitingResponses: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.requestId$1), this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$awaitingResponses()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.requestId$1 = requestId$1;
                            }
                        });
                        connection3.send(request2, writeConcern2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (ConnectAll$.MODULE$.equals(A1)) {
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(this.$outer, this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().createNeededChannels(this.$outer.self(), this.$outer.options().nbChannelsPerNode(), this.$outer.reactivemongo$core$actors$MongoDBSystem$$cFactory()));
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"ConnectAll Job running... Status: ").append((Object)((TraversableOnce)this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Node x$9) {
                                    return x$9.toShortString();
                                }
                            }, Vector$.MODULE$.canBuildFrom())).mkString(" | ")).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$connectAll(this.$outer, this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (RefreshAllNodes$.MODULE$.equals(A1)) {
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;

                        public final NodeSet apply(Node node) {
                            MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, node){
                                public static final long serialVersionUID = 0L;
                                private final Node node$3;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"try to refresh ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node$3.name()}));
                                }
                                {
                                    this.node$3 = node$3;
                                }
                            });
                            return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateAll((Function1<Node, Node>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$$anonfun$4$.anonfun.applyOrElse.20 $outer;

                                public final Node apply(Node node) {
                                    return this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().sendIsMaster(node, RequestId$.MODULE$.isMaster().next());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                        }

                        public /* synthetic */ MongoDBSystem$.anonfun.4 reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RefreshAllNodes Job running... Status: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().toShortString()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (A1 instanceof ChannelConnected) {
                    ChannelConnected channelConnected = (ChannelConnected)A1;
                    int channelId = channelConnected.channelId();
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(this.$outer, this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateByChannelId(channelId, (Function1<Connection, Connection>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Connection apply(Connection x$10) {
                            ConnectionStatus$Connected$ x$51 = ConnectionStatus$Connected$.MODULE$;
                            Channel x$52 = x$10.copy$default$1();
                            Set<Authenticated> x$53 = x$10.copy$default$3();
                            Option<Authenticating> x$54 = x$10.copy$default$4();
                            return x$10.copy(x$52, x$51, x$53, x$54);
                        }
                    }, (Function1<Node, Node>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;

                        public final Node apply(Node node) {
                            return this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().sendIsMaster(node, RequestId$.MODULE$.isMaster().next());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, channelId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;
                        private final int channelId$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Channel #", " connected. NodeSet status: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.channelId$2), this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().toShortString()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.channelId$2 = channelId$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (A1 instanceof ChannelUnavailable && !(option = ChannelUnavailable$.MODULE$.unapply(channelUnavailable = (ChannelUnavailable)A1)).isEmpty()) {
                    NodeSet nodeSet;
                    int channelId = BoxesRunTime.unboxToInt((Object)option.get());
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, channelId, channelUnavailable){
                        public static final long serialVersionUID = 0L;
                        private final int channelId$3;
                        private final ChannelUnavailable x12$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Channel #", " unavailable (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.channelId$3), this.x12$1}));
                        }
                        {
                            this.channelId$3 = channelId$3;
                            this.x12$1 = x12$1;
                        }
                    });
                    boolean nodeSetWasReachable = this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().isReachable();
                    boolean primaryWasAvailable = this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().primary().isDefined();
                    ChannelUnavailable channelUnavailable2 = channelUnavailable;
                    if (channelUnavailable2 instanceof ChannelClosed) {
                        nodeSet = MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(this.$outer, this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateNodeByChannelId(channelId, (Function1<Node, Node>)new Serializable(this, channelId){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;
                            public final int channelId$3;

                            public final Node apply(Node node) {
                                return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$unauthenticate(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), node, (Vector)node.connections().filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MongoDBSystem$$anonfun$4$.anonfun.applyOrElse.26 $outer;

                                    public final boolean apply(Connection x$11) {
                                        return !BoxesRunTime.equalsNumObject((Number)x$11.channel().getId(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.channelId$3));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.channelId$3 = channelId$3;
                            }
                        }));
                    } else {
                        if (!(channelUnavailable2 instanceof ChannelDisconnected)) throw new MatchError((Object)channelUnavailable2);
                        nodeSet = this.$outer.updateNodeSetOnDisconnect(channelId);
                    }
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().retain((Function2)new Serializable(this, channelId){
                        public static final long serialVersionUID = 0L;
                        private final int channelId$3;

                        public final boolean apply(int x$12, AwaitingResponse awaitingResponse) {
                            boolean bl;
                            if (awaitingResponse.channelID() == this.channelId$3) {
                                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, awaitingResponse){
                                    public static final long serialVersionUID = 0L;
                                    private final AwaitingResponse awaitingResponse$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"completing promise ", " with error='socket disconnected'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.awaitingResponse$1.promise()}));
                                    }
                                    {
                                        this.awaitingResponse$1 = awaitingResponse$1;
                                    }
                                });
                                awaitingResponse.promise().failure((Throwable)new GenericDriverException("socket disconnected"));
                                bl = false;
                            } else {
                                bl = true;
                            }
                            return bl;
                        }
                        {
                            this.channelId$3 = channelId$3;
                        }
                    });
                    if (this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().isReachable()) {
                        if (!this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().primary().isDefined()) {
                            if (primaryWasAvailable) {
                                MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "The primary is unavailable, is there a network problem?";
                                    }
                                });
                                MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(this.$outer, PrimaryUnavailable$.MODULE$);
                            } else {
                                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "The primary is still unavailable, is there a network problem?";
                                    }
                                });
                            }
                        }
                    } else if (nodeSetWasReachable) {
                        MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "The entire node set is unreachable, is there a network problem?";
                            }
                        });
                        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(this.$outer, SetUnavailable$.MODULE$);
                    } else {
                        MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "The entire node set is still unreachable, is there a network problem?";
                            }
                        });
                    }
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, channelId){
                        public static final long serialVersionUID = 0L;
                        private final int channelId$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Channel #", " is released"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.channelId$3)}));
                        }
                        {
                            this.channelId$3 = channelId$3;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var4_15;
                }
                if (A1 instanceof Response) {
                    Response response = (Response)A1;
                    if (RequestId$.MODULE$.isMaster().accepts(response)) {
                        boolean nodeSetWasReachable = this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().isReachable();
                        Seq wasPrimary = (Seq)Option$.MODULE$.option2Iterable(this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().primary()).toSeq().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<String> apply(Node x$13) {
                                return x$13.names();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        VolatileObjectRef chanNode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
                        IsMasterCommand.IsMasterResult isMaster = (IsMasterCommand.IsMasterResult)Command$.MODULE$.deserialize(BSONSerializationPack$.MODULE$, response, BSONIsMasterCommandImplicits$IsMasterResultReader$.MODULE$);
                        NodeSet ns = this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateNodeByChannelId(response.info().channelId(), (Function1<Node, Node>)new Serializable(this, chanNode, isMaster, response){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;
                            private final VolatileObjectRef chanNode$1;
                            private final IsMasterCommand.IsMasterResult isMaster$1;
                            private final Response x14$1;

                            public final Node apply(Node node) {
                                this.chanNode$1.elem = new Some((Object)node);
                                PingInfo pingInfo = node.pingInfo().lastIsMasterId() == this.x14$1.header().responseTo() ? node.pingInfo().copy(System.currentTimeMillis() - node.pingInfo().lastIsMasterTime(), 0L, -1) : node.pingInfo();
                                Node authenticating = this.isMaster$1.status().queryable() && !this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().authenticates().isEmpty() ? MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$authenticateNode(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), node, this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().authenticates().toSeq()) : node;
                                ProtocolMetadata meta = new ProtocolMetadata(MongoWireVersion$.MODULE$.apply(this.isMaster$1.minWireVersion()), MongoWireVersion$.MODULE$.apply(this.isMaster$1.maxWireVersion()), this.isMaster$1.maxBsonObjectSize(), this.isMaster$1.maxMessageSizeBytes(), this.isMaster$1.maxWriteBatchSize());
                                NodeStatus x$55 = this.isMaster$1.status();
                                PingInfo x$56 = pingInfo;
                                Option x$57 = this.isMaster$1.replicaSet().flatMap((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Option<BSONDocument> apply(IsMasterCommand.ReplicaSet x$14) {
                                        return x$14.tags();
                                    }
                                });
                                ProtocolMetadata x$58 = meta;
                                boolean x$59 = this.isMaster$1.isMongos();
                                String x$60 = authenticating.copy$default$1();
                                Vector<Connection> x$61 = authenticating.copy$default$3();
                                Set<Authenticated> x$62 = authenticating.copy$default$4();
                                Node an = authenticating.copy(x$60, x$55, x$61, x$62, (Option<BSONDocument>)x$57, x$58, x$56, x$59);
                                return (Node)this.isMaster$1.replicaSet().fold((Function0)new Serializable(this, an){
                                    public static final long serialVersionUID = 0L;
                                    private final Node an$1;

                                    public final Node apply() {
                                        return this.an$1;
                                    }
                                    {
                                        this.an$1 = an$1;
                                    }
                                }, (Function1)new Serializable(this, an){
                                    public static final long serialVersionUID = 0L;
                                    private final Node an$1;

                                    public final Node apply(IsMasterCommand.ReplicaSet rs) {
                                        return this.an$1.withAlias(rs.me());
                                    }
                                    {
                                        this.an$1 = an$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.chanNode$1 = chanNode$1;
                                this.isMaster$1 = isMaster$1;
                                this.x14$1 = x14$1;
                            }
                        });
                        Seq upNodes = (Seq)Option$.MODULE$.option2Iterable(isMaster.replicaSet()).toSeq().flatMap((Function1)new Serializable(this, ns){
                            public static final long serialVersionUID = 0L;
                            public final NodeSet ns$1;

                            public final Seq<Node> apply(IsMasterCommand.ReplicaSet rs) {
                                return (Seq)rs.hosts().collect((PartialFunction)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MongoDBSystem$$anonfun$4$.anonfun.18 $outer;

                                    public final <A1 extends String, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                        A1 A1 = x3;
                                        Object object = this.$outer.ns$1.nodes().exists((Function1)new Serializable(this, A1){
                                            public static final long serialVersionUID = 0L;
                                            private final String x1$2;

                                            public final boolean apply(Node x$15) {
                                                return x$15.names().contains((Object)this.x1$2);
                                            }
                                            {
                                                this.x1$2 = x1$2;
                                            }
                                        }) ? function1.apply(x3) : new Node(A1, NodeStatus$Uninitialized$.MODULE$, (Vector<Connection>)scala.package$.MODULE$.Vector().empty(), (Set<Authenticated>)Predef$.MODULE$.Set().empty(), (Option<BSONDocument>)None$.MODULE$, ProtocolMetadata$.MODULE$.Default(), Node$.MODULE$.apply$default$7(), Node$.MODULE$.apply$default$8());
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(String x3) {
                                        String string = x3;
                                        boolean bl = !this.$outer.ns$1.nodes().exists((Function1)new Serializable(this, string){
                                            public static final long serialVersionUID = 0L;
                                            private final String x1$3;

                                            public final boolean apply(Node x$15) {
                                                return x$15.names().contains((Object)this.x1$3);
                                            }
                                            {
                                                this.x1$3 = x1$3;
                                            }
                                        });
                                        return bl;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.ns$1 = ns$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Vector x$63 = (Vector)ns.nodes().$plus$plus((GenTraversableOnce)upNodes, Vector$.MODULE$.canBuildFrom());
                        Option<String> x$64 = ns.copy$default$1();
                        Option<Object> x$65 = ns.copy$default$2();
                        Set<Authenticate> x$66 = ns.copy$default$4();
                        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(this.$outer, MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$connectAll(this.$outer, ns.copy(x$64, x$65, (Vector<Node>)x$63, x$66).createNeededChannels(this.$outer.self(), this.$outer.options().nbChannelsPerNode(), this.$outer.reactivemongo$core$actors$MongoDBSystem$$cFactory())));
                        ((Option)chanNode.elem).foreach((Function1)new Serializable(this, nodeSetWasReachable, wasPrimary){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoDBSystem$.anonfun.4 $outer;
                            private final boolean nodeSetWasReachable$1;
                            public final Seq wasPrimary$1;

                            public final void apply(Node node) {
                                if (!this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().authenticates().isEmpty() && node.authenticated().isEmpty()) {
                                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, node){
                                        public static final long serialVersionUID = 0L;
                                        private final Node node$4;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The node set is available (", "); Waiting authentication: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node$4.names(), this.node$4.authenticated()}));
                                        }
                                        {
                                            this.node$4 = node$4;
                                        }
                                    });
                                } else {
                                    if (!this.nodeSetWasReachable$1 && this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().isReachable()) {
                                        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), new SetAvailable(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().protocolMetadata()));
                                        MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "The node set is now available";
                                            }
                                        });
                                    }
                                    if (this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().primary().exists((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ MongoDBSystem$$anonfun$4$.anonfun.applyOrElse.34 $outer;

                                        public final boolean apply(Node n) {
                                            return !this.$outer.wasPrimary$1.contains((Object)n.name());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    })) {
                                        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), new PrimaryAvailable(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$nodeSet().protocolMetadata()));
                                        MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable(this, node){
                                            public static final long serialVersionUID = 0L;
                                            private final Node node$4;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The primary is now available: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node$4.names()}));
                                            }
                                            {
                                                this.node$4 = node$4;
                                            }
                                        });
                                    }
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.nodeSetWasReachable$1 = nodeSetWasReachable$1;
                                this.wasPrimary$1 = wasPrimary$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var4_15;
                    }
                }
                Object object = function1.apply(x2);
                return var4_15;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x2) {
                ChannelUnavailable channelUnavailable;
                Option<Object> option;
                Object object = x2;
                if (RegisterMonitor$.MODULE$.equals(object)) {
                    return true;
                }
                if (Close$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RequestMaker) {
                    return true;
                }
                if (object instanceof RequestMakerExpectingResponse) {
                    return true;
                }
                if (object instanceof CheckedWriteRequestExpectingResponse) {
                    return true;
                }
                if (ConnectAll$.MODULE$.equals(object)) {
                    return true;
                }
                if (RefreshAllNodes$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ChannelConnected) {
                    return true;
                }
                if (object instanceof ChannelUnavailable && !(option = ChannelUnavailable$.MODULE$.unapply(channelUnavailable = (ChannelUnavailable)object)).isEmpty()) {
                    return true;
                }
                if (!(object instanceof Response)) return false;
                Response response = (Response)object;
                if (!RequestId$.MODULE$.isMaster().accepts(response)) return false;
                return true;
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$fallback_$eq((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x4;
                if (A1 instanceof Response) {
                    Response response = (Response)A1;
                    if (RequestId$.MODULE$.common().accepts(response)) {
                        Some some;
                        AwaitingResponse awaitingResponse;
                        Option option = this.$outer.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().get((Object)BoxesRunTime.boxToInteger((int)response.header().responseTo()));
                        if (option instanceof Some && (awaitingResponse = (AwaitingResponse)(some = (Some)option).x()) != null) {
                            BoxedUnit boxedUnit2;
                            Promise<Response> promise = awaitingResponse.promise();
                            boolean isGetLastError = awaitingResponse.isGetLastError();
                            boolean isMongo26WriteOp = awaitingResponse.isMongo26WriteOp();
                            MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, promise, response){
                                public static final long serialVersionUID = 0L;
                                private final Promise promise$1;
                                private final Response x4$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got a response from ", " to ", "! Will give back message=", " to promise ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.info().channelId()), BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo()), this.x4$1, BoxesRunTime.boxToInteger((int)System.identityHashCode(this.promise$1))}));
                                }
                                {
                                    this.promise$1 = promise$1;
                                    this.x4$1 = x4$1;
                                }
                            });
                            this.$outer.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().$minus$eq((Object)BoxesRunTime.boxToInteger((int)response.header().responseTo()));
                            if (response.error().isDefined()) {
                                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, response){
                                    public static final long serialVersionUID = 0L;
                                    private final Response x4$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} sending a failure... (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo()), this.x4$1.error().get()}));
                                    }
                                    {
                                        this.x4$1 = x4$1;
                                    }
                                });
                                if (((DatabaseException)response.error().get()).isNotAPrimaryError()) {
                                    this.$outer.onPrimaryUnavailable();
                                }
                                promise.failure((Throwable)response.error().get());
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if (isGetLastError) {
                                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, response){
                                    public static final long serialVersionUID = 0L;
                                    private final Response x4$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} it's a getlasterror"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo())}));
                                    }
                                    {
                                        this.x4$1 = x4$1;
                                    }
                                });
                                MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$lastError(this.$outer, response).fold((Function1)new Serializable(this, promise, response){
                                    public static final long serialVersionUID = 0L;
                                    private final Promise promise$1;
                                    public final Response x4$1;

                                    public final Promise<Response> apply(Throwable e) {
                                        MongoDBSystem$.MODULE$.logger().error((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ MongoDBSystem$$anonfun$5$.anonfun.applyOrElse.38 $outer;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deserializing LastError message #", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.x4$1.header().responseTo())}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        }, (Function0<Throwable>)new Serializable(this, e){
                                            public static final long serialVersionUID = 0L;
                                            private final Throwable e$1;

                                            public final Throwable apply() {
                                                return this.e$1;
                                            }
                                            {
                                                this.e$1 = e$1;
                                            }
                                        });
                                        return this.promise$1.failure((Throwable)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deserializing LastError message #", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo())})), e));
                                    }
                                    {
                                        this.promise$1 = promise$1;
                                        this.x4$1 = x4$1;
                                    }
                                }, (Function1)new Serializable(this, promise, response){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MongoDBSystem$.anonfun.5 $outer;
                                    private final Promise promise$1;
                                    public final Response x4$1;

                                    public final Promise<Response> apply(LastError lastError) {
                                        Promise promise;
                                        if (lastError.inError()) {
                                            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ MongoDBSystem$$anonfun$5$.anonfun.applyOrElse.39 $outer;

                                                public final String apply() {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} sending a failure (lasterror is not ok)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.x4$1.header().responseTo())}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                            if (lastError.isNotAPrimaryError()) {
                                                this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().onPrimaryUnavailable();
                                            }
                                            promise = this.promise$1.failure((Throwable)lastError);
                                        } else {
                                            MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ MongoDBSystem$$anonfun$5$.anonfun.applyOrElse.39 $outer;

                                                public final String apply() {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} sending a success (lasterror is ok)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.x4$1.header().responseTo())}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                            this.x4$1.documents().readerIndex(this.x4$1.documents().readerIndex());
                                            promise = this.promise$1.success((Object)this.x4$1);
                                        }
                                        return promise;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.promise$1 = promise$1;
                                        this.x4$1 = x4$1;
                                    }
                                });
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else if (isMongo26WriteOp) {
                                MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Received a response to a MongoDB2.6 Write Op";
                                    }
                                });
                                LowLevelBsonDocReader reader = new LowLevelBsonDocReader((ReadableBuffer)new ChannelBufferReadableBuffer(response.documents()));
                                Stream fields = reader.fieldStream();
                                Option okField = fields.find((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Field x$16) {
                                        String string = x$16.name();
                                        String string2 = "ok";
                                        return !(string != null ? !string.equals(string2) : string2 != null);
                                    }
                                });
                                MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, okField, response){
                                    public static final long serialVersionUID = 0L;
                                    private final Option okField$1;
                                    private final Response x4$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} ok field is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo()), this.okField$1}));
                                    }
                                    {
                                        this.okField$1 = okField$1;
                                        this.x4$1 = x4$1;
                                    }
                                });
                                boolean processedOk = BoxesRunTime.unboxToBoolean((Object)okField.collect((PartialFunction)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final <A1 extends Field, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                                        Object object;
                                        A1 A1 = x5;
                                        if (A1 instanceof BooleanField) {
                                            BooleanField booleanField = (BooleanField)A1;
                                            boolean v = booleanField.value();
                                            object = BoxesRunTime.boxToBoolean((boolean)v);
                                        } else {
                                            DoubleField doubleField;
                                            double v;
                                            IntField intField;
                                            int v2;
                                            object = A1 instanceof IntField ? BoxesRunTime.boxToBoolean(((v2 = (intField = (IntField)A1).value()) != 0 ? 1 : 0) != 0) : (A1 instanceof DoubleField ? BoxesRunTime.boxToBoolean(((v = (doubleField = (DoubleField)A1).value()) != 0.0 ? 1 : 0) != 0) : function1.apply(x5));
                                        }
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(Field x5) {
                                        Field field = x5;
                                        boolean bl = field instanceof BooleanField ? true : (field instanceof IntField ? true : field instanceof DoubleField);
                                        return bl;
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply() {
                                        return this.apply$mcZ$sp();
                                    }

                                    public boolean apply$mcZ$sp() {
                                        return false;
                                    }
                                }));
                                if (processedOk) {
                                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, response){
                                        public static final long serialVersionUID = 0L;
                                        private final Response x4$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} [MongoDB26 Write Op response] sending a success!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo())}));
                                        }
                                        {
                                            this.x4$1 = x4$1;
                                        }
                                    });
                                    promise.success((Object)response);
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, response){
                                        public static final long serialVersionUID = 0L;
                                        private final Response x4$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} [MongoDB26 Write Op response] processedOk is false! sending an error"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo())}));
                                        }
                                        {
                                            this.x4$1 = x4$1;
                                        }
                                    });
                                    boolean notAPrimary = fields.find((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(Field x$17) {
                                            String string = x$17.name();
                                            String string2 = "errmsg";
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                    }).exists((Function1)new Serializable(this, response){
                                        public static final long serialVersionUID = 0L;
                                        public final Response x4$1;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final boolean apply(Field x0$3) {
                                            Field field = x0$3;
                                            if (field instanceof LazyField) {
                                                LazyField lazyField = (LazyField)field;
                                                byte by = lazyField.tpe();
                                                ReadableBuffer buf = lazyField.buffer();
                                                if (2 == by) {
                                                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, lazyField){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ MongoDBSystem$$anonfun$5$.anonfun.21 $outer;
                                                        private final LazyField x2$3;

                                                        public final String apply() {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} [MongoDB26 Write Op response] errmsg is ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.x4$1.header().responseTo()), this.x2$3}));
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                            this.x2$3 = x2$3;
                                                        }
                                                    });
                                                    String string = buf.readString();
                                                    String string2 = "not a primary";
                                                    if (string != null) {
                                                        if (!string.equals(string2)) return false;
                                                        return true;
                                                    }
                                                    if (string2 == null) return true;
                                                    return false;
                                                }
                                            }
                                            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, field){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ MongoDBSystem$$anonfun$5$.anonfun.21 $outer;
                                                private final Field x1$4;

                                                public final String apply() {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} [MongoDB26 Write Op response] errmsg is ", " but not interesting!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.x4$1.header().responseTo()), this.x1$4}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.x1$4 = x1$4;
                                                }
                                            });
                                            return false;
                                        }
                                        {
                                            this.x4$1 = x4$1;
                                        }
                                    });
                                    if (notAPrimary) {
                                        MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this, response){
                                            public static final long serialVersionUID = 0L;
                                            private final Response x4$1;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} [MongoDB26 Write Op response] not a primary error!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo())}));
                                            }
                                            {
                                                this.x4$1 = x4$1;
                                            }
                                        });
                                        this.$outer.onPrimaryUnavailable();
                                    }
                                    promise.failure((Throwable)new GenericDriverException("not ok"));
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                            } else {
                                MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable(this, response){
                                    public static final long serialVersionUID = 0L;
                                    private final Response x4$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{", "} [MongoDB26 Write Op response] sending a success!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo())}));
                                    }
                                    {
                                        this.x4$1 = x4$1;
                                    }
                                });
                                promise.success((Object)response);
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit3 = boxedUnit2;
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            MongoDBSystem$.MODULE$.logger().error((Function0<String>)new Serializable(this, response){
                                public static final long serialVersionUID = 0L;
                                private final Response x4$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"oups. ", " not found! complete message is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x4$1.header().responseTo()), this.x4$1}));
                                }
                                {
                                    this.x4$1 = x4$1;
                                }
                            });
                            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        return (B1)boxedUnit;
                    }
                }
                if (A1 instanceof AuthRequest) {
                    AuthRequest authRequest = (AuthRequest)A1;
                    Authenticate authenticate2 = authRequest.authenticate();
                    MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable(this, authenticate2){
                        public static final long serialVersionUID = 0L;
                        private final Authenticate authenticate$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New authenticate request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.authenticate$1}));
                        }
                        {
                            this.authenticate$1 = authenticate$1;
                        }
                    });
                    this.$outer.reactivemongo$core$actors$MongoDBSystem$$AuthRequestsManager().addAuthRequest(authRequest);
                    NodeSet qual$1 = this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet();
                    Set x$67 = (Set)this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().authenticates().$plus((Object)authenticate2);
                    Option<String> x$68 = qual$1.copy$default$1();
                    Option<Object> x$69 = qual$1.copy$default$2();
                    Vector<Node> x$70 = qual$1.copy$default$3();
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(this.$outer, MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$authenticateNodeSet(this.$outer, qual$1.copy(x$68, x$69, x$70, (Set<Authenticate>)x$67)));
                    boxedUnit = BoxedUnit.UNIT;
                    return (B1)boxedUnit;
                }
                MongoDBSystem$.MODULE$.logger().error((Function0<String>)new Serializable(this, A1){
                    public static final long serialVersionUID = 0L;
                    private final Object x1$5;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$5}));
                    }
                    {
                        this.x1$5 = x1$5;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x4) {
                Object object = x4;
                if (object instanceof Response) {
                    Response response = (Response)object;
                    if (RequestId$.MODULE$.common().accepts(response)) {
                        return true;
                    }
                }
                if (!(object instanceof AuthRequest)) return true;
                return true;
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet_$eq(new NodeSet((Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Vector<Node>)((TraversableOnce)$this.seeds().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final Node apply(String seed) {
                return new Node(seed, NodeStatus$Unknown$.MODULE$, (Vector<Connection>)scala.package$.MODULE$.Vector().empty(), (Set<Authenticated>)Predef$.MODULE$.Set().empty(), (Option<BSONDocument>)None$.MODULE$, ProtocolMetadata$.MODULE$.Default(), Node$.MODULE$.apply$default$7(), Node$.MODULE$.apply$default$8()).createNeededChannels(this.$outer.self(), 1, this.$outer.reactivemongo$core$actors$MongoDBSystem$$cFactory());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector(), (Set<Authenticate>)$this.initialAuthenticates().toSet()));
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$connectAll($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet());
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)RefreshAllNodes$.MODULE$, $this.self());
    }
}

