/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.Record;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.Compressor;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.FailoverStrategy$;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$Compressors$;
import reactivemongo.api.MongoConnection$ParseState$;
import reactivemongo.api.MongoConnection$URIBuilder$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.MongoConnectionOptions$Credential$;
import reactivemongo.api.MongoConnectionOptions$KeyStore$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadConcern$;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.ReadPreference$Primary$;
import reactivemongo.api.ScramSha1Authentication$;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.WriteConcern$;
import reactivemongo.api.WriteConcern$Majority$;
import reactivemongo.api.WriteConcern$TagSet$;
import reactivemongo.api.WriteConcern$WaitForAcknowledgments$;
import reactivemongo.api.X509Authentication$;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import reactivemongo.util.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class MongoConnection$ {
    public static MongoConnection$ MODULE$;
    private final String DefaultHost;
    private final int DefaultPort;
    private final LazyLogger.LazyLogger logger;
    private final Regex UnsignedInt;
    private final Regex IntRe;
    private final Regex FailoverRe;

    static {
        new MongoConnection$();
    }

    public String DefaultHost() {
        return this.DefaultHost;
    }

    public int DefaultPort() {
        return this.DefaultPort;
    }

    public LazyLogger.LazyLogger logger() {
        return this.logger;
    }

    public Future<MongoConnection.URI<Option<String>>> fromString(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.default());
    }

    public Future<MongoConnection.URI<String>> fromStringWithDB(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.requiredDB());
    }

    public <T> Future<MongoConnection.URI<T>> parse(String uri, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, Function1<String, Future<ListSet<String>>> txtResolver, ExecutionContext ec, MongoConnection.URIBuilder<T> uriBuilder) {
        boolean seedList = uri.startsWith("mongodb+srv://");
        Function4 & Serializable & scala.Serializable createUri = (Function4 & Serializable & scala.Serializable)(hosts, options, ignoredOptions, db) -> uriBuilder.apply((ListSet<Tuple2<String, Object>>)hosts, (MongoConnectionOptions)options, (List<String>)ignoredOptions, (Option<String>)db).recoverWith((PartialFunction)new scala.Serializable(uri){
            public static final long serialVersionUID = 0L;
            private final String uri$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                    object = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(2).append(illegalArgumentException.getMessage()).append(": ").append(this.uri$1).toString()));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IllegalArgumentException;
                return bl;
            }
            {
                this.uri$1 = uri$1;
            }
        }, ec);
        return (uri.startsWith("mongodb://") ? Future$.MODULE$.successful(new StringOps(Predef$.MODULE$.augmentString(uri)).drop(10)) : (seedList ? Future$.MODULE$.successful(new StringOps(Predef$.MODULE$.augmentString(uri)).drop(14)) : Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(16).append("Invalid scheme: ").append(uri).toString())))).map((Function1 & Serializable & scala.Serializable)useful -> {
            String setSpec = (String)new StringOps(Predef$.MODULE$.augmentString(useful)).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$3(BoxesRunTime.unboxToChar((Object)x$5))));
            int credentialEnd = setSpec.indexOf("@");
            return new Tuple3(useful, (Object)setSpec, (Object)BoxesRunTime.boxToInteger((int)credentialEnd));
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            MongoConnectionOptions mongoConnectionOptions;
            int credentialEnd;
            String setSpec;
            String useful;
            Tuple3 tuple3 = x$9;
            if (tuple3 != null) {
                useful = (String)tuple3._1();
                setSpec = (String)tuple3._2();
                credentialEnd = BoxesRunTime.unboxToInt((Object)tuple3._3());
                MongoConnectionOptions empty = MongoConnectionOptions$.MODULE$.default();
                if (!seedList) {
                    mongoConnectionOptions = empty;
                } else {
                    boolean x$1 = true;
                    int x$2 = empty.copy$default$1();
                    Option<String> x$3 = empty.copy$default$2();
                    boolean x$4 = empty.copy$default$4();
                    AuthenticationMode x$5 = empty.copy$default$5();
                    boolean x$6 = empty.copy$default$6();
                    boolean x$7 = empty.copy$default$7();
                    int x$82 = empty.copy$default$8();
                    Option<Object> x$92 = empty.copy$default$9();
                    int x$10 = empty.copy$default$10();
                    WriteConcern x$11 = empty.copy$default$11();
                    ReadPreference x$12 = empty.copy$default$12();
                    FailoverStrategy x$13 = empty.copy$default$13();
                    int x$14 = empty.copy$default$14();
                    int x$15 = empty.copy$default$15();
                    int x$16 = empty.copy$default$16();
                    scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$17 = empty.copy$default$17();
                    Option<MongoConnectionOptions.KeyStore> x$18 = empty.copy$default$18();
                    ReadConcern x$19 = empty.copy$default$19();
                    Option<String> x$20 = empty.copy$default$20();
                    mongoConnectionOptions = empty.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$82, x$92, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            MongoConnectionOptions initial = mongoConnectionOptions;
            Future future = MongoConnection$.txtOptions$1(seedList, setSpec, credentialEnd, txtResolver, ec).flatMap((Function1 & Serializable & scala.Serializable)txt -> MODULE$.parseOptions(MongoConnection$.optionStr$1(useful, setSpec)).map((Function1 & Serializable & scala.Serializable)os -> {
                Tuple2<List<String>, MongoConnectionOptions> opts = MODULE$.makeOptions((scala.collection.immutable.Map<String, String>)txt.$plus$plus((GenTraversableOnce)os), initial);
                return new Tuple2(os, opts);
            }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
                Tuple2 tuple2 = x$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 opts = (Tuple2)tuple2._2();
                Future future = (((MongoConnectionOptions)opts._2()).maxIdleTimeMS() != 0 && ((MongoConnectionOptions)opts._2()).maxIdleTimeMS() < ((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS() ? Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(61).append("Invalid URI options: maxIdleTimeMS(").append(((MongoConnectionOptions)opts._2()).maxIdleTimeMS()).append(") < heartbeatFrequencyMS(").append(((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS()).append(")").toString())) : Future$.MODULE$.successful((Object)opts)).map((Function1 & Serializable & scala.Serializable)res -> res, ec);
                return future;
            }, ec), ec).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$15(check$ifrefutable$1)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
                Future future;
                Tuple2 tuple2 = x$8;
                if (tuple2 != null) {
                    List unsupportedKeys = (List)tuple2._1();
                    MongoConnectionOptions options = (MongoConnectionOptions)tuple2._2();
                    if (credentialEnd == -1) {
                        future = MODULE$.parseHostsAndDB(seedList, setSpec, srvRecResolver, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Future future;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                Option db = (Option)tuple2._1();
                                ListSet hosts = (ListSet)tuple2._2();
                                AuthenticationMode authenticationMode = options.authenticationMechanism();
                                if (X509Authentication$.MODULE$.equals(authenticationMode)) {
                                    Future future2;
                                    Option option = db;
                                    if (option instanceof Some) {
                                        Some some = (Some)option;
                                        String dbName = (String)some.value();
                                        scala.collection.immutable.Map x$21 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dbName), (Object)MongoConnectionOptions$Credential$.MODULE$.apply("", (Option<String>)None$.MODULE$))}));
                                        int x$22 = options.copy$default$1();
                                        Option<String> x$23 = options.copy$default$2();
                                        boolean x$24 = options.copy$default$3();
                                        boolean x$25 = options.copy$default$4();
                                        AuthenticationMode x$26 = options.copy$default$5();
                                        boolean x$27 = options.copy$default$6();
                                        boolean x$28 = options.copy$default$7();
                                        int x$29 = options.copy$default$8();
                                        Option<Object> x$30 = options.copy$default$9();
                                        int x$31 = options.copy$default$10();
                                        WriteConcern x$32 = options.copy$default$11();
                                        ReadPreference x$33 = options.copy$default$12();
                                        FailoverStrategy x$34 = options.copy$default$13();
                                        int x$35 = options.copy$default$14();
                                        int x$36 = options.copy$default$15();
                                        int x$37 = options.copy$default$16();
                                        Option<MongoConnectionOptions.KeyStore> x$38 = options.copy$default$18();
                                        ReadConcern x$39 = options.copy$default$19();
                                        Option<String> x$40 = options.copy$default$20();
                                        MongoConnectionOptions optsWithX509 = options.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, (scala.collection.immutable.Map<String, MongoConnectionOptions.Credential>)x$21, x$38, x$39, x$40);
                                        future2 = (Future)createUri.apply((Object)hosts, (Object)optsWithX509, (Object)unsupportedKeys, (Object)db);
                                    } else {
                                        future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                    }
                                    future = future2;
                                } else {
                                    future = (Future)createUri.apply((Object)hosts, (Object)options, (Object)unsupportedKeys, (Object)db);
                                }
                            } else {
                                throw new MatchError((Object)tuple2);
                            }
                            Future future3 = future;
                            return future3;
                        }, ec);
                    } else {
                        Future future2;
                        String string;
                        Regex WithAuth = new StringOps(Predef$.MODULE$.augmentString("([^:]+)(|:[^@]*)@(.+)")).r();
                        Option option = WithAuth.unapplySeq((CharSequence)(string = setSpec));
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                            String user = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String p = (String)((LinearSeqOptimized)option.get()).apply(1);
                            String hostsPortsAndDB = (String)((LinearSeqOptimized)option.get()).apply(2);
                            String pass = new StringOps(Predef$.MODULE$.augmentString(p)).stripPrefix(":");
                            future2 = MODULE$.parseHostsAndDB(seedList, hostsPortsAndDB, srvRecResolver, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Future future;
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                Option option = (Option)tuple2._1();
                                ListSet hosts = (ListSet)tuple2._2();
                                if (!(option instanceof Some)) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                Some some = (Some)option;
                                String database = (String)some.value();
                                AuthenticationMode authenticationMode = options.authenticationMechanism();
                                X509Authentication$ x509Authentication$ = X509Authentication$.MODULE$;
                                if (!(authenticationMode != null ? !authenticationMode.equals(x509Authentication$) : x509Authentication$ != null) && new StringOps(Predef$.MODULE$.augmentString(pass)).nonEmpty()) {
                                    future = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException("You should not provide a password when authenticating with X509 authentication"));
                                    return future;
                                } else {
                                    AuthenticationMode authenticationMode2 = options.authenticationMechanism();
                                    X509Authentication$ x509Authentication$2 = X509Authentication$.MODULE$;
                                    Option password = (authenticationMode2 == null ? x509Authentication$2 != null : !authenticationMode2.equals(x509Authentication$2)) ? Option$.MODULE$.apply((Object)pass) : Option$.MODULE$.empty();
                                    String authDb = (String)options.authenticationDatabase().getOrElse((Function0 & Serializable & scala.Serializable)() -> database);
                                    scala.collection.immutable.Map x$41 = options.credentials().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)authDb), (Object)MongoConnectionOptions$Credential$.MODULE$.apply(user, (Option<String>)password)));
                                    int x$42 = options.copy$default$1();
                                    Option<String> x$43 = options.copy$default$2();
                                    boolean x$44 = options.copy$default$3();
                                    boolean x$45 = options.copy$default$4();
                                    AuthenticationMode x$46 = options.copy$default$5();
                                    boolean x$47 = options.copy$default$6();
                                    boolean x$48 = options.copy$default$7();
                                    int x$49 = options.copy$default$8();
                                    Option<Object> x$50 = options.copy$default$9();
                                    int x$51 = options.copy$default$10();
                                    WriteConcern x$52 = options.copy$default$11();
                                    ReadPreference x$53 = options.copy$default$12();
                                    FailoverStrategy x$54 = options.copy$default$13();
                                    int x$55 = options.copy$default$14();
                                    int x$56 = options.copy$default$15();
                                    int x$57 = options.copy$default$16();
                                    Option<MongoConnectionOptions.KeyStore> x$58 = options.copy$default$18();
                                    ReadConcern x$59 = options.copy$default$19();
                                    Option<String> x$60 = options.copy$default$20();
                                    MongoConnectionOptions optsWithCred = options.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, (scala.collection.immutable.Map<String, MongoConnectionOptions.Credential>)x$41, x$58, x$59, x$60);
                                    future = (Future)createUri.apply((Object)hosts, (Object)optsWithCred, (Object)unsupportedKeys, (Object)new Some((Object)database));
                                }
                                return future;
                            }, ec);
                        } else {
                            future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(22).append("Could not parse URI '").append(uri).append("'").toString()));
                        }
                        future = future2;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Future future3 = future.map((Function1 & Serializable & scala.Serializable)parsedUri -> parsedUri, ec);
                return future3;
            }, ec);
            return future;
        }, ec);
    }

    private Future<ListSet<Tuple2<String, Object>>> parseHosts(boolean seedList, String hosts, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        Future future;
        if (seedList) {
            future = ((Future)Await$.MODULE$.ready(package$.MODULE$.srvRecords(hosts, srvRecResolver, ec), (Duration)package$.MODULE$.dnsTimeout())).map((Function1 & Serializable & scala.Serializable)x$10 -> ((ListSet)ListSet$.MODULE$.empty()).$plus$plus((GenTraversableOnce)x$10), ec);
        } else {
            Builder buf = ListSet$.MODULE$.newBuilder();
            future = this.parse$1((Iterable)Predef$.MODULE$.wrapRefArray((Object[])hosts.split(",")), buf);
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Tuple2<Option<String>, ListSet<Tuple2<String, Object>>>> parseHostsAndDB(boolean seedList, String input, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(input)).span((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHostsAndDB$1(BoxesRunTime.unboxToChar((Object)x$12))));
        if (tuple2 != null) {
            String hosts = (String)tuple2._1();
            String string = (String)tuple2._2();
            if ("".equals(string)) {
                return this.parseHosts(seedList, hosts, srvRecResolver, ec).map((Function1 & Serializable & scala.Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), x$13), ec);
            }
        }
        if (tuple2 == null) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(47).append("Could not parse hosts and database from URI: '").append(input).append("'").toString()));
        String hosts = (String)tuple2._1();
        String dbName = (String)tuple2._2();
        return this.parseHosts(seedList, hosts, srvRecResolver, ec).map((Function1 & Serializable & scala.Serializable)x$14 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some(new StringOps(Predef$.MODULE$.augmentString(dbName)).drop(1))), x$14), ec);
    }

    private Future<scala.collection.immutable.Map<String, String>> parseOptions(String options) {
        Future future;
        if (options.isEmpty()) {
            future = Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        } else {
            Map buf = Map$.MODULE$.empty();
            future = this.parse$2((Iterable)Predef$.MODULE$.wrapRefArray((Object[])options.split("&")), options, buf);
        }
        return future;
    }

    private Regex UnsignedInt() {
        return this.UnsignedInt;
    }

    private Regex IntRe() {
        return this.IntRe;
    }

    private Regex FailoverRe() {
        return this.FailoverRe;
    }

    private Tuple2<List<String>, MongoConnectionOptions> makeOptions(scala.collection.immutable.Map<String, String> opts, MongoConnectionOptions initial) {
        MongoConnection.ParseState parsed1 = (MongoConnection.ParseState)opts.iterator().foldLeft((Object)new MongoConnection.ParseState(initial, MongoConnection$ParseState$.MODULE$.apply$default$2()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String string;
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null && "replicaSet".equals(string = (String)tuple22._1())) {
                    MODULE$.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection option 'replicaSet' is ignored: determined from servers response");
                    return state;
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple23 != null) {
                    String string = (String)tuple23._1();
                    String string2 = (String)tuple23._2();
                    if ("authenticationMechanism".equals(string) && "x509".equals(string2)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$16 -> {
                            X509Authentication$ x$1 = X509Authentication$.MODULE$;
                            int x$2 = x$16.copy$default$1();
                            Option<String> x$3 = x$16.copy$default$2();
                            boolean x$4 = x$16.copy$default$3();
                            boolean x$5 = x$16.copy$default$4();
                            boolean x$6 = x$16.copy$default$6();
                            boolean x$7 = x$16.copy$default$7();
                            int x$8 = x$16.copy$default$8();
                            Option<Object> x$9 = x$16.copy$default$9();
                            int x$10 = x$16.copy$default$10();
                            WriteConcern x$11 = x$16.copy$default$11();
                            ReadPreference x$12 = x$16.copy$default$12();
                            FailoverStrategy x$13 = x$16.copy$default$13();
                            int x$14 = x$16.copy$default$14();
                            int x$15 = x$16.copy$default$15();
                            int x$162 = x$16.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$17 = x$16.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$18 = x$16.copy$default$18();
                            ReadConcern x$19 = x$16.copy$default$19();
                            Option<String> x$20 = x$16.copy$default$20();
                            return x$16.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$162, x$17, x$18, x$19, x$20);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 != null) {
                    String string = (String)tuple24._1();
                    String string3 = (String)tuple24._2();
                    if ("authenticationMechanism".equals(string) && "scram-sha256".equals(string3)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$17 -> {
                            ScramSha256Authentication$ x$21 = ScramSha256Authentication$.MODULE$;
                            int x$22 = x$17.copy$default$1();
                            Option<String> x$23 = x$17.copy$default$2();
                            boolean x$24 = x$17.copy$default$3();
                            boolean x$25 = x$17.copy$default$4();
                            boolean x$26 = x$17.copy$default$6();
                            boolean x$27 = x$17.copy$default$7();
                            int x$28 = x$17.copy$default$8();
                            Option<Object> x$29 = x$17.copy$default$9();
                            int x$30 = x$17.copy$default$10();
                            WriteConcern x$31 = x$17.copy$default$11();
                            ReadPreference x$32 = x$17.copy$default$12();
                            FailoverStrategy x$33 = x$17.copy$default$13();
                            int x$34 = x$17.copy$default$14();
                            int x$35 = x$17.copy$default$15();
                            int x$36 = x$17.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$37 = x$17.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$38 = x$17.copy$default$18();
                            ReadConcern x$39 = x$17.copy$default$19();
                            Option<String> x$40 = x$17.copy$default$20();
                            return x$17.copy(x$22, x$23, x$24, x$25, x$21, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                String string;
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple25 != null && "authenticationMechanism".equals(string = (String)tuple25._1())) {
                    return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$18 -> {
                        ScramSha1Authentication$ x$41 = ScramSha1Authentication$.MODULE$;
                        int x$42 = x$18.copy$default$1();
                        Option<String> x$43 = x$18.copy$default$2();
                        boolean x$44 = x$18.copy$default$3();
                        boolean x$45 = x$18.copy$default$4();
                        boolean x$46 = x$18.copy$default$6();
                        boolean x$47 = x$18.copy$default$7();
                        int x$48 = x$18.copy$default$8();
                        Option<Object> x$49 = x$18.copy$default$9();
                        int x$50 = x$18.copy$default$10();
                        WriteConcern x$51 = x$18.copy$default$11();
                        ReadPreference x$52 = x$18.copy$default$12();
                        FailoverStrategy x$53 = x$18.copy$default$13();
                        int x$54 = x$18.copy$default$14();
                        int x$55 = x$18.copy$default$15();
                        int x$56 = x$18.copy$default$16();
                        scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$57 = x$18.copy$default$17();
                        Option<MongoConnectionOptions.KeyStore> x$58 = x$18.copy$default$18();
                        ReadConcern x$59 = x$18.copy$default$19();
                        Option<String> x$60 = x$18.copy$default$20();
                        return x$18.copy(x$42, x$43, x$44, x$45, x$41, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
                    });
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple26 = (Tuple2)tuple2._2();
                if (tuple26 != null) {
                    String n = (String)tuple26._1();
                    String v2 = (String)tuple26._2();
                    boolean bl = "authenticationDatabase".equals(n) ? true : "authSource".equals(n);
                    if (bl) {
                        this.deprecated$1(n, "authenticationDatabase");
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$19 -> {
                            Some x$61 = new Some((Object)v2);
                            int x$62 = x$19.copy$default$1();
                            boolean x$63 = x$19.copy$default$3();
                            boolean x$64 = x$19.copy$default$4();
                            AuthenticationMode x$65 = x$19.copy$default$5();
                            boolean x$66 = x$19.copy$default$6();
                            boolean x$67 = x$19.copy$default$7();
                            int x$68 = x$19.copy$default$8();
                            Option<Object> x$69 = x$19.copy$default$9();
                            int x$70 = x$19.copy$default$10();
                            WriteConcern x$71 = x$19.copy$default$11();
                            ReadPreference x$72 = x$19.copy$default$12();
                            FailoverStrategy x$73 = x$19.copy$default$13();
                            int x$74 = x$19.copy$default$14();
                            int x$75 = x$19.copy$default$15();
                            int x$76 = x$19.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$77 = x$19.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$78 = x$19.copy$default$18();
                            ReadConcern x$79 = x$19.copy$default$19();
                            Option<String> x$80 = x$19.copy$default$20();
                            return x$19.copy(x$62, (Option<String>)x$61, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple27 = (Tuple2)tuple2._2();
                if (tuple27 != null) {
                    String string = (String)tuple27._1();
                    String v3 = (String)tuple27._2();
                    if ("connectTimeoutMS".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$20 -> x$20.copy(new StringOps(Predef$.MODULE$.augmentString(v3)).toInt(), x$20.copy$default$2(), x$20.copy$default$3(), x$20.copy$default$4(), x$20.copy$default$5(), x$20.copy$default$6(), x$20.copy$default$7(), x$20.copy$default$8(), x$20.copy$default$9(), x$20.copy$default$10(), x$20.copy$default$11(), x$20.copy$default$12(), x$20.copy$default$13(), x$20.copy$default$14(), x$20.copy$default$15(), x$20.copy$default$16(), x$20.copy$default$17(), x$20.copy$default$18(), x$20.copy$default$19(), x$20.copy$default$20()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple28 = (Tuple2)tuple2._2();
                if (tuple28 != null) {
                    String string = (String)tuple28._1();
                    String v4 = (String)tuple28._2();
                    if ("maxIdleTimeMS".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$21 -> {
                            int x$81 = new StringOps(Predef$.MODULE$.augmentString(v4)).toInt();
                            int x$82 = x$21.copy$default$1();
                            Option<String> x$83 = x$21.copy$default$2();
                            boolean x$84 = x$21.copy$default$3();
                            boolean x$85 = x$21.copy$default$4();
                            AuthenticationMode x$86 = x$21.copy$default$5();
                            boolean x$87 = x$21.copy$default$6();
                            boolean x$88 = x$21.copy$default$7();
                            int x$89 = x$21.copy$default$8();
                            Option<Object> x$90 = x$21.copy$default$9();
                            int x$91 = x$21.copy$default$10();
                            WriteConcern x$92 = x$21.copy$default$11();
                            ReadPreference x$93 = x$21.copy$default$12();
                            FailoverStrategy x$94 = x$21.copy$default$13();
                            int x$95 = x$21.copy$default$14();
                            int x$96 = x$21.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$97 = x$21.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$98 = x$21.copy$default$18();
                            ReadConcern x$99 = x$21.copy$default$19();
                            Option<String> x$100 = x$21.copy$default$20();
                            return x$21.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$81, x$96, x$97, x$98, x$99, x$100);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple29 = (Tuple2)tuple2._2();
                if (tuple29 != null) {
                    String string = (String)tuple29._1();
                    String v5 = (String)tuple29._2();
                    if ("ssl".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$22 -> {
                            boolean x$101 = new StringOps(Predef$.MODULE$.augmentString(v5)).toBoolean();
                            int x$102 = x$22.copy$default$1();
                            Option<String> x$103 = x$22.copy$default$2();
                            boolean x$104 = x$22.copy$default$4();
                            AuthenticationMode x$105 = x$22.copy$default$5();
                            boolean x$106 = x$22.copy$default$6();
                            boolean x$107 = x$22.copy$default$7();
                            int x$108 = x$22.copy$default$8();
                            Option<Object> x$109 = x$22.copy$default$9();
                            int x$110 = x$22.copy$default$10();
                            WriteConcern x$111 = x$22.copy$default$11();
                            ReadPreference x$112 = x$22.copy$default$12();
                            FailoverStrategy x$113 = x$22.copy$default$13();
                            int x$114 = x$22.copy$default$14();
                            int x$115 = x$22.copy$default$15();
                            int x$116 = x$22.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$117 = x$22.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$118 = x$22.copy$default$18();
                            ReadConcern x$119 = x$22.copy$default$19();
                            Option<String> x$120 = x$22.copy$default$20();
                            return x$22.copy(x$102, x$103, x$101, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple210 = (Tuple2)tuple2._2();
                if (tuple210 != null) {
                    String string = (String)tuple210._1();
                    String v6 = (String)tuple210._2();
                    if ("sslAllowsInvalidCert".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$23 -> {
                            boolean x$121 = new StringOps(Predef$.MODULE$.augmentString(v6)).toBoolean();
                            int x$122 = x$23.copy$default$1();
                            Option<String> x$123 = x$23.copy$default$2();
                            boolean x$124 = x$23.copy$default$3();
                            AuthenticationMode x$125 = x$23.copy$default$5();
                            boolean x$126 = x$23.copy$default$6();
                            boolean x$127 = x$23.copy$default$7();
                            int x$128 = x$23.copy$default$8();
                            Option<Object> x$129 = x$23.copy$default$9();
                            int x$130 = x$23.copy$default$10();
                            WriteConcern x$131 = x$23.copy$default$11();
                            ReadPreference x$132 = x$23.copy$default$12();
                            FailoverStrategy x$133 = x$23.copy$default$13();
                            int x$134 = x$23.copy$default$14();
                            int x$135 = x$23.copy$default$15();
                            int x$136 = x$23.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$137 = x$23.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$138 = x$23.copy$default$18();
                            ReadConcern x$139 = x$23.copy$default$19();
                            Option<String> x$140 = x$23.copy$default$20();
                            return x$23.copy(x$122, x$123, x$124, x$121, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple211 = (Tuple2)tuple2._2();
                if (tuple211 != null) {
                    Option<Tuple2<ListSet<Compressor>, Seq<String>>> option;
                    String string = (String)tuple211._1();
                    String string4 = (String)tuple211._2();
                    if ("compressors".equals(string) && !(option = MongoConnection$Compressors$.MODULE$.unapply(string4)).isEmpty()) {
                        ListSet compressors = (ListSet)((Tuple2)option.get())._1();
                        Seq invalid = (Seq)((Tuple2)option.get())._2();
                        return ((MongoConnection.ParseState)invalid.foldLeft((Object)state, (Function2 & Serializable & scala.Serializable)(st, c) -> st.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compressors"), c)))).updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$24 -> x$24.withCompressors((ListSet<Compressor>)compressors));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple212 = (Tuple2)tuple2._2();
                if (tuple212 != null) {
                    String string = (String)tuple212._1();
                    String v7 = (String)tuple212._2();
                    if ("rm.tcpNoDelay".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$25 -> {
                            boolean x$141 = new StringOps(Predef$.MODULE$.augmentString(v7)).toBoolean();
                            int x$142 = x$25.copy$default$1();
                            Option<String> x$143 = x$25.copy$default$2();
                            boolean x$144 = x$25.copy$default$3();
                            boolean x$145 = x$25.copy$default$4();
                            AuthenticationMode x$146 = x$25.copy$default$5();
                            boolean x$147 = x$25.copy$default$7();
                            int x$148 = x$25.copy$default$8();
                            Option<Object> x$149 = x$25.copy$default$9();
                            int x$150 = x$25.copy$default$10();
                            WriteConcern x$151 = x$25.copy$default$11();
                            ReadPreference x$152 = x$25.copy$default$12();
                            FailoverStrategy x$153 = x$25.copy$default$13();
                            int x$154 = x$25.copy$default$14();
                            int x$155 = x$25.copy$default$15();
                            int x$156 = x$25.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$157 = x$25.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$158 = x$25.copy$default$18();
                            ReadConcern x$159 = x$25.copy$default$19();
                            Option<String> x$160 = x$25.copy$default$20();
                            return x$25.copy(x$142, x$143, x$144, x$145, x$146, x$141, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple213 = (Tuple2)tuple2._2();
                if (tuple213 != null) {
                    String string = (String)tuple213._1();
                    String v8 = (String)tuple213._2();
                    if ("rm.keepAlive".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$26 -> {
                            boolean x$161 = new StringOps(Predef$.MODULE$.augmentString(v8)).toBoolean();
                            int x$162 = x$26.copy$default$1();
                            Option<String> x$163 = x$26.copy$default$2();
                            boolean x$164 = x$26.copy$default$3();
                            boolean x$165 = x$26.copy$default$4();
                            AuthenticationMode x$166 = x$26.copy$default$5();
                            boolean x$167 = x$26.copy$default$6();
                            int x$168 = x$26.copy$default$8();
                            Option<Object> x$169 = x$26.copy$default$9();
                            int x$170 = x$26.copy$default$10();
                            WriteConcern x$171 = x$26.copy$default$11();
                            ReadPreference x$172 = x$26.copy$default$12();
                            FailoverStrategy x$173 = x$26.copy$default$13();
                            int x$174 = x$26.copy$default$14();
                            int x$175 = x$26.copy$default$15();
                            int x$176 = x$26.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$177 = x$26.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$178 = x$26.copy$default$18();
                            ReadConcern x$179 = x$26.copy$default$19();
                            Option<String> x$180 = x$26.copy$default$20();
                            return x$26.copy(x$162, x$163, x$164, x$165, x$166, x$167, x$161, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple214 = (Tuple2)tuple2._2();
                if (tuple214 != null) {
                    String string = (String)tuple214._1();
                    String v9 = (String)tuple214._2();
                    if ("rm.nbChannelsPerNode".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$27 -> {
                            int x$181 = new StringOps(Predef$.MODULE$.augmentString(v9)).toInt();
                            int x$182 = x$27.copy$default$1();
                            Option<String> x$183 = x$27.copy$default$2();
                            boolean x$184 = x$27.copy$default$3();
                            boolean x$185 = x$27.copy$default$4();
                            AuthenticationMode x$186 = x$27.copy$default$5();
                            boolean x$187 = x$27.copy$default$6();
                            boolean x$188 = x$27.copy$default$7();
                            Option<Object> x$189 = x$27.copy$default$9();
                            int x$190 = x$27.copy$default$10();
                            WriteConcern x$191 = x$27.copy$default$11();
                            ReadPreference x$192 = x$27.copy$default$12();
                            FailoverStrategy x$193 = x$27.copy$default$13();
                            int x$194 = x$27.copy$default$14();
                            int x$195 = x$27.copy$default$15();
                            int x$196 = x$27.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$197 = x$27.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$198 = x$27.copy$default$18();
                            ReadConcern x$199 = x$27.copy$default$19();
                            Option<String> x$200 = x$27.copy$default$20();
                            return x$27.copy(x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$181, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199, x$200);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple215 = (Tuple2)tuple2._2();
                if (tuple215 != null) {
                    Option option;
                    String string = (String)tuple215._1();
                    String string5 = (String)tuple215._2();
                    if ("rm.maxInFlightRequestsPerChannel".equals(string) && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string5)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String max = (String)((LinearSeqOptimized)option.get()).apply(0);
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$28 -> {
                            Some x$201 = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(max)).toInt()));
                            int x$202 = x$28.copy$default$1();
                            Option<String> x$203 = x$28.copy$default$2();
                            boolean x$204 = x$28.copy$default$3();
                            boolean x$205 = x$28.copy$default$4();
                            AuthenticationMode x$206 = x$28.copy$default$5();
                            boolean x$207 = x$28.copy$default$6();
                            boolean x$208 = x$28.copy$default$7();
                            int x$209 = x$28.copy$default$8();
                            int x$210 = x$28.copy$default$10();
                            WriteConcern x$211 = x$28.copy$default$11();
                            ReadPreference x$212 = x$28.copy$default$12();
                            FailoverStrategy x$213 = x$28.copy$default$13();
                            int x$214 = x$28.copy$default$14();
                            int x$215 = x$28.copy$default$15();
                            int x$216 = x$28.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$217 = x$28.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$218 = x$28.copy$default$18();
                            ReadConcern x$219 = x$28.copy$default$19();
                            Option<String> x$220 = x$28.copy$default$20();
                            return x$28.copy(x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, (Option<Object>)x$201, x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217, x$218, x$219, x$220);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple216 = (Tuple2)tuple2._2();
                if (tuple216 != null) {
                    Option option;
                    String string = (String)tuple216._1();
                    String string6 = (String)tuple216._2();
                    if ("rm.minIdleChannelsPerNode".equals(string) && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string6)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String min = (String)((LinearSeqOptimized)option.get()).apply(0);
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$29 -> {
                            int x$221 = new StringOps(Predef$.MODULE$.augmentString(min)).toInt();
                            int x$222 = x$29.copy$default$1();
                            Option<String> x$223 = x$29.copy$default$2();
                            boolean x$224 = x$29.copy$default$3();
                            boolean x$225 = x$29.copy$default$4();
                            AuthenticationMode x$226 = x$29.copy$default$5();
                            boolean x$227 = x$29.copy$default$6();
                            boolean x$228 = x$29.copy$default$7();
                            int x$229 = x$29.copy$default$8();
                            Option<Object> x$230 = x$29.copy$default$9();
                            WriteConcern x$231 = x$29.copy$default$11();
                            ReadPreference x$232 = x$29.copy$default$12();
                            FailoverStrategy x$233 = x$29.copy$default$13();
                            int x$234 = x$29.copy$default$14();
                            int x$235 = x$29.copy$default$15();
                            int x$236 = x$29.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$237 = x$29.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$238 = x$29.copy$default$18();
                            ReadConcern x$239 = x$29.copy$default$19();
                            Option<String> x$240 = x$29.copy$default$20();
                            return x$29.copy(x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$221, x$231, x$232, x$233, x$234, x$235, x$236, x$237, x$238, x$239, x$240);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple217 = (Tuple2)tuple2._2();
                if (tuple217 != null) {
                    Option option;
                    String string = (String)tuple217._1();
                    String string7 = (String)tuple217._2();
                    if ("rm.maxNonQueryableHeartbeats".equals(string) && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string7)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String max;
                        String string8 = max = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String string9 = "0";
                        if (string8 == null ? string9 != null : !string8.equals(string9)) {
                            return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$30 -> x$30.withMaxNonQueryableHeartbeats(new StringOps(Predef$.MODULE$.augmentString(max)).toInt()));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple218 = (Tuple2)tuple2._2();
                if (tuple218 != null) {
                    String string = (String)tuple218._1();
                    String string10 = (String)tuple218._2();
                    if ("writeConcern".equals(string) && "unacknowledged".equals(string10)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$31 -> {
                            WriteConcern x$241 = WriteConcern$.MODULE$.Unacknowledged();
                            int x$242 = x$31.copy$default$1();
                            Option<String> x$243 = x$31.copy$default$2();
                            boolean x$244 = x$31.copy$default$3();
                            boolean x$245 = x$31.copy$default$4();
                            AuthenticationMode x$246 = x$31.copy$default$5();
                            boolean x$247 = x$31.copy$default$6();
                            boolean x$248 = x$31.copy$default$7();
                            int x$249 = x$31.copy$default$8();
                            Option<Object> x$250 = x$31.copy$default$9();
                            int x$251 = x$31.copy$default$10();
                            ReadPreference x$252 = x$31.copy$default$12();
                            FailoverStrategy x$253 = x$31.copy$default$13();
                            int x$254 = x$31.copy$default$14();
                            int x$255 = x$31.copy$default$15();
                            int x$256 = x$31.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$257 = x$31.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$258 = x$31.copy$default$18();
                            ReadConcern x$259 = x$31.copy$default$19();
                            Option<String> x$260 = x$31.copy$default$20();
                            return x$31.copy(x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$241, x$252, x$253, x$254, x$255, x$256, x$257, x$258, x$259, x$260);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple219 = (Tuple2)tuple2._2();
                if (tuple219 != null) {
                    String string = (String)tuple219._1();
                    String string11 = (String)tuple219._2();
                    if ("writeConcern".equals(string) && "acknowledged".equals(string11)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$32 -> {
                            WriteConcern x$261 = WriteConcern$.MODULE$.Acknowledged();
                            int x$262 = x$32.copy$default$1();
                            Option<String> x$263 = x$32.copy$default$2();
                            boolean x$264 = x$32.copy$default$3();
                            boolean x$265 = x$32.copy$default$4();
                            AuthenticationMode x$266 = x$32.copy$default$5();
                            boolean x$267 = x$32.copy$default$6();
                            boolean x$268 = x$32.copy$default$7();
                            int x$269 = x$32.copy$default$8();
                            Option<Object> x$270 = x$32.copy$default$9();
                            int x$271 = x$32.copy$default$10();
                            ReadPreference x$272 = x$32.copy$default$12();
                            FailoverStrategy x$273 = x$32.copy$default$13();
                            int x$274 = x$32.copy$default$14();
                            int x$275 = x$32.copy$default$15();
                            int x$276 = x$32.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$277 = x$32.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$278 = x$32.copy$default$18();
                            ReadConcern x$279 = x$32.copy$default$19();
                            Option<String> x$280 = x$32.copy$default$20();
                            return x$32.copy(x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, x$270, x$271, x$261, x$272, x$273, x$274, x$275, x$276, x$277, x$278, x$279, x$280);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple220 = (Tuple2)tuple2._2();
                if (tuple220 != null) {
                    String string = (String)tuple220._1();
                    String string12 = (String)tuple220._2();
                    if ("writeConcern".equals(string) && "journaled".equals(string12)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$33 -> {
                            WriteConcern x$281 = WriteConcern$.MODULE$.Journaled();
                            int x$282 = x$33.copy$default$1();
                            Option<String> x$283 = x$33.copy$default$2();
                            boolean x$284 = x$33.copy$default$3();
                            boolean x$285 = x$33.copy$default$4();
                            AuthenticationMode x$286 = x$33.copy$default$5();
                            boolean x$287 = x$33.copy$default$6();
                            boolean x$288 = x$33.copy$default$7();
                            int x$289 = x$33.copy$default$8();
                            Option<Object> x$290 = x$33.copy$default$9();
                            int x$291 = x$33.copy$default$10();
                            ReadPreference x$292 = x$33.copy$default$12();
                            FailoverStrategy x$293 = x$33.copy$default$13();
                            int x$294 = x$33.copy$default$14();
                            int x$295 = x$33.copy$default$15();
                            int x$296 = x$33.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$297 = x$33.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$298 = x$33.copy$default$18();
                            ReadConcern x$299 = x$33.copy$default$19();
                            Option<String> x$300 = x$33.copy$default$20();
                            return x$33.copy(x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$290, x$291, x$281, x$292, x$293, x$294, x$295, x$296, x$297, x$298, x$299, x$300);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple221 = (Tuple2)tuple2._2();
                if (tuple221 != null) {
                    String string = (String)tuple221._1();
                    String string13 = (String)tuple221._2();
                    if ("writeConcern".equals(string) && "default".equals(string13)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$34 -> {
                            WriteConcern x$301 = WriteConcern$.MODULE$.Default();
                            int x$302 = x$34.copy$default$1();
                            Option<String> x$303 = x$34.copy$default$2();
                            boolean x$304 = x$34.copy$default$3();
                            boolean x$305 = x$34.copy$default$4();
                            AuthenticationMode x$306 = x$34.copy$default$5();
                            boolean x$307 = x$34.copy$default$6();
                            boolean x$308 = x$34.copy$default$7();
                            int x$309 = x$34.copy$default$8();
                            Option<Object> x$310 = x$34.copy$default$9();
                            int x$311 = x$34.copy$default$10();
                            ReadPreference x$312 = x$34.copy$default$12();
                            FailoverStrategy x$313 = x$34.copy$default$13();
                            int x$314 = x$34.copy$default$14();
                            int x$315 = x$34.copy$default$15();
                            int x$316 = x$34.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$317 = x$34.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$318 = x$34.copy$default$18();
                            ReadConcern x$319 = x$34.copy$default$19();
                            Option<String> x$320 = x$34.copy$default$20();
                            return x$34.copy(x$302, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$301, x$312, x$313, x$314, x$315, x$316, x$317, x$318, x$319, x$320);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple222 = (Tuple2)tuple2._2();
                if (tuple222 != null) {
                    String string = (String)tuple222._1();
                    String string14 = (String)tuple222._2();
                    if ("readPreference".equals(string) && "primary".equals(string14)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$35 -> {
                            ReadPreference$Primary$ x$321 = ReadPreference$.MODULE$.primary();
                            int x$322 = x$35.copy$default$1();
                            Option<String> x$323 = x$35.copy$default$2();
                            boolean x$324 = x$35.copy$default$3();
                            boolean x$325 = x$35.copy$default$4();
                            AuthenticationMode x$326 = x$35.copy$default$5();
                            boolean x$327 = x$35.copy$default$6();
                            boolean x$328 = x$35.copy$default$7();
                            int x$329 = x$35.copy$default$8();
                            Option<Object> x$330 = x$35.copy$default$9();
                            int x$331 = x$35.copy$default$10();
                            WriteConcern x$332 = x$35.copy$default$11();
                            FailoverStrategy x$333 = x$35.copy$default$13();
                            int x$334 = x$35.copy$default$14();
                            int x$335 = x$35.copy$default$15();
                            int x$336 = x$35.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$337 = x$35.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$338 = x$35.copy$default$18();
                            ReadConcern x$339 = x$35.copy$default$19();
                            Option<String> x$340 = x$35.copy$default$20();
                            return x$35.copy(x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329, x$330, x$331, x$332, x$321, x$333, x$334, x$335, x$336, x$337, x$338, x$339, x$340);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple223 = (Tuple2)tuple2._2();
                if (tuple223 != null) {
                    String string = (String)tuple223._1();
                    String string15 = (String)tuple223._2();
                    if ("readPreference".equals(string) && "primaryPreferred".equals(string15)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$36 -> {
                            ReadPreference.PrimaryPreferred x$341 = ReadPreference$.MODULE$.primaryPreferred();
                            int x$342 = x$36.copy$default$1();
                            Option<String> x$343 = x$36.copy$default$2();
                            boolean x$344 = x$36.copy$default$3();
                            boolean x$345 = x$36.copy$default$4();
                            AuthenticationMode x$346 = x$36.copy$default$5();
                            boolean x$347 = x$36.copy$default$6();
                            boolean x$348 = x$36.copy$default$7();
                            int x$349 = x$36.copy$default$8();
                            Option<Object> x$350 = x$36.copy$default$9();
                            int x$351 = x$36.copy$default$10();
                            WriteConcern x$352 = x$36.copy$default$11();
                            FailoverStrategy x$353 = x$36.copy$default$13();
                            int x$354 = x$36.copy$default$14();
                            int x$355 = x$36.copy$default$15();
                            int x$356 = x$36.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$357 = x$36.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$358 = x$36.copy$default$18();
                            ReadConcern x$359 = x$36.copy$default$19();
                            Option<String> x$360 = x$36.copy$default$20();
                            return x$36.copy(x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352, x$341, x$353, x$354, x$355, x$356, x$357, x$358, x$359, x$360);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple224 = (Tuple2)tuple2._2();
                if (tuple224 != null) {
                    String string = (String)tuple224._1();
                    String string16 = (String)tuple224._2();
                    if ("readPreference".equals(string) && "secondary".equals(string16)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$37 -> {
                            ReadPreference.Secondary x$361 = ReadPreference$.MODULE$.secondary();
                            int x$362 = x$37.copy$default$1();
                            Option<String> x$363 = x$37.copy$default$2();
                            boolean x$364 = x$37.copy$default$3();
                            boolean x$365 = x$37.copy$default$4();
                            AuthenticationMode x$366 = x$37.copy$default$5();
                            boolean x$367 = x$37.copy$default$6();
                            boolean x$368 = x$37.copy$default$7();
                            int x$369 = x$37.copy$default$8();
                            Option<Object> x$370 = x$37.copy$default$9();
                            int x$371 = x$37.copy$default$10();
                            WriteConcern x$372 = x$37.copy$default$11();
                            FailoverStrategy x$373 = x$37.copy$default$13();
                            int x$374 = x$37.copy$default$14();
                            int x$375 = x$37.copy$default$15();
                            int x$376 = x$37.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$377 = x$37.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$378 = x$37.copy$default$18();
                            ReadConcern x$379 = x$37.copy$default$19();
                            Option<String> x$380 = x$37.copy$default$20();
                            return x$37.copy(x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$371, x$372, x$361, x$373, x$374, x$375, x$376, x$377, x$378, x$379, x$380);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple225 = (Tuple2)tuple2._2();
                if (tuple225 != null) {
                    String string = (String)tuple225._1();
                    String string17 = (String)tuple225._2();
                    if ("readPreference".equals(string) && "secondaryPreferred".equals(string17)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$38 -> {
                            ReadPreference.SecondaryPreferred x$381 = ReadPreference$.MODULE$.secondaryPreferred();
                            int x$382 = x$38.copy$default$1();
                            Option<String> x$383 = x$38.copy$default$2();
                            boolean x$384 = x$38.copy$default$3();
                            boolean x$385 = x$38.copy$default$4();
                            AuthenticationMode x$386 = x$38.copy$default$5();
                            boolean x$387 = x$38.copy$default$6();
                            boolean x$388 = x$38.copy$default$7();
                            int x$389 = x$38.copy$default$8();
                            Option<Object> x$390 = x$38.copy$default$9();
                            int x$391 = x$38.copy$default$10();
                            WriteConcern x$392 = x$38.copy$default$11();
                            FailoverStrategy x$393 = x$38.copy$default$13();
                            int x$394 = x$38.copy$default$14();
                            int x$395 = x$38.copy$default$15();
                            int x$396 = x$38.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$397 = x$38.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$398 = x$38.copy$default$18();
                            ReadConcern x$399 = x$38.copy$default$19();
                            Option<String> x$400 = x$38.copy$default$20();
                            return x$38.copy(x$382, x$383, x$384, x$385, x$386, x$387, x$388, x$389, x$390, x$391, x$392, x$381, x$393, x$394, x$395, x$396, x$397, x$398, x$399, x$400);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple226 = (Tuple2)tuple2._2();
                if (tuple226 != null) {
                    String string = (String)tuple226._1();
                    String string18 = (String)tuple226._2();
                    if ("readPreference".equals(string) && "nearest".equals(string18)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$39 -> {
                            ReadPreference.Nearest x$401 = ReadPreference$.MODULE$.nearest();
                            int x$402 = x$39.copy$default$1();
                            Option<String> x$403 = x$39.copy$default$2();
                            boolean x$404 = x$39.copy$default$3();
                            boolean x$405 = x$39.copy$default$4();
                            AuthenticationMode x$406 = x$39.copy$default$5();
                            boolean x$407 = x$39.copy$default$6();
                            boolean x$408 = x$39.copy$default$7();
                            int x$409 = x$39.copy$default$8();
                            Option<Object> x$410 = x$39.copy$default$9();
                            int x$411 = x$39.copy$default$10();
                            WriteConcern x$412 = x$39.copy$default$11();
                            FailoverStrategy x$413 = x$39.copy$default$13();
                            int x$414 = x$39.copy$default$14();
                            int x$415 = x$39.copy$default$15();
                            int x$416 = x$39.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$417 = x$39.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$418 = x$39.copy$default$18();
                            ReadConcern x$419 = x$39.copy$default$19();
                            Option<String> x$420 = x$39.copy$default$20();
                            return x$39.copy(x$402, x$403, x$404, x$405, x$406, x$407, x$408, x$409, x$410, x$411, x$412, x$401, x$413, x$414, x$415, x$416, x$417, x$418, x$419, x$420);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple227 = (Tuple2)tuple2._2();
                if (tuple227 != null) {
                    Option<ReadConcern> option;
                    String string = (String)tuple227._1();
                    String string19 = (String)tuple227._2();
                    if ("readConcernLevel".equals(string) && !(option = ReadConcern$.MODULE$.unapply(string19)).isEmpty()) {
                        ReadConcern c2 = (ReadConcern)option.get();
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$40 -> {
                            ReadConcern x$421 = c2;
                            int x$422 = x$40.copy$default$1();
                            Option<String> x$423 = x$40.copy$default$2();
                            boolean x$424 = x$40.copy$default$3();
                            boolean x$425 = x$40.copy$default$4();
                            AuthenticationMode x$426 = x$40.copy$default$5();
                            boolean x$427 = x$40.copy$default$6();
                            boolean x$428 = x$40.copy$default$7();
                            int x$429 = x$40.copy$default$8();
                            Option<Object> x$430 = x$40.copy$default$9();
                            int x$431 = x$40.copy$default$10();
                            WriteConcern x$432 = x$40.copy$default$11();
                            ReadPreference x$433 = x$40.copy$default$12();
                            FailoverStrategy x$434 = x$40.copy$default$13();
                            int x$435 = x$40.copy$default$14();
                            int x$436 = x$40.copy$default$15();
                            int x$437 = x$40.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$438 = x$40.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$439 = x$40.copy$default$18();
                            Option<String> x$440 = x$40.copy$default$20();
                            return x$40.copy(x$422, x$423, x$424, x$425, x$426, x$427, x$428, x$429, x$430, x$431, x$432, x$433, x$434, x$435, x$436, x$437, x$438, x$439, x$421, x$440);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple228 = (Tuple2)tuple2._2();
                if (tuple228 != null) {
                    String string = (String)tuple228._1();
                    String string20 = (String)tuple228._2();
                    if ("rm.failover".equals(string) && "default".equals(string20)) {
                        return state;
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple229 = (Tuple2)tuple2._2();
                if (tuple229 != null) {
                    String string = (String)tuple229._1();
                    String string21 = (String)tuple229._2();
                    if ("rm.failover".equals(string) && "remote".equals(string21)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$41 -> {
                            FailoverStrategy x$441 = FailoverStrategy$.MODULE$.remote();
                            int x$442 = x$41.copy$default$1();
                            Option<String> x$443 = x$41.copy$default$2();
                            boolean x$444 = x$41.copy$default$3();
                            boolean x$445 = x$41.copy$default$4();
                            AuthenticationMode x$446 = x$41.copy$default$5();
                            boolean x$447 = x$41.copy$default$6();
                            boolean x$448 = x$41.copy$default$7();
                            int x$449 = x$41.copy$default$8();
                            Option<Object> x$450 = x$41.copy$default$9();
                            int x$451 = x$41.copy$default$10();
                            WriteConcern x$452 = x$41.copy$default$11();
                            ReadPreference x$453 = x$41.copy$default$12();
                            int x$454 = x$41.copy$default$14();
                            int x$455 = x$41.copy$default$15();
                            int x$456 = x$41.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$457 = x$41.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$458 = x$41.copy$default$18();
                            ReadConcern x$459 = x$41.copy$default$19();
                            Option<String> x$460 = x$41.copy$default$20();
                            return x$41.copy(x$442, x$443, x$444, x$445, x$446, x$447, x$448, x$449, x$450, x$451, x$452, x$453, x$441, x$454, x$455, x$456, x$457, x$458, x$459, x$460);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple230 = (Tuple2)tuple2._2();
                if (tuple230 != null) {
                    String string = (String)tuple230._1();
                    String string22 = (String)tuple230._2();
                    if ("rm.failover".equals(string) && "strict".equals(string22)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$42 -> {
                            FailoverStrategy x$461 = FailoverStrategy$.MODULE$.strict();
                            int x$462 = x$42.copy$default$1();
                            Option<String> x$463 = x$42.copy$default$2();
                            boolean x$464 = x$42.copy$default$3();
                            boolean x$465 = x$42.copy$default$4();
                            AuthenticationMode x$466 = x$42.copy$default$5();
                            boolean x$467 = x$42.copy$default$6();
                            boolean x$468 = x$42.copy$default$7();
                            int x$469 = x$42.copy$default$8();
                            Option<Object> x$470 = x$42.copy$default$9();
                            int x$471 = x$42.copy$default$10();
                            WriteConcern x$472 = x$42.copy$default$11();
                            ReadPreference x$473 = x$42.copy$default$12();
                            int x$474 = x$42.copy$default$14();
                            int x$475 = x$42.copy$default$15();
                            int x$476 = x$42.copy$default$16();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$477 = x$42.copy$default$17();
                            Option<MongoConnectionOptions.KeyStore> x$478 = x$42.copy$default$18();
                            ReadConcern x$479 = x$42.copy$default$19();
                            Option<String> x$480 = x$42.copy$default$20();
                            return x$42.copy(x$462, x$463, x$464, x$465, x$466, x$467, x$468, x$469, x$470, x$471, x$472, x$473, x$461, x$474, x$475, x$476, x$477, x$478, x$479, x$480);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple231 = (Tuple2)tuple2._2();
                if (tuple231 != null) {
                    Option option;
                    String string = (String)tuple231._1();
                    String opt = (String)tuple231._2();
                    if ("rm.failover".equals(string) && !(option = MODULE$.FailoverRe().unapplySeq((CharSequence)opt)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                        String d = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String r = (String)((LinearSeqOptimized)option.get()).apply(1);
                        String f = (String)((LinearSeqOptimized)option.get()).apply(2);
                        return this.make$1("rm.failover", opt, state, (Function0 & Serializable & scala.Serializable)() -> {
                            Tuple2 dur;
                            Option option = Duration$.MODULE$.unapply(Duration$.MODULE$.apply(d));
                            if (!(option instanceof Some)) {
                                throw new MongoConnection.URIParsingException(new StringBuilder(32).append("Invalid duration 'rm.failover': ").append(opt).toString());
                            }
                            Some some = (Some)option;
                            Tuple2 tuple2 = dur = (Tuple2)some.value();
                            Tuple2 tuple22 = tuple2;
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            long time = tuple22._1$mcJ$sp();
                            TimeUnit unit = (TimeUnit)((Object)((Object)((Object)tuple22._2())));
                            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)unit);
                            Tuple2 tuple24 = tuple23;
                            long time2 = tuple24._1$mcJ$sp();
                            TimeUnit unit2 = (TimeUnit)((Object)((Object)((Object)tuple24._2())));
                            FiniteDuration delay = FiniteDuration$.MODULE$.apply(time2, unit2);
                            int retry = new StringOps(Predef$.MODULE$.augmentString(r)).toInt();
                            double factor = new StringOps(Predef$.MODULE$.augmentString(f)).toDouble();
                            FailoverStrategy strategy = FailoverStrategy$.MODULE$.apply(delay, retry, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$44 -> (double)x$44 * factor);
                            return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$45 -> {
                                FailoverStrategy x$481 = strategy;
                                int x$482 = x$45.copy$default$1();
                                Option<String> x$483 = x$45.copy$default$2();
                                boolean x$484 = x$45.copy$default$3();
                                boolean x$485 = x$45.copy$default$4();
                                AuthenticationMode x$486 = x$45.copy$default$5();
                                boolean x$487 = x$45.copy$default$6();
                                boolean x$488 = x$45.copy$default$7();
                                int x$489 = x$45.copy$default$8();
                                Option<Object> x$490 = x$45.copy$default$9();
                                int x$491 = x$45.copy$default$10();
                                WriteConcern x$492 = x$45.copy$default$11();
                                ReadPreference x$493 = x$45.copy$default$12();
                                int x$494 = x$45.copy$default$14();
                                int x$495 = x$45.copy$default$15();
                                int x$496 = x$45.copy$default$16();
                                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$497 = x$45.copy$default$17();
                                Option<MongoConnectionOptions.KeyStore> x$498 = x$45.copy$default$18();
                                ReadConcern x$499 = x$45.copy$default$19();
                                Option<String> x$500 = x$45.copy$default$20();
                                return x$45.copy(x$482, x$483, x$484, x$485, x$486, x$487, x$488, x$489, x$490, x$491, x$492, x$493, x$481, x$494, x$495, x$496, x$497, x$498, x$499, x$500);
                            });
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple232 = (Tuple2)tuple2._2();
                if (tuple232 != null) {
                    String string = (String)tuple232._1();
                    String string23 = (String)tuple232._2();
                    if ("retryWrites".equals(string) && "true".equals(string23)) {
                        MODULE$.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection option 'rm.failover' should be preferred to 'retryWrites'");
                        return state;
                    }
                }
            }
            if (tuple2 != null) {
                String string;
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple233 = (Tuple2)tuple2._2();
                if (tuple233 != null && "retryWrites".equals(string = (String)tuple233._1())) {
                    MODULE$.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection option 'rm.failover' should be preferred to 'retryWrites'");
                    return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$46 -> {
                        FailoverStrategy x$501 = FailoverStrategy$.MODULE$.strict();
                        int x$502 = x$46.copy$default$1();
                        Option<String> x$503 = x$46.copy$default$2();
                        boolean x$504 = x$46.copy$default$3();
                        boolean x$505 = x$46.copy$default$4();
                        AuthenticationMode x$506 = x$46.copy$default$5();
                        boolean x$507 = x$46.copy$default$6();
                        boolean x$508 = x$46.copy$default$7();
                        int x$509 = x$46.copy$default$8();
                        Option<Object> x$510 = x$46.copy$default$9();
                        int x$511 = x$46.copy$default$10();
                        WriteConcern x$512 = x$46.copy$default$11();
                        ReadPreference x$513 = x$46.copy$default$12();
                        int x$514 = x$46.copy$default$14();
                        int x$515 = x$46.copy$default$15();
                        int x$516 = x$46.copy$default$16();
                        scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$517 = x$46.copy$default$17();
                        Option<MongoConnectionOptions.KeyStore> x$518 = x$46.copy$default$18();
                        ReadConcern x$519 = x$46.copy$default$19();
                        Option<String> x$520 = x$46.copy$default$20();
                        return x$46.copy(x$502, x$503, x$504, x$505, x$506, x$507, x$508, x$509, x$510, x$511, x$512, x$513, x$501, x$514, x$515, x$516, x$517, x$518, x$519, x$520);
                    });
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple234 = (Tuple2)tuple2._2();
                if (tuple234 != null) {
                    Option option;
                    String string = (String)tuple234._1();
                    String string24 = (String)tuple234._2();
                    if ("heartbeatFrequencyMS".equals(string) && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string24)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String ms = (String)((LinearSeqOptimized)option.get()).apply(0);
                        return this.make$1("heartbeatFrequencyMS", ms, state, (Function0 & Serializable & scala.Serializable)() -> {
                            int millis = new StringOps(Predef$.MODULE$.augmentString(ms)).toInt();
                            if (millis < 500) {
                                throw new MongoConnection.URIParsingException("'heartbeatFrequencyMS' must be >= 500 milliseconds");
                            }
                            return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$47 -> {
                                int x$521 = millis;
                                int x$522 = x$47.copy$default$1();
                                Option<String> x$523 = x$47.copy$default$2();
                                boolean x$524 = x$47.copy$default$3();
                                boolean x$525 = x$47.copy$default$4();
                                AuthenticationMode x$526 = x$47.copy$default$5();
                                boolean x$527 = x$47.copy$default$6();
                                boolean x$528 = x$47.copy$default$7();
                                int x$529 = x$47.copy$default$8();
                                Option<Object> x$530 = x$47.copy$default$9();
                                int x$531 = x$47.copy$default$10();
                                WriteConcern x$532 = x$47.copy$default$11();
                                ReadPreference x$533 = x$47.copy$default$12();
                                FailoverStrategy x$534 = x$47.copy$default$13();
                                int x$535 = x$47.copy$default$15();
                                int x$536 = x$47.copy$default$16();
                                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$537 = x$47.copy$default$17();
                                Option<MongoConnectionOptions.KeyStore> x$538 = x$47.copy$default$18();
                                ReadConcern x$539 = x$47.copy$default$19();
                                Option<String> x$540 = x$47.copy$default$20();
                                return x$47.copy(x$522, x$523, x$524, x$525, x$526, x$527, x$528, x$529, x$530, x$531, x$532, x$533, x$534, x$521, x$535, x$536, x$537, x$538, x$539, x$540);
                            });
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple235 = (Tuple2)tuple2._2();
                if (tuple235 != null) {
                    String string = (String)tuple235._1();
                    String nme = (String)tuple235._2();
                    if ("appName".equals(string)) {
                        MongoConnection.ParseState parseState;
                        Option option = Option$.MODULE$.apply((Object)nme).map((Function1 & Serializable & scala.Serializable)x$48 -> x$48.trim()).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$makeOptions$43(v)));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String appName = (String)some.value();
                            parseState = state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$49 -> {
                                Some x$541 = new Some((Object)appName);
                                int x$542 = x$49.copy$default$1();
                                Option<String> x$543 = x$49.copy$default$2();
                                boolean x$544 = x$49.copy$default$3();
                                boolean x$545 = x$49.copy$default$4();
                                AuthenticationMode x$546 = x$49.copy$default$5();
                                boolean x$547 = x$49.copy$default$6();
                                boolean x$548 = x$49.copy$default$7();
                                int x$549 = x$49.copy$default$8();
                                Option<Object> x$550 = x$49.copy$default$9();
                                int x$551 = x$49.copy$default$10();
                                WriteConcern x$552 = x$49.copy$default$11();
                                ReadPreference x$553 = x$49.copy$default$12();
                                FailoverStrategy x$554 = x$49.copy$default$13();
                                int x$555 = x$49.copy$default$14();
                                int x$556 = x$49.copy$default$15();
                                int x$557 = x$49.copy$default$16();
                                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$558 = x$49.copy$default$17();
                                Option<MongoConnectionOptions.KeyStore> x$559 = x$49.copy$default$18();
                                ReadConcern x$560 = x$49.copy$default$19();
                                return x$49.copy(x$542, x$543, x$544, x$545, x$546, x$547, x$548, x$549, x$550, x$551, x$552, x$553, x$554, x$555, x$556, x$557, x$558, x$559, x$560, (Option<String>)x$541);
                            });
                            return parseState;
                        } else {
                            parseState = state.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"appName"), (Object)nme));
                        }
                        return parseState;
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
            Tuple2 kv = (Tuple2)tuple2._2();
            return state.reject((Tuple2<String, String>)kv);
        });
        MongoConnection.ParseState parsed2 = (MongoConnection.ParseState)parsed1.rejected().get((Object)"zlibCompressionLevel").fold((Function0 & Serializable & scala.Serializable)() -> parsed1, (Function1 & Serializable & scala.Serializable)x0$2 -> {
            MongoConnection.ParseState parseState;
            String string = x0$2;
            Option option = MODULE$.IntRe().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                MongoConnection.ParseState parseState2;
                String level = (String)((LinearSeqOptimized)option.get()).apply(0);
                BooleanRef valid = BooleanRef.create((boolean)false);
                ListSet compressors = (ListSet)parsed1.options().compressors().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Compressor compressor;
                    Compressor compressor2 = x0$3;
                    Option option = Compressor.Zlib$.MODULE$.unapply(compressor2);
                    if (!option.isEmpty()) {
                        valid$2.elem = true;
                        compressor = Compressor.Zlib$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(level)).toInt());
                    } else {
                        compressor = compressor2;
                    }
                    return compressor;
                }, ListSet$.MODULE$.canBuildFrom());
                if (!valid.elem) {
                    MODULE$.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection option 'zlibCompressionLevel' must only be specified after 'compressors' with 'zlib'");
                    parseState2 = parsed1.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zlibCompressionLevel"), (Object)level));
                } else {
                    parseState2 = parsed1.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$50 -> x$50.withCompressors((ListSet<Compressor>)compressors));
                }
                parseState = parseState2;
            } else {
                parseState = parsed1;
            }
            return parseState;
        });
        MongoConnection.ParseState parsed3 = (MongoConnection.ParseState)parsed2.rejected().get((Object)"keyStore").fold((Function0 & Serializable & scala.Serializable)() -> parsed2, (Function1 & Serializable & scala.Serializable)uri -> {
            MongoConnectionOptions.KeyStore keyStore = MongoConnectionOptions$KeyStore$.MODULE$.apply(new URI((String)uri), (Option<char[]>)parsed2.rejected().get((Object)"keyStorePassword").map((Function1 & Serializable & scala.Serializable)x$51 -> x$51.toCharArray()), (String)parsed2.rejected().getOrElse((Object)"keyStoreType", (Function0 & Serializable & scala.Serializable)() -> "PKCS12"), true);
            MongoConnection.ParseState qual$1 = parsed2.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)x$52 -> {
                Some x$561 = new Some((Object)keyStore);
                int x$562 = x$52.copy$default$1();
                Option<String> x$563 = x$52.copy$default$2();
                boolean x$564 = x$52.copy$default$3();
                boolean x$565 = x$52.copy$default$4();
                AuthenticationMode x$566 = x$52.copy$default$5();
                boolean x$567 = x$52.copy$default$6();
                boolean x$568 = x$52.copy$default$7();
                int x$569 = x$52.copy$default$8();
                Option<Object> x$570 = x$52.copy$default$9();
                int x$571 = x$52.copy$default$10();
                WriteConcern x$572 = x$52.copy$default$11();
                ReadPreference x$573 = x$52.copy$default$12();
                FailoverStrategy x$574 = x$52.copy$default$13();
                int x$575 = x$52.copy$default$14();
                int x$576 = x$52.copy$default$15();
                int x$577 = x$52.copy$default$16();
                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$578 = x$52.copy$default$17();
                ReadConcern x$579 = x$52.copy$default$19();
                Option<String> x$580 = x$52.copy$default$20();
                return x$52.copy(x$562, x$563, x$564, x$565, x$566, x$567, x$568, x$569, x$570, x$571, x$572, x$573, x$574, x$575, x$576, x$577, x$578, (Option<MongoConnectionOptions.KeyStore>)x$561, x$579, x$580);
            });
            scala.collection.immutable.Map x$581 = (scala.collection.immutable.Map)parsed2.rejected().$minus((Object)"keyStore").$minus((Object)"keyStorePassword").$minus((Object)"keyStoreType");
            MongoConnectionOptions x$582 = qual$1.copy$default$1();
            return qual$1.copy(x$582, (scala.collection.immutable.Map<String, String>)x$581);
        });
        MongoConnection.ParseState parsed4 = (MongoConnection.ParseState)parsed3.rejected().iterator().foldLeft((Object)parsed3, (Function2 & Serializable & scala.Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$2);
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String o = (String)tuple22._1();
                    String string = (String)tuple22._2();
                    boolean bl = "writeConcernW".equals(o) ? true : "w".equals(o);
                    if (bl && "majority".equals(string)) {
                        this.deprecated$1(o, "w");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable & scala.Serializable)x$53 -> x$53.copy(WriteConcern$Majority$.MODULE$, x$53.copy$default$2(), x$53.copy$default$3(), x$53.copy$default$4()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple23 != null) {
                    Option option;
                    String o = (String)tuple23._1();
                    String string = (String)tuple23._2();
                    boolean bl = "writeConcernW".equals(o) ? true : "w".equals(o);
                    if (bl && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String str = (String)((LinearSeqOptimized)option.get()).apply(0);
                        this.deprecated$1(o, "w");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable & scala.Serializable)x$54 -> x$54.copy(WriteConcern$WaitForAcknowledgments$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(str)).toInt()), x$54.copy$default$2(), x$54.copy$default$3(), x$54.copy$default$4()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 != null) {
                    String o = (String)tuple24._1();
                    String tag = (String)tuple24._2();
                    boolean bl = "writeConcernW".equals(o) ? true : "w".equals(o);
                    if (bl) {
                        this.deprecated$1(o, "w");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable & scala.Serializable)x$55 -> x$55.copy(WriteConcern$TagSet$.MODULE$.apply(tag), x$55.copy$default$2(), x$55.copy$default$3(), x$55.copy$default$4()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple25 != null) {
                    String o = (String)tuple25._1();
                    String journaled = (String)tuple25._2();
                    boolean bl = "journal".equals(o) ? true : "writeConcernJ".equals(o);
                    if (bl) {
                        this.deprecated$1(o, "journal");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable & scala.Serializable)x$56 -> {
                            boolean x$583 = new StringOps(Predef$.MODULE$.augmentString(journaled)).toBoolean();
                            WriteConcern.W x$584 = x$56.copy$default$1();
                            boolean x$585 = x$56.copy$default$3();
                            Option<Object> x$586 = x$56.copy$default$4();
                            return x$56.copy(x$584, x$583, x$585, x$586);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple26 = (Tuple2)tuple2._2();
                if (tuple26 != null) {
                    Option option;
                    String o = (String)tuple26._1();
                    String string = (String)tuple26._2();
                    boolean bl = "wtimeoutMS".equals(o) ? true : "writeConcernTimeout".equals(o);
                    if (bl && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String ms = (String)((LinearSeqOptimized)option.get()).apply(0);
                        this.deprecated$1(o, "journal");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable & scala.Serializable)x$57 -> {
                            Some x$587 = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(ms)).toInt()));
                            WriteConcern.W x$588 = x$57.copy$default$1();
                            boolean x$589 = x$57.copy$default$2();
                            boolean x$590 = x$57.copy$default$3();
                            return x$57.copy(x$588, x$589, x$590, (Option<Object>)x$587);
                        });
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
            Tuple2 kv = (Tuple2)tuple2._2();
            return state.reject((Tuple2<String, String>)kv);
        });
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((MapLike)parsed4.rejected().$minus((Object)"writeConcernW").$minus((Object)"w").$minus((Object)"journal").$minus((Object)"writeConcernJ").$minus((Object)"wtimeoutMS").$minus((Object)"writeConcernTimeout")).keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)), (Object)parsed4.options());
    }

    public static final /* synthetic */ boolean $anonfun$parse$3(char x$5) {
        return x$5 != '?';
    }

    public static final /* synthetic */ boolean $anonfun$parse$5(char x$6) {
        return x$6 != '/';
    }

    private static final Future txtOptions$1(boolean seedList$1, String setSpec$1, int credentialEnd$1, Function1 txtResolver$1, ExecutionContext ec$1) {
        Future future;
        if (!seedList$1) {
            future = Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        } else {
            String serviceName = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(setSpec$1)).drop(credentialEnd$1 + 1))).takeWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$5(BoxesRunTime.unboxToChar((Object)x$6))));
            future = ((Future)Await$.MODULE$.ready((Awaitable)txtResolver$1.apply((Object)serviceName), (Duration)package$.MODULE$.dnsTimeout())).flatMap((Function1 & Serializable & scala.Serializable)records -> ((Future)records.foldLeft((Object)Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty()), (Function2 & Serializable & scala.Serializable)(o, r) -> o.flatMap((Function1 & Serializable & scala.Serializable)prev -> MODULE$.parseOptions((String)r).map((Function1 & Serializable & scala.Serializable)cur -> prev.$plus$plus((GenTraversableOnce)cur), ec$1), ec$1))).map((Function1 & Serializable & scala.Serializable)res -> res, ec$1), ec$1);
        }
        return future;
    }

    private static final String optionStr$1(String useful$1, String setSpec$1) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(useful$1)).drop(new StringOps(Predef$.MODULE$.augmentString(setSpec$1)).size()))).stripPrefix("?");
    }

    public static final /* synthetic */ boolean $anonfun$parse$15(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$parseHosts$2(char x$11) {
        return x$11 != ':';
    }

    private final Future parse$1(Iterable input, Builder buf$1) {
        Future future;
        block15: {
            Option option;
            while ((option = input.headOption()) instanceof Some) {
                Future future2;
                String string;
                Some some = (Some)option;
                String h = (String)some.value();
                Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(h)).span((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHosts$2(BoxesRunTime.unboxToChar((Object)x$11))));
                if (tuple2 != null && "".equals(string = (String)tuple2._1())) {
                    future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(28).append("No valid host in the URI: '").append(h).append("'").toString()));
                } else {
                    if (tuple2 != null) {
                        String host = (String)tuple2._1();
                        String string2 = (String)tuple2._2();
                        if ("".equals(string2)) {
                            buf$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)this.DefaultPort())));
                            input = (Iterable)input.drop(1);
                            continue;
                        }
                    }
                    if (tuple2 != null) {
                        Left res;
                        Object object;
                        String host = (String)tuple2._1();
                        String port = (String)tuple2._2();
                        try {
                            int p = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(port)).drop(1))).toInt();
                            object = p <= 0 || p >= 65536 ? scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString())) : scala.package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)p)));
                        }
                        catch (Throwable throwable) {
                            Left left;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof NumberFormatException) {
                                left = scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString()));
                            } else {
                                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option2.isEmpty()) {
                                    Throwable cause = (Throwable)option2.get();
                                    left = scala.package$.MODULE$.Left().apply((Object)cause);
                                } else {
                                    throw throwable;
                                }
                            }
                            object = left;
                        }
                        Left left = res = object;
                        if (!(left instanceof Left)) {
                            if (left instanceof Right) {
                                Right right = (Right)left;
                                Tuple2 node = (Tuple2)right.value();
                                buf$1.$plus$eq((Object)node);
                                input = (Iterable)input.drop(1);
                                continue;
                            }
                            throw new MatchError((Object)left);
                        }
                        Left left2 = left;
                        Throwable cause = (Throwable)left2.value();
                        Future future3 = Future$.MODULE$.failed(cause);
                        future2 = future3;
                    } else {
                        future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(52).append("Could not parse host from URI: invalid definition '").append(h).append("'").toString()));
                    }
                }
                future = future2;
                break block15;
            }
            future = Future$.MODULE$.successful(buf$1.result());
        }
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$parseHostsAndDB$1(char x$12) {
        return x$12 != '/';
    }

    public static final /* synthetic */ boolean $anonfun$parseOptions$1(char x$15) {
        return x$15 != '=';
    }

    private final Future parse$2(Iterable input, String options$2, Map buf$2) {
        Future future;
        block3: {
            Option option;
            while ((option = input.headOption()) instanceof Some) {
                String string;
                Some some = (Some)option;
                String option2 = (String)some.value();
                Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(option2)).span((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseOptions$1(BoxesRunTime.unboxToChar((Object)x$15))));
                if (tuple2 == null || !"".equals(string = (String)tuple2._2())) {
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        buf$2.put((Object)key, new StringOps(Predef$.MODULE$.augmentString(v)).drop(1));
                        input = (Iterable)input.drop(1);
                        continue;
                    }
                    throw new MatchError((Object)tuple2);
                }
                Future future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(34).append("Could not parse invalid options '").append(options$2).append("'").toString()));
                future = future2;
                break block3;
            }
            future = Future$.MODULE$.successful((Object)buf$2.toMap(Predef$.MODULE$.$conforms()));
        }
        return future;
    }

    private final MongoConnection.ParseState make$1(String name, String input, MongoConnection.ParseState state, Function0 f) {
        MongoConnection.ParseState parseState;
        try {
            parseState = (MongoConnection.ParseState)f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable cause = (Throwable)option.get();
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid option '").append(name).append("': ").append(input).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> cause);
            MongoConnection.ParseState parseState2 = state.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)input));
            parseState = parseState2;
        }
        return parseState;
    }

    private final void deprecated$1(String expected, String actual) {
        block0: {
            String string = actual;
            String string2 = expected;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Connection option '").append(actual).append("' is deprecated in favor of '").append(expected).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeOptions$43(String v) {
        return new StringOps(Predef$.MODULE$.augmentString(v)).nonEmpty() && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(v.getBytes("UTF-8"))).size() < 128;
    }

    private static final MongoConnection.ParseState updateWriteConcern$1(MongoConnection.ParseState st, Function1 f) {
        return st.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable & scala.Serializable)opts -> {
            WriteConcern x$1 = (WriteConcern)f.apply((Object)opts.writeConcern());
            int x$2 = opts.copy$default$1();
            Option<String> x$3 = opts.copy$default$2();
            boolean x$4 = opts.copy$default$3();
            boolean x$5 = opts.copy$default$4();
            AuthenticationMode x$6 = opts.copy$default$5();
            boolean x$7 = opts.copy$default$6();
            boolean x$8 = opts.copy$default$7();
            int x$9 = opts.copy$default$8();
            Option<Object> x$10 = opts.copy$default$9();
            int x$11 = opts.copy$default$10();
            ReadPreference x$12 = opts.copy$default$12();
            FailoverStrategy x$13 = opts.copy$default$13();
            int x$14 = opts.copy$default$14();
            int x$15 = opts.copy$default$15();
            int x$16 = opts.copy$default$16();
            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$17 = opts.copy$default$17();
            Option<MongoConnectionOptions.KeyStore> x$18 = opts.copy$default$18();
            ReadConcern x$19 = opts.copy$default$19();
            Option<String> x$20 = opts.copy$default$20();
            return opts.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$1, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        });
    }

    private MongoConnection$() {
        MODULE$ = this;
        this.DefaultHost = "localhost";
        this.DefaultPort = 27017;
        this.logger = LazyLogger$.MODULE$.apply("reactivemongo.api.MongoConnection");
        this.UnsignedInt = new StringOps(Predef$.MODULE$.augmentString("^([0-9]+)$")).r();
        this.IntRe = new StringOps(Predef$.MODULE$.augmentString("^([-]?[0-9]+)$")).r();
        this.FailoverRe = new StringOps(Predef$.MODULE$.augmentString("^([^:]+):([0-9]+)x([0-9.]+)$")).r();
    }
}

