/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import reactivemongo.core.actors.ChannelConnected;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.protocol.MongoHandler$;
import reactivemongo.core.protocol.Response;
import reactivemongo.io.netty.channel.Channel;
import reactivemongo.io.netty.channel.ChannelDuplexHandler;
import reactivemongo.io.netty.channel.ChannelHandlerContext;
import reactivemongo.io.netty.channel.ChannelPromise;
import reactivemongo.io.netty.handler.timeout.IdleStateEvent;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\re!B\f\u0019\u0001qq\u0002\u0002D\u0015\u0001\t\u0003\u0005)Q!A!\u0002\u0013Y\u0003\u0002\u0004\u001d\u0001\t\u0003\u0005)Q!A!\u0002\u0013Y\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\t\u0003A\u0011A\"\t\u000f-\u0003\u0001\u0019!C\u0005\u0019\"9\u0011\u000b\u0001a\u0001\n\u0013\u0011\u0006B\u0002-\u0001A\u0003&Q\nC\u0003Z\u0001\u0011\u0005#\fC\u0003a\u0001\u0011\u0005\u0013\rC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0003~\u0001\u0011\u0005c\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u0003\u0002A\u0011AA&\u000f!\t)\u0006\u0007E\u00019\u0005]caB\f\u0019\u0011\u0003a\u0012\u0011\f\u0005\u0007\u0005N!\t!!\u0019\t\u0013\u0005\r4C1A\u0005\u0002\u0005\u0015\u0004\u0002CAA'\u0001\u0006I!a\u001a\u0003\u00195{gnZ8IC:$G.\u001a:\u000b\u0005eQ\u0012\u0001\u00039s_R|7m\u001c7\u000b\u0005ma\u0012\u0001B2pe\u0016T\u0011!H\u0001\u000ee\u0016\f7\r^5wK6|gnZ8\u0014\u0005\u0001y\u0002C\u0001\u0011(\u001b\u0005\t#B\u0001\u0012$\u0003\u001d\u0019\u0007.\u00198oK2T!\u0001J\u0013\u0002\u000b9,G\u000f^=\u000b\u0005\u0019b\u0012AA5p\u0013\tA\u0013E\u0001\u000bDQ\u0006tg.\u001a7EkBdW\r\u001f%b]\u0012dWM]\u00015e\u0016\f7\r^5wK6|gnZ8%G>\u0014X\r\n9s_R|7m\u001c7%\u001b>twm\u001c%b]\u0012dWM\u001d\u0013%gV\u0004XM\u001d<jg>\u00148\u0001\u0001\t\u0003YUr!!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0005AR\u0013A\u0002\u001fs_>$hHC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b2\u0003Q\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%aJ|Go\\2pY\u0012juN\\4p\u0011\u0006tG\r\\3sI\u0011\u001awN\u001c8fGRLwN\\\u0001\te\u0016\u001cW-\u001b<feB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0006C\u000e$xN\u001d\u0006\u0002\u007f\u0005!\u0011m[6b\u0013\t\tEH\u0001\u0005BGR|'OU3g\u0003\u0019a\u0014N\\5u}Q!AI\u0012%K!\t)\u0005!D\u0001\u0019\u0011\u00159E\u00011\u0001,\u0003)\u0019X\u000f]3sm&\u001cxN\u001d\u0005\u0006\u0013\u0012\u0001\raK\u0001\u000bG>tg.Z2uS>t\u0007\"B\u001d\u0005\u0001\u0004Q\u0014\u0001\u00027bgR,\u0012!\u0014\t\u0003\u001d>k\u0011!M\u0005\u0003!F\u0012A\u0001T8oO\u0006AA.Y:u?\u0012*\u0017\u000f\u0006\u0002T-B\u0011a\nV\u0005\u0003+F\u0012A!\u00168ji\"9qKBA\u0001\u0002\u0004i\u0015a\u0001=%c\u0005)A.Y:uA\u0005i1\r[1o]\u0016d\u0017i\u0019;jm\u0016$\"aU.\t\u000bqC\u0001\u0019A/\u0002\u0007\r$\b\u0010\u0005\u0002!=&\u0011q,\t\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0003I)8/\u001a:Fm\u0016tG\u000f\u0016:jO\u001e,'/\u001a3\u0015\u0007M\u00137\rC\u0003]\u0013\u0001\u0007Q\fC\u0003e\u0013\u0001\u0007Q-A\u0002fmR\u0004\"A\u00144\n\u0005\u001d\f$aA!os\u0006y1\r[1o]\u0016d\u0017J\\1di&4X\r\u0006\u0002TU\")AL\u0003a\u0001;\"\"!\u0002\u001c;v!\ti'/D\u0001o\u0015\ty\u0007/\u0001\u0003mC:<'\"A9\u0002\t)\fg/Y\u0005\u0003g:\u0014\u0001cU;qaJ,7o],be:LgnZ:\u0002\u000bY\fG.^3-\u0003Y\f\u0013a^\u0001\u000e\u001dVdG\u000eU1sC6,G/\u001a:\u0002\u0017\rD\u0017M\u001c8fYJ+\u0017\r\u001a\u000b\u0004'j\\\b\"\u0002/\f\u0001\u0004i\u0006\"\u0002?\f\u0001\u0004)\u0017aA7tO\u0006)qO]5uKR11k`A\u0001\u0003\u0007AQ\u0001\u0018\u0007A\u0002uCQ\u0001 \u0007A\u0002\u0015Dq!!\u0002\r\u0001\u0004\t9!A\u0004qe>l\u0017n]3\u0011\u0007\u0001\nI!C\u0002\u0002\f\u0005\u0012ab\u00115b]:,G\u000e\u0015:p[&\u001cX-A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\u0015\u0019\u0016\u0011CA\n\u0011\u0015aV\u00021\u0001^\u0011\u001d\t)\"\u0004a\u0001\u0003/\tQaY1vg\u0016\u0004B!!\u0007\u0002$9!\u00111DA\u0010\u001d\rq\u0013QD\u0005\u0002e%\u0019\u0011\u0011E\u0019\u0002\u000fA\f7m[1hK&!\u0011QEA\u0014\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\"E\nA\u0002[1oI2,'/\u00113eK\u0012$2aUA\u0017\u0011\u0015af\u00021\u0001^\u0003\u00119\u0018M\u001d8\u0015\u000bM\u000b\u0019$!\u000e\t\u000bq{\u0001\u0019A/\t\r\u0005]r\u00021\u0001,\u0003\u0005\u0019\bfA\b\u0002<A\u0019a*!\u0010\n\u0007\u0005}\u0012G\u0001\u0004j]2Lg.Z\u0001\u0004Y><G#B*\u0002F\u0005\u001d\u0003\"\u0002/\u0011\u0001\u0004i\u0006BBA\u001c!\u0001\u00071\u0006K\u0002\u0011\u0003w!raUA'\u0003\u001f\n\t\u0006C\u0003]#\u0001\u0007Q\f\u0003\u0004\u00028E\u0001\ra\u000b\u0005\b\u0003+\t\u0002\u0019AA\fQ\r\t\u00121H\u0001\r\u001b>twm\u001c%b]\u0012dWM\u001d\t\u0003\u000bN\u00192aEA.!\rq\u0015QL\u0005\u0004\u0003?\n$AB!osJ+g\r\u0006\u0002\u0002X\u00051An\\4hKJ,\"!a\u001a\u0011\t\u0005%\u00141\u0010\b\u0005\u0003W\n)H\u0004\u0003\u0002n\u0005Edb\u0001\u0018\u0002p%\tQ$C\u0002\u0002tq\tA!\u001e;jY&!\u0011qOA=\u0003)a\u0015M_=M_\u001e<WM\u001d\u0006\u0004\u0003gb\u0012\u0002BA?\u0003\u007f\u0012!\u0002T1{s2{wmZ3s\u0015\u0011\t9(!\u001f\u0002\u000f1|wmZ3sA\u0001")
public class MongoHandler
extends ChannelDuplexHandler {
    public final String reactivemongo$core$protocol$MongoHandler$$supervisor;
    public final String reactivemongo$core$protocol$MongoHandler$$connection;
    private final ActorRef receiver;
    private long last;

    public static LazyLogger.LazyLogger logger() {
        return MongoHandler$.MODULE$.logger();
    }

    private long last() {
        return this.last;
    }

    private void last_$eq(long x$1) {
        this.last = x$1;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log(ctx, "Channel is active");
        this.last_$eq(System.nanoTime());
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
        ChannelConnected x$1 = new ChannelConnected(ctx.channel().id());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        super.channelActive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        BoxedUnit boxedUnit;
        Object object = evt;
        if (object instanceof IdleStateEvent) {
            if (this.last() != -1L) {
                long now = System.nanoTime();
                this.log(ctx, new StringBuilder(40).append("Channel has been inactive for ").append(now - this.last()).append(" (last = ").append(this.last()).append(")").toString());
            }
            boxedUnit = ctx.channel().close();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        long now = System.nanoTime();
        if (this.last() != -1L) {
            Channel chan = ctx.channel();
            long delay = now - this.last();
            if (delay < 500000000L) {
                this.warn(ctx, new StringBuilder(62).append(MongoHandler.msg$1(delay, chan)).append("; Please check network connectivity and the status of the set.").toString());
            } else if (chan.remoteAddress() != null) {
                this.log(ctx, MongoHandler.msg$1(delay, chan));
            }
            this.last_$eq(now);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            ChannelDisconnected x$1 = new ChannelDisconnected(chan.id());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.last_$eq(System.nanoTime());
        Object object = msg;
        if (object instanceof Response) {
            Response response = (Response)object;
            this.log(ctx, new StringBuilder(43).append("Channel received message ").append(response).append("; Will be send to ").append(this.receiver.path()).toString());
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            Response x$1 = response;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log(ctx, new StringBuilder(20).append("Unexpected message: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.log(ctx, "Channel is requested to write");
        this.last_$eq(System.nanoTime());
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log(ctx, new StringBuilder(18).append("Error on channel #").append(ctx.channel().id()).toString(), cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.channelActive(ctx);
        }
        super.handlerAdded(ctx);
    }

    public void warn(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().warn((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString());
    }

    public void log(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString());
    }

    public void log(ChannelHandlerContext ctx, String s, Throwable cause) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString(), (Function0<Throwable>)(Function0 & java.io.Serializable & Serializable)() -> cause);
    }

    private static final String msg$1(long delay$1, Channel chan$1) {
        return new StringBuilder(28).append("Channel is closed under ").append(delay$1).append("ns: ").append(chan$1.remoteAddress()).toString();
    }

    public MongoHandler(String supervisor, String connection, ActorRef receiver) {
        this.reactivemongo$core$protocol$MongoHandler$$supervisor = supervisor;
        this.reactivemongo$core$protocol$MongoHandler$$connection = connection;
        this.receiver = receiver;
        this.last = -1L;
    }
}

