/**
 * Copyright 2014 Nikita Koksharov, Nickolay Borbit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.redisson;

import java.util.concurrent.TimeUnit;

import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.core.RBucket;

import io.netty.util.concurrent.Future;

public class RedissonBucket<V> extends RedissonExpirable implements RBucket<V> {

    protected RedissonBucket(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    protected RedissonBucket(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public V get() {
        return get(getAsync());
    }

    @Override
    public Future<V> getAsync() {
        return commandExecutor.readAsync(getName(), codec, RedisCommands.GET, getName());
    }

    @Override
    public void set(V value) {
        get(setAsync(value));
    }

    @Override
    public Future<Void> setAsync(V value) {
        return commandExecutor.writeAsync(getName(), codec, RedisCommands.SET, getName(), value);
    }

    @Override
    public void set(V value, long timeToLive, TimeUnit timeUnit) {
        get(setAsync(value, timeToLive, timeUnit));
    }

    @Override
    public Future<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return commandExecutor.writeAsync(getName(), codec, RedisCommands.SETEX, getName(), timeUnit.toSeconds(timeToLive), value);
    }

    /**
     * Use {@link #isExistsAsync()}
     *
     * @return
     */
    @Deprecated
    public Future<Boolean> existsAsync() {
        return isExistsAsync();
    }

    /**
     * Use {@link #isExists()}
     *
     * @return
     */
    @Deprecated
    public boolean exists() {
        return isExists();
    }

}
