/**
 * Copyright (c) 2013-2024 Nikita Koksharov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import org.redisson.BaseRedissonList;
import org.redisson.api.RBlockingQueueAsync;

/**
 * 
 * @author Nikita Koksharov
 *
 * @param <V> - value type
 */
public class RedissonBlockingQueueRx<V> extends RedissonListRx<V> {

    private final RBlockingQueueAsync<V> queue;
    
    public RedissonBlockingQueueRx(RBlockingQueueAsync<V> queue) {
        super((BaseRedissonList<V>) queue);
        this.queue = queue;
    }

    public Flowable<V> takeElements() {
        return ElementsStream.takeElements(queue::takeAsync);
    }
    
}
