/**
 * Copyright (c) 2013-2024 Nikita Koksharov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.redisson.client.protocol.decoder;

import org.redisson.client.handler.State;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 
 * @author Nikita Koksharov
 *
 */

public class TimeLongObjectDecoder implements MultiDecoder<Long> {

    private final TimeUnit timeUnit;

    public TimeLongObjectDecoder() {
        this(null);
    }

    public TimeLongObjectDecoder(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public Long decode(List<Object> parts, State state) {
        long time = ((Long) parts.get(0)) * 1000L + ((Long) parts.get(1)) / 1000L;
        if (timeUnit != null) {
            return timeUnit.convert(time, TimeUnit.MILLISECONDS);
        }
        return time;
    }
    
}
