/**
 * Copyright 2018 Nikita Koksharov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.redisson.api;

/**
 * 
 * @author Nikita Koksharov
 *
 */
public interface RAtomicLongAsync extends RExpirableAsync {

    RFuture<Boolean> compareAndSetAsync(long expect, long update);

    RFuture<Long> addAndGetAsync(long delta);

    RFuture<Long> decrementAndGetAsync();

    RFuture<Long> getAsync();
    
    /**
     * Gets and deletes object
     * 
     * @return the current value
     */
    RFuture<Long> getAndDeleteAsync();

    RFuture<Long> getAndAddAsync(long delta);

    RFuture<Long> getAndSetAsync(long newValue);

    RFuture<Long> incrementAndGetAsync();

    RFuture<Long> getAndIncrementAsync();

    RFuture<Long> getAndDecrementAsync();

    RFuture<Void> setAsync(long newValue);

}
