/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.runtime;

import io.quarkus.arc.DefaultBean;
import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

@ApplicationScoped
public class RedissonClientProducer {
    private String config;
    private RedissonClient redisson;

    @Produces
    @Singleton
    @DefaultBean
    public RedissonClient create() throws IOException {
        if (this.config != null) {
            Config c = Config.fromYAML((String)this.config);
            this.redisson = Redisson.create((Config)c);
        } else {
            this.redisson = Redisson.create();
        }
        return this.redisson;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    @PreDestroy
    public void close() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }
}

