/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.l10n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.richfaces.l10n.MessageBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleLoader {
    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private MessageBundle asMessageBundle(Enum<?> messageKey) throws IllegalArgumentException {
        MessageBundle bundleAnnotation = messageKey.getClass().getAnnotation(MessageBundle.class);
        if (bundleAnnotation == null) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot detect baseName for enumeration {0} in class {1}", messageKey.toString(), messageKey.getClass().getName()));
        }
        return bundleAnnotation;
    }

    public ResourceBundle getBundle(Enum<?> messageKey, Locale locale) throws MissingResourceException, IllegalArgumentException {
        MessageBundle bundleAnnotation = this.asMessageBundle(messageKey);
        return ResourceBundle.getBundle(bundleAnnotation.baseName(), locale, this.getClassLoader());
    }

    public ResourceBundle getApplicationBundle(FacesContext facesContext, Enum<?> messageKey, Locale locale) throws MissingResourceException {
        if (facesContext == null) {
            throw new MissingResourceException("FacesContext is null", this.getClass().getName(), messageKey.toString());
        }
        Application application = facesContext.getApplication();
        if (application == null || application.getMessageBundle() == null) {
            throw new MissingResourceException("Cannot read message bundle name from application", this.getClass().getName(), messageKey.toString());
        }
        return ResourceBundle.getBundle(application.getMessageBundle(), locale, this.getClassLoader());
    }
}

