/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

public final class FastJoiner {
    private String separator;

    private FastJoiner(String separator) {
        this.separator = separator;
    }

    private String maskNullString(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    public String join(String s1, String s2) {
        if (s1 == null) {
            return this.maskNullString(s2);
        }
        if (s2 == null) {
            return this.maskNullString(s1);
        }
        StringBuilder sb = new StringBuilder(s1.length() + this.separator.length() + s2.length());
        sb.append(s1);
        sb.append(this.separator);
        sb.append(s2);
        return sb.toString();
    }

    public String join(String ... strings) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (s == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(this.separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static FastJoiner on(String sep) {
        return new FastJoiner(sep);
    }

    public static FastJoiner on(char c) {
        return new FastJoiner(String.valueOf(c));
    }
}

