/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.io.IOException;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.SessionManager;
import org.richfaces.application.push.impl.SessionManagerImpl;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public abstract class AbstractSession
implements Session,
SessionManagerImpl.DestroyableSession {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final int MAX_INACTIVE_INTERVAL = 300000;
    private final String id;
    private final SessionManager sessionManager;
    private volatile long lastAccessedTime;
    private volatile Request request;
    private volatile boolean active = true;

    public AbstractSession(String id, SessionManager sessionManager) {
        this.id = id;
        this.sessionManager = sessionManager;
        this.resetLastAccessedTimeToCurrent();
    }

    private void resetLastAccessedTimeToCurrent() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public synchronized void connect(Request request) throws Exception {
        this.releaseRequest();
        if (this.active) {
            this.processConnect(request);
        } else {
            request.resume();
        }
    }

    protected Request getRequest() {
        return this.request;
    }

    protected void processConnect(Request request) throws Exception {
        this.request = request;
        this.sessionManager.requeue((Session)this);
    }

    private void releaseRequest() {
        Request localRequestCopy = this.request;
        if (localRequestCopy != null) {
            this.resetLastAccessedTimeToCurrent();
            this.request = null;
            try {
                localRequestCopy.resume();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void disconnect() throws Exception {
        this.processDisconnect();
    }

    protected void processDisconnect() throws Exception {
        this.releaseRequest();
    }

    public long getLastAccessedTime() {
        if (!this.active) {
            return -1L;
        }
        if (this.request != null) {
            return System.currentTimeMillis();
        }
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return 300000;
    }

    public String getId() {
        return this.id;
    }

    public void invalidate() {
        this.active = false;
        this.sessionManager.requeue((Session)this);
    }

    public synchronized void destroy() {
        this.active = false;
        try {
            this.disconnect();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }
}

