/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.richfaces.application.push.EventAbortedException;
import org.richfaces.application.push.MessageDataSerializer;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicEvent;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicListener;
import org.richfaces.application.push.impl.DefaultMessageDataSerializer;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public abstract class AbstractTopic
implements Topic {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private TopicKey key;
    private volatile MessageDataSerializer serializer;
    private volatile boolean allowSubtopics;
    private List<TopicListener> listeners = new CopyOnWriteArrayList<TopicListener>();

    public AbstractTopic(TopicKey key) {
        this.key = key;
    }

    public MessageDataSerializer getMessageDataSerializer() {
        if (this.serializer == null) {
            return DefaultMessageDataSerializer.instance();
        }
        return this.serializer;
    }

    public void setMessageDataSerializer(MessageDataSerializer serializer) {
        this.serializer = serializer;
    }

    public boolean isAllowSubtopics() {
        return this.allowSubtopics;
    }

    public void setAllowSubtopics(boolean allowSubtopics) {
        this.allowSubtopics = allowSubtopics;
    }

    public TopicKey getKey() {
        return this.key;
    }

    public void addTopicListener(TopicListener topicListener) {
        this.listeners.add(topicListener);
    }

    public void removeTopicListener(TopicListener topicListener) {
        this.listeners.remove(topicListener);
    }

    public void publishEvent(TopicEvent event) throws EventAbortedException {
        for (TopicListener listener : this.listeners) {
            if (!event.isAppropriateListener(listener)) continue;
            try {
                event.invokeListener(listener);
            }
            catch (EventAbortedException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)MessageFormat.format("Exception invoking listener: {0}", e.getMessage()), (Throwable)e);
            }
        }
    }

    public abstract void publish(String var1, Object var2) throws MessageException;
}

