/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.SessionManager;
import org.richfaces.application.push.impl.SessionManagerImpl;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtmospherePushHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final ThreadFactory BROADCASTER_THREADS_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("rf-push-worker-thread-%1$s").build();
    private static final ThreadFactory SESSION_MANAGER_THREADS_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("rf-push-session-manager-thread-%1$s").build();
    private static final String PUSH_SESSION_ID_PARAM = "pushSessionId";
    private SessionManager sessionManager = new SessionManagerImpl(SESSION_MANAGER_THREADS_FACTORY);
    private ExecutorService worker = Executors.newCachedThreadPool(BROADCASTER_THREADS_FACTORY);

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource) throws IOException {
        HttpServletRequest req = (HttpServletRequest)resource.getRequest();
        HttpServletResponse resp = (HttpServletResponse)resource.getResponse();
        String pushSessionId = req.getParameter(PUSH_SESSION_ID_PARAM);
        Session session = null;
        if (pushSessionId != null) {
            session = this.getSessionManager().getPushSession(pushSessionId);
        }
        if (session == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((CharSequence)MessageFormat.format("Session {0} was not found", pushSessionId));
            }
            resp.sendError(400);
            return;
        }
        resp.setContentType("text/plain");
        try {
            Request request = this.createRequest(resource, session);
            request.suspend();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    public void onStateChange(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
    }

    protected abstract Request createRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> var1, Session var2);

    protected ExecutorService getWorker() {
        return this.worker;
    }

    public void init(ServletConfig servletConfig) throws Exception {
    }

    public void destroy() throws Exception {
        try {
            this.worker.shutdown();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        try {
            this.sessionManager.destroy();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }
}

