/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl.jms;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.faces.context.FacesContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.TopicKey;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingContext {
    static final String SUBTOPIC_ATTRIBUTE_NAME = "rf_push_subtopic";
    private static final Joiner OR_JOINER = Joiner.on((String)" OR ").skipNulls();
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final Function<TopicKey, String> TOPIC_KEY_TO_MESSAGE_SELECTOR = new Function<TopicKey, String>(){

        public String apply(TopicKey from) {
            if (Strings.isNullOrEmpty((String)from.getSubtopicName())) {
                return null;
            }
            return "rf_push_subtopic = '" + from.getSubtopicName() + "'";
        }
    };
    private static final String SHARED_INSTANCE_KEY = MessagingContext.class.getName();
    private final InitialContext initialContext;
    private final Name connectionFactoryName;
    private final Name topicsNamespace;
    private final String applicationName;
    private final String username;
    private final String password;
    private Connection connection;

    public MessagingContext(InitialContext initialContext, Name connectionFactoryName, Name topicsNamespace, String applicationName, String username, String password) {
        this.initialContext = initialContext;
        this.connectionFactoryName = connectionFactoryName;
        this.topicsNamespace = topicsNamespace;
        this.applicationName = applicationName;
        this.username = username;
        this.password = password;
    }

    private Name appendToName(Name name, String comp) throws NamingException {
        Name clonedName = (Name)name.clone();
        return clonedName.add(comp);
    }

    public void start() throws Exception {
        ConnectionFactory connectionFactory = (ConnectionFactory)this.initialContext.lookup(this.connectionFactoryName);
        this.connection = connectionFactory.createConnection(this.username, this.password);
        try {
            this.connection.setClientID(UUID.randomUUID().toString());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.connection.start();
    }

    protected Connection getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("connection is absent");
        }
        return this.connection;
    }

    public void stop() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public Topic lookup(TopicKey topicKey) throws NamingException {
        Name topicName = this.appendToName(this.topicsNamespace, topicKey.getTopicName());
        return (Topic)this.initialContext.lookup(topicName);
    }

    public javax.jms.Session createSession() throws JMSException {
        return this.getConnection().createSession(false, 2);
    }

    public String getSubscriptionClientId(Session session, TopicKey topicKey) {
        return "rf-push:" + this.applicationName + ":" + topicKey.getTopicName() + ":" + session.getId();
    }

    public void shareInstance(FacesContext facesContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        applicationMap.put(SHARED_INSTANCE_KEY, this);
    }

    public static MessagingContext getSharedInstance(ServletContext servletContext) {
        return (MessagingContext)servletContext.getAttribute(SHARED_INSTANCE_KEY);
    }

    private String createMessageSelector(Iterable<TopicKey> topicKeys) {
        Iterable sqlStrings = Iterables.transform(topicKeys, TOPIC_KEY_TO_MESSAGE_SELECTOR);
        return OR_JOINER.join(sqlStrings) + " OR false";
    }

    public TopicSubscriber createTopicSubscriber(Session pushSession, javax.jms.Session jmsSession, Map.Entry<TopicKey, Collection<TopicKey>> entry) throws JMSException, NamingException {
        TopicKey rootTopicKey = entry.getKey();
        String subscriptionClientId = this.getSubscriptionClientId(pushSession, rootTopicKey);
        Topic jmsTopic = this.lookup(rootTopicKey);
        return jmsSession.createDurableSubscriber(jmsTopic, subscriptionClientId, this.createMessageSelector((Iterable<TopicKey>)entry.getValue()), true);
    }

    public void removeTopicSubscriber(Session session, javax.jms.Session jmsSession, Collection<TopicKey> rootTopicKeys) {
        for (TopicKey rootTopicKey : rootTopicKeys) {
            try {
                jmsSession.unsubscribe(this.getSubscriptionClientId(session, rootTopicKey));
            }
            catch (JMSException e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }
}

