/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl.jms;

import com.google.common.base.Strings;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.push.PushContext;
import org.richfaces.application.push.SessionFactory;
import org.richfaces.application.push.SessionManager;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.application.push.impl.AtmosphereHandlerProvider;
import org.richfaces.application.push.impl.jms.MessagingContext;
import org.richfaces.application.push.impl.jms.PushHandlerImpl;
import org.richfaces.application.push.impl.jms.TopicsContextImpl;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushContextImpl
implements PushContext,
SystemEventListener,
AtmosphereHandlerProvider {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private MessagingContext messagingContext;
    private TopicsContext topicsContext;
    private PushHandlerImpl pushHandlerImpl;

    public TopicsContext getTopicsContext() {
        return this.topicsContext;
    }

    private String getApplicationName(FacesContext facesContext) {
        ServletContext servletContext = (ServletContext)facesContext.getExternalContext().getContext();
        return servletContext.getContextPath();
    }

    private String getFirstNonEmptyConfgirutationValue(FacesContext facesContext, ConfigurationService service, Enum<?> ... keys) {
        for (Enum<?> key : keys) {
            String value = service.getStringValue(facesContext, key);
            if (Strings.isNullOrEmpty((String)value)) continue;
            return value;
        }
        return "";
    }

    public void init(FacesContext facesContext) {
        try {
            facesContext.getApplication().subscribeToEvent(PreDestroyApplicationEvent.class, (SystemEventListener)this);
            facesContext.getExternalContext().getApplicationMap().put(PushContext.INSTANCE_KEY_NAME, this);
            ConfigurationService configurationService = (ConfigurationService)ServiceTracker.getService(ConfigurationService.class);
            InitialContext initialContext = new InitialContext();
            NameParser nameParser = initialContext.getNameParser("");
            Name cnfName = nameParser.parse(this.getConnectionFactory(facesContext, configurationService));
            Name topicsNamespace = nameParser.parse(this.getTopicsNamespace(facesContext, configurationService));
            this.messagingContext = new MessagingContext(initialContext, cnfName, topicsNamespace, this.getApplicationName(facesContext), this.getUserName(facesContext, configurationService), this.getPassword(facesContext, configurationService));
            this.messagingContext.shareInstance(facesContext);
            this.messagingContext.start();
            this.topicsContext = new TopicsContextImpl(this.messagingContext);
            this.pushHandlerImpl = new PushHandlerImpl(this.messagingContext, this.topicsContext);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    private String getPassword(FacesContext facesContext, ConfigurationService configurationService) {
        return this.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionPassword, CoreConfiguration.Items.pushJMSConnectionPasswordEnvRef, CoreConfiguration.Items.pushJMSConnectionPassword);
    }

    private String getUserName(FacesContext facesContext, ConfigurationService configurationService) {
        return this.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionUsername, CoreConfiguration.Items.pushJMSConnectionUsernameEnvRef, CoreConfiguration.Items.pushJMSConnectionUsername);
    }

    private String getConnectionFactory(FacesContext facesContext, ConfigurationService configurationService) {
        return this.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionFactory, CoreConfiguration.Items.pushJMSConnectionFactory);
    }

    private String getTopicsNamespace(FacesContext facesContext, ConfigurationService configurationService) {
        return this.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSTopicsNamespace, CoreConfiguration.Items.pushJMSTopicsNamespace);
    }

    public void destroy() {
        if (this.pushHandlerImpl != null) {
            try {
                this.pushHandlerImpl.destroy();
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        if (this.messagingContext != null) {
            try {
                this.messagingContext.stop();
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!(event instanceof PreDestroyApplicationEvent)) {
            throw new IllegalArgumentException(event.getClass().getName());
        }
        this.destroy();
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }

    public SessionFactory getSessionFactory() {
        return this.pushHandlerImpl;
    }

    @Override
    public AtmosphereHandler<HttpServletRequest, HttpServletResponse> getHandler() {
        return this.pushHandlerImpl;
    }

    public SessionManager getSessionManager() {
        return this.pushHandlerImpl.getSessionManager();
    }
}

