/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.skin.SkinFactory;
import org.richfaces.util.FastJoiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalStaticResource
extends Resource {
    public static final String STATIC_RESOURCE_LOCATION_VARIABLE = "resourceLocation";
    private static final FastJoiner RESOURCE_PATH_JOINER = FastJoiner.on((char)'/');
    private String location;
    private boolean skinDependent;

    public ExternalStaticResource(String location, boolean skinDependent) {
        this.location = location;
        this.skinDependent = skinDependent;
    }

    private String getResourceLocation(FacesContext facesContext) {
        String skinName = null;
        if (this.skinDependent) {
            SkinFactory skinFactory = SkinFactory.getInstance((FacesContext)facesContext);
            skinName = skinFactory.getSkin(facesContext).getName();
        }
        return RESOURCE_PATH_JOINER.join(skinName, this.location);
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestPath() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object resourceVarValue = requestMap.get(STATIC_RESOURCE_LOCATION_VARIABLE);
        try {
            String resourceLocation = this.getResourceLocation(facesContext);
            requestMap.put(STATIC_RESOURCE_LOCATION_VARIABLE, resourceLocation);
            String string = ConfigurationServiceHelper.getStringConfigurationValue((FacesContext)facesContext, (Enum)CoreConfiguration.Items.staticResourceLocation);
            return string;
        }
        finally {
            requestMap.remove(STATIC_RESOURCE_LOCATION_VARIABLE);
            if (resourceVarValue != null) {
                requestMap.put(STATIC_RESOURCE_LOCATION_VARIABLE, resourceVarValue);
            }
        }
    }

    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        throw new UnsupportedOperationException();
    }
}

