/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.richfaces.util.Util;

final class IdParser {
    private static final char FUNCTION_IMAGE_START_TOKEN = '(';
    private static final char FUNCTION_IMAGE_END_TOKEN = ')';
    private static final Node[] EMPTY_NODES_ARRAY = new Node[0];

    private IdParser() {
    }

    public static Node[] parse(String id) {
        if (id.length() == 0) {
            return EMPTY_NODES_ARRAY;
        }
        ArrayList result = Lists.newArrayList();
        Iterable split = Util.NamingContainerDataHolder.SEPARATOR_CHAR_SPLITTER.split((CharSequence)id);
        for (String s : split) {
            if (s.charAt(0) == '@') {
                int startImageIdx = s.indexOf(40);
                if (startImageIdx < 0) {
                    result.add(new Node(s));
                    continue;
                }
                if (s.charAt(s.length() - 1) != ')') {
                    throw new IllegalArgumentException(id);
                }
                if (startImageIdx + 1 > s.length() - 1) {
                    throw new IllegalArgumentException(id);
                }
                String image = s.substring(startImageIdx + 1, s.length() - 1);
                String functionName = s.substring(1, startImageIdx);
                result.add(new Node(image, functionName));
                continue;
            }
            result.add(new Node(s));
        }
        return result.toArray(new Node[result.size()]);
    }

    public static final class Node {
        private String image;
        private String function;

        Node(String image) {
            this(image, null);
        }

        Node(String image, String function) {
            this.image = image;
            this.function = function;
        }

        public String getImage() {
            return this.image;
        }

        public String getFunction() {
            return this.function;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("image", (Object)this.image).add("function", (Object)this.function).toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
            result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
                return false;
            }
            return !(this.image == null ? other.image != null : !this.image.equals(other.image));
        }
    }
}

