/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Handler
extends DefaultHandler {
    private static final String TEMPLATE = "template";
    private static final String SELECTOR = "selector";
    private static final String STYLE = "style";
    private static final String RESOURCE = "resource";
    private static final String ATTRIBBUTE = "attribute";
    private static final String VERBATIM = "verbatim";
    private static final String IMPORT = "importResource";
    private StringBuilder ecssContent;
    private boolean hasAttribbute = false;
    private boolean verbatim = false;

    Handler() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String value;
        String skin;
        String name;
        String value2;
        if (TEMPLATE.equals(localName)) {
            this.ecssContent = new StringBuilder();
        }
        if (IMPORT.equals(localName)) {
            String src = atts.getValue("src");
            this.ecssContent.append("@import url(\"#{resource['");
            this.ecssContent.append(src);
            this.ecssContent.append("']\"}\r\n");
        }
        if (VERBATIM.equals(localName)) {
            this.verbatim = true;
        }
        if (SELECTOR.equals(localName) && null != (value2 = atts.getValue("name"))) {
            this.ecssContent.append(value2);
            this.ecssContent.append("{\r\n");
        }
        if (STYLE.equals(localName)) {
            name = atts.getValue("name");
            skin = atts.getValue("skin");
            value = atts.getValue("value");
            if (null != name) {
                if (skin != null) {
                    this.ecssContent.append("\t");
                    this.ecssContent.append(name);
                    this.ecssContent.append(":");
                    this.ecssContent.append("'#{richSkin.");
                    this.ecssContent.append(skin);
                    this.ecssContent.append("}'");
                } else if (value != null) {
                    this.ecssContent.append("\t");
                    this.ecssContent.append(name);
                    this.ecssContent.append(":");
                    this.ecssContent.append(value);
                } else {
                    this.ecssContent.append("\t");
                    this.ecssContent.append(name);
                    this.ecssContent.append(":");
                }
            }
        }
        if (RESOURCE.equals(localName) && null != (value2 = atts.getValue("f:key"))) {
            this.ecssContent.append("\"url(#{resource['");
            this.ecssContent.append(value2);
        }
        if (ATTRIBBUTE.equals(localName)) {
            if (!this.hasAttribbute) {
                this.ecssContent.append("?");
                this.hasAttribbute = true;
            }
            name = atts.getValue("name");
            skin = atts.getValue("skin");
            value = atts.getValue("value");
            if (null != name) {
                if (skin != null) {
                    this.ecssContent.append(name);
                    this.ecssContent.append("=");
                    this.ecssContent.append("Skin.");
                    this.ecssContent.append(skin);
                    this.ecssContent.append("&");
                } else if (value != null) {
                    this.ecssContent.append(name);
                    this.ecssContent.append("=");
                    try {
                        this.ecssContent.append(URLEncoder.encode(value, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    this.ecssContent.append("&");
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.verbatim) {
            String strValue = new String(ch, start, length);
            this.ecssContent.append(strValue);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (TEMPLATE.equals(localName)) {
            System.out.println(this.ecssContent.toString().trim());
        }
        if (VERBATIM.equals(localName)) {
            this.verbatim = false;
        }
        if (SELECTOR.equals(localName)) {
            this.ecssContent.append("}\r\n");
        }
        if (STYLE.equals(localName)) {
            this.ecssContent.append(";\r\n");
        }
        if (RESOURCE.equals(localName)) {
            if (this.hasAttribbute) {
                this.ecssContent.setLength(this.ecssContent.length() - 1);
            }
            this.ecssContent.append("']})\"");
            this.hasAttribbute = false;
        }
        if (ATTRIBBUTE.equals(localName)) {
            // empty if block
        }
    }
}

