/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.css;

import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSUnknownRule;

public abstract class AbstractCSSVisitor {
    public void visitStyleSheet(CSSStyleSheet styleSheet) {
        this.startStyleSheet(styleSheet);
        CSSRuleList rules = styleSheet.getCssRules();
        int length = rules.getLength();
        for (int i = 0; i < length; ++i) {
            CSSRule rule = rules.item(i);
            this.visitRule(rule);
        }
        this.endStyleSheet(styleSheet);
    }

    public void visitRule(CSSRule rule) {
        switch (rule.getType()) {
            case 0: {
                this.visitUnknownRule((CSSUnknownRule)rule);
                break;
            }
            case 1: {
                this.visitStyleRule((CSSStyleRule)rule);
                break;
            }
            case 2: {
                this.visitCharsetRule((CSSCharsetRule)rule);
                break;
            }
            case 3: {
                this.visitImportRule((CSSImportRule)rule);
                break;
            }
            case 4: {
                this.visitMediaRule((CSSMediaRule)rule);
                break;
            }
            case 5: {
                this.visitFontFaceRule((CSSFontFaceRule)rule);
                break;
            }
            case 6: {
                this.visitPageRule((CSSPageRule)rule);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected abstract void startStyleSheet(CSSStyleSheet var1);

    protected abstract void endStyleSheet(CSSStyleSheet var1);

    public abstract void visitUnknownRule(CSSUnknownRule var1);

    public void visitStyleRule(CSSStyleRule rule) {
        this.startStyleRule(rule);
        CSSStyleDeclaration style = rule.getStyle();
        this.visitStyleDeclaration(style);
        this.endStyleRule(rule);
    }

    protected abstract void startStyleRule(CSSStyleRule var1);

    protected abstract void endStyleRule(CSSStyleRule var1);

    public abstract void visitCharsetRule(CSSCharsetRule var1);

    public abstract void visitImportRule(CSSImportRule var1);

    public void visitMediaRule(CSSMediaRule rule) {
        this.startMediaRule(rule);
        CSSRuleList rules = rule.getCssRules();
        int length = rules.getLength();
        for (int i = 0; i < length; ++i) {
            CSSRule childRule = rules.item(i);
            this.visitRule(childRule);
        }
        this.endMediaRule(rule);
    }

    protected abstract void startMediaRule(CSSMediaRule var1);

    protected abstract void endMediaRule(CSSMediaRule var1);

    public void visitFontFaceRule(CSSFontFaceRule rule) {
        this.startFontRule(rule);
        CSSStyleDeclaration style = rule.getStyle();
        this.visitStyleDeclaration(style);
        this.endFontRule(rule);
    }

    protected abstract void startFontRule(CSSFontFaceRule var1);

    protected abstract void endFontRule(CSSFontFaceRule var1);

    public void visitPageRule(CSSPageRule rule) {
        this.startPageRule(rule);
        CSSStyleDeclaration style = rule.getStyle();
        this.visitStyleDeclaration(style);
        this.endPageRule(rule);
    }

    protected abstract void startPageRule(CSSPageRule var1);

    protected abstract void endPageRule(CSSPageRule var1);

    public abstract void visitStyleDeclaration(CSSStyleDeclaration var1);
}

