/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache.lru;

import java.util.PriorityQueue;
import org.richfaces.cache.lru.CacheEntry;
import org.richfaces.util.LRUMap;

public final class CacheMap
extends LRUMap<Object, CacheEntry> {
    private static final long serialVersionUID = -5422668357346537621L;
    private PriorityQueue<CacheEntry> expirationQueue = new PriorityQueue();

    public CacheMap() {
    }

    public CacheMap(int capacity) {
        super(capacity);
    }

    public PriorityQueue<CacheEntry> getExpirationQueue() {
        return this.expirationQueue;
    }

    public CacheEntry put(Object key, CacheEntry value) {
        CacheEntry entry = (CacheEntry)super.put(key, (Object)value);
        if (entry != null) {
            this.expirationQueue.remove(entry);
        }
        if (value.getExpired() != null) {
            this.expirationQueue.add(value);
        }
        return entry;
    }

    public CacheEntry remove(Object key) {
        CacheEntry entry = (CacheEntry)super.remove(key);
        if (entry != null) {
            this.expirationQueue.remove(entry);
        }
        return entry;
    }

    public void clear() {
        super.clear();
        this.expirationQueue.clear();
    }

    public void purge() {
        CacheEntry queueEntry = this.expirationQueue.peek();
        while (queueEntry != null && queueEntry.isExpired()) {
            super.remove(queueEntry.getKey());
            this.expirationQueue.remove();
            queueEntry = this.expirationQueue.peek();
        }
    }
}

