/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.Java2DAnimatedUserResource;
import org.richfaces.resource.Java2DUserResource;
import org.richfaces.resource.Java2DUserResourceWrapperImpl;
import org.w3c.dom.Node;

public class Java2DAnimatedUserResourceWrapperImpl
extends Java2DUserResourceWrapperImpl {
    public Java2DAnimatedUserResourceWrapperImpl(Java2DAnimatedUserResource resourceObject, boolean cacheable, boolean versioned) {
        super((Java2DUserResource)resourceObject, cacheable, versioned);
    }

    private static ImageWriter getSequenceCapableImageWriter(ImageType imageType) {
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName(imageType.getFormatName());
        while (imageWriters.hasNext()) {
            ImageWriter imageWriter = imageWriters.next();
            if (!imageWriter.canWriteSequence()) continue;
            return imageWriter;
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot find sequence-capable image writer for {0} format", imageType.getFormatName()));
    }

    private static Node getOrCreateChild(Node root, String name) {
        Node result = null;
        for (Node node = root.getFirstChild(); node != null && result == null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            result = node;
        }
        if (result == null) {
            result = new IIOMetadataNode(name);
            root.appendChild(result);
        }
        return result;
    }

    private static void checkSupportedFormat(ImageType imageType) {
        if (imageType != ImageType.GIF) {
            throw new IllegalArgumentException(MessageFormat.format("Image format {0} is not supported", imageType.getFormatName()));
        }
    }

    @Override
    public String getRequestPath() {
        Java2DAnimatedUserResourceWrapperImpl.checkSupportedFormat(((Java2DUserResource)this.getWrapped()).getImageType());
        return super.getRequestPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintAndWrite(ImageOutputStream outputStream) throws IOException {
        Java2DAnimatedUserResource userResource = (Java2DAnimatedUserResource)this.getWrapped();
        ImageType imageType = userResource.getImageType();
        Java2DAnimatedUserResourceWrapperImpl.checkSupportedFormat(imageType);
        ImageWriter imageWriter = Java2DAnimatedUserResourceWrapperImpl.getSequenceCapableImageWriter(imageType);
        Dimension dimension = userResource.getDimension();
        BufferedImage image = imageType.createImage(dimension);
        try {
            imageWriter.setOutput(outputStream);
            ImageWriteParam defaultImageWriteParam = imageWriter.getDefaultWriteParam();
            IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(1), defaultImageWriteParam);
            String metaFormatName = imageMetaData.getNativeMetadataFormatName();
            Node root = imageMetaData.getAsTree(metaFormatName);
            IIOMetadataNode graphicsControlExtensionNode = (IIOMetadataNode)Java2DAnimatedUserResourceWrapperImpl.getOrCreateChild(root, "GraphicControlExtension");
            graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
            graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
            graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
            graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(userResource.getFrameDelay() / 100));
            graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
            Node applicationExtensionsNode = Java2DAnimatedUserResourceWrapperImpl.getOrCreateChild(root, "ApplicationExtensions");
            IIOMetadataNode netscapeExtension = new IIOMetadataNode("ApplicationExtension");
            netscapeExtension.setAttribute("applicationID", "NETSCAPE");
            netscapeExtension.setAttribute("authenticationCode", "2.0");
            byte numLoops = (byte)(!userResource.isLooped() ? 1 : 0);
            netscapeExtension.setUserObject(new byte[]{1, numLoops, 0});
            applicationExtensionsNode.appendChild(netscapeExtension);
            imageMetaData.setFromTree(metaFormatName, root);
            imageWriter.prepareWriteSequence(null);
            userResource.startFramesSequence();
            while (userResource.hasNextFrame()) {
                Graphics2D g2d = null;
                try {
                    g2d = this.createGraphics(image);
                    userResource.paint(g2d);
                    imageWriter.writeToSequence(new IIOImage(image, null, imageMetaData), defaultImageWriteParam);
                }
                finally {
                    if (g2d == null) continue;
                    g2d.dispose();
                }
            }
            imageWriter.endWriteSequence();
        }
        finally {
            imageWriter.dispose();
        }
    }
}

