/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.concurrent.atomic.AtomicReference;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ExternalResource;
import org.richfaces.resource.external.ExternalResourceTracker;
import org.richfaces.resource.external.MojarraExternalResourceTracker;
import org.richfaces.resource.external.MyFacesExternalResourceTracker;

public class ExternalResourceTrackerWrapper
implements ExternalResourceTracker {
    private static final Logger LOG = RichfacesLogger.RESOURCE.getLogger();
    private static final String MYFACES_RESOURCE_UTILS_CLASS = "org.apache.myfaces.shared.renderkit.html.util.ResourceUtils";
    private static final String WEBSPHERE_BUNDLED_MYFACES_RESOURCE_UTILS_CLASS = "org.apache.myfaces.shared_impl.renderkit.html.util.ResourceUtils";
    private static final String[] MYFACES_RESOURCE_UTILS_CLASSES = new String[]{"org.apache.myfaces.shared.renderkit.html.util.ResourceUtils", "org.apache.myfaces.shared_impl.renderkit.html.util.ResourceUtils"};
    private AtomicReference<ExternalResourceTracker> externalResourceTracker = new AtomicReference();

    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        return this.getWrapped().isResourceRenderered(facesContext, resourceKey);
    }

    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        this.getWrapped().markResourceRendered(facesContext, resourceKey);
    }

    public void markExternalResourceRendered(FacesContext facesContext, ExternalResource resource) {
        this.getWrapped().markExternalResourceRendered(facesContext, resource);
    }

    private ExternalResourceTracker getWrapped() {
        ExternalResourceTracker tracker = this.externalResourceTracker.get();
        if (tracker == null) {
            Class<?> myfacesResUtilClass = null;
            for (String myFacesResourceUtilsClass : MYFACES_RESOURCE_UTILS_CLASSES) {
                try {
                    myfacesResUtilClass = this.getClass().getClassLoader().loadClass(myFacesResourceUtilsClass);
                    break;
                }
                catch (Exception e) {
                    LOG.debug((CharSequence)("could not load myfaces resource utils class: " + myFacesResourceUtilsClass), (Throwable)e);
                }
            }
            if (myfacesResUtilClass != null) {
                this.externalResourceTracker.compareAndSet(null, new MyFacesExternalResourceTracker(myfacesResUtilClass));
            } else {
                this.externalResourceTracker.compareAndSet(null, new MojarraExternalResourceTracker());
            }
            tracker = this.externalResourceTracker.get();
        }
        return tracker;
    }
}

