/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.JavaScriptParameter;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.component.util.PartialStateHolderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParameter
extends UIParameter
implements ActionListener,
JavaScriptParameter {
    public static final String COMPONENT_TYPE = "org.richfaces.Parameter";
    public static final String COMPONENT_FAMILY = "javax.faces.Parameter";
    private static final String ASSIGN_TO = "assignTo";
    private Converter converter = null;

    @Attribute
    public abstract boolean isNoEscape();

    public abstract void setNoEscape(boolean var1);

    public void setAssignToExpression(ValueExpression ve) {
        this.setValueExpression(ASSIGN_TO, ve);
    }

    public ValueExpression getAssignToExpression() {
        return this.getValueExpression(ASSIGN_TO);
    }

    public void setConverter(Converter converter) {
        this.clearInitialState();
        this.converter = converter;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = this.getFacesContext();
        ELContext elContext = context.getELContext();
        ValueExpression updateBinding = this.getAssignToExpression();
        if (updateBinding != null && !updateBinding.isReadOnly(elContext)) {
            Class type;
            Converter converter;
            String requestValue = (String)context.getExternalContext().getRequestParameterMap().get(this.getName());
            Object convertedValue = requestValue;
            if (requestValue != null && null != (converter = this.createConverter(context, type = updateBinding.getType(elContext)))) {
                convertedValue = converter.getAsObject(context, (UIComponent)this, requestValue);
            }
            if (null != convertedValue) {
                updateBinding.setValue(elContext, convertedValue);
            }
        }
    }

    public String getName() {
        String name = super.getName();
        if (null == name) {
            name = this.getClientId(FacesContext.getCurrentInstance());
        }
        return name;
    }

    public Object getValue() {
        Object value = super.getValue();
        if (null != value) {
            Class<?> type = value.getClass();
            FacesContext context = this.getFacesContext();
            Converter converter = this.createConverter(context, type);
            if (null != converter) {
                value = converter.getAsString(context, (UIComponent)this, value);
            }
        }
        return value;
    }

    private Converter createConverter(FacesContext context, Class<?> type) throws FacesException {
        Converter converter = this.getConverter();
        if (converter == null && type != null && !type.equals(String.class) && !type.equals(Object.class)) {
            try {
                converter = context.getApplication().createConverter(type);
            }
            catch (Exception e) {
                throw new FacesException(Messages.getMessage((String)"NO_CONVERTER_REGISTERED", (Object)type.getName()), (Throwable)e);
            }
        }
        return converter;
    }

    public void markInitialState() {
        super.markInitialState();
        Converter c = this.getConverter();
        if (c instanceof PartialStateHolder) {
            ((PartialStateHolder)c).markInitialState();
        }
    }

    public void clearInitialState() {
        if (this.initialStateMarked()) {
            super.clearInitialState();
            Converter c = this.getConverter();
            if (c instanceof PartialStateHolder) {
                ((PartialStateHolder)c).clearInitialState();
            }
        }
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object superState = super.saveState(context);
        Object converterState = PartialStateHolderUtil.saveState(context, (UIComponent)this, this.converter);
        if (superState == null && converterState == null) {
            return null;
        }
        return new Object[]{superState, converterState};
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.converter = (Converter)PartialStateHolderUtil.restoreState(context, values[1], this.converter);
    }
}

