/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractMenuGroup;

/**
 * 
 **/
@Generated({"RichFaces CDK", "4.1.0.Final"})
public class UIMenuGroup extends AbstractMenuGroup
    implements ClientBehaviorHolder    {

    public static final String COMPONENT_TYPE="org.richfaces.MenuGroup";

    public static final String COMPONENT_FAMILY="org.richfaces.DropDownMenu";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIMenuGroup() {
        super();
        setRendererType("org.richfaces.MenuGroupRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "keypress",
        "mousedown",
        "keyup",
        "dblclick",
        "click",
        "hide",
        "show",
        "mouseover",
        "mousemove",
        "mouseout",
        "keydown",
        "mouseup"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }


    protected enum Properties {
        dir,
        direction,
        disabled,
        horizontalOffset,
        icon,
        iconDisabled,
        jointPoint,
        label,
        lang,
        onclick,
        ondblclick,
        onhide,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onshow,
        style,
        styleClass,
        title,
        value,
        verticalOffset
        
    }

 
    public String getDir() {
        String value = (String) getStateHelper().eval(Properties.dir);
        return value;
    }
    
    public void setDir(String dir) {
        getStateHelper().put(Properties.dir, dir);
        handleAttribute("dir",dir);
    }

 
    public Positioning getDirection() {
        Positioning value = (Positioning) getStateHelper().eval(Properties.direction);
        return value;
    }
    
    public void setDirection(Positioning direction) {
        getStateHelper().put(Properties.direction, direction);
    }

 
    public boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled, false);
        return value;
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public int getHorizontalOffset() {
        Integer value = (Integer) getStateHelper().eval(Properties.horizontalOffset, Integer.MIN_VALUE);
        return value;
    }
    
    public void setHorizontalOffset(int horizontalOffset) {
        getStateHelper().put(Properties.horizontalOffset, horizontalOffset);
    }

 
    public String getIcon() {
        String value = (String) getStateHelper().eval(Properties.icon);
        return value;
    }
    
    public void setIcon(String icon) {
        getStateHelper().put(Properties.icon, icon);
    }

 
    public String getIconDisabled() {
        String value = (String) getStateHelper().eval(Properties.iconDisabled);
        return value;
    }
    
    public void setIconDisabled(String iconDisabled) {
        getStateHelper().put(Properties.iconDisabled, iconDisabled);
    }

 
    public Positioning getJointPoint() {
        Positioning value = (Positioning) getStateHelper().eval(Properties.jointPoint);
        return value;
    }
    
    public void setJointPoint(Positioning jointPoint) {
        getStateHelper().put(Properties.jointPoint, jointPoint);
    }

 
    public String getLabel() {
        String value = (String) getStateHelper().eval(Properties.label);
        return value;
    }
    
    public void setLabel(String label) {
        getStateHelper().put(Properties.label, label);
    }

 
    public String getLang() {
        String value = (String) getStateHelper().eval(Properties.lang);
        return value;
    }
    
    public void setLang(String lang) {
        getStateHelper().put(Properties.lang, lang);
        handleAttribute("lang",lang);
    }

 
    public String getOnclick() {
        String value = (String) getStateHelper().eval(Properties.onclick);
        return value;
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
        handleAttribute("onclick",onclick);
    }

 
    public String getOndblclick() {
        String value = (String) getStateHelper().eval(Properties.ondblclick);
        return value;
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
        handleAttribute("ondblclick",ondblclick);
    }

 
    public String getOnhide() {
        String value = (String) getStateHelper().eval(Properties.onhide);
        return value;
    }
    
    public void setOnhide(String onhide) {
        getStateHelper().put(Properties.onhide, onhide);
    }

 
    public String getOnkeydown() {
        String value = (String) getStateHelper().eval(Properties.onkeydown);
        return value;
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
        handleAttribute("onkeydown",onkeydown);
    }

 
    public String getOnkeypress() {
        String value = (String) getStateHelper().eval(Properties.onkeypress);
        return value;
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
        handleAttribute("onkeypress",onkeypress);
    }

 
    public String getOnkeyup() {
        String value = (String) getStateHelper().eval(Properties.onkeyup);
        return value;
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
        handleAttribute("onkeyup",onkeyup);
    }

 
    public String getOnmousedown() {
        String value = (String) getStateHelper().eval(Properties.onmousedown);
        return value;
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
        handleAttribute("onmousedown",onmousedown);
    }

 
    public String getOnmousemove() {
        String value = (String) getStateHelper().eval(Properties.onmousemove);
        return value;
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
        handleAttribute("onmousemove",onmousemove);
    }

 
    public String getOnmouseout() {
        String value = (String) getStateHelper().eval(Properties.onmouseout);
        return value;
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
        handleAttribute("onmouseout",onmouseout);
    }

 
    public String getOnmouseover() {
        String value = (String) getStateHelper().eval(Properties.onmouseover);
        return value;
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
        handleAttribute("onmouseover",onmouseover);
    }

 
    public String getOnmouseup() {
        String value = (String) getStateHelper().eval(Properties.onmouseup);
        return value;
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
        handleAttribute("onmouseup",onmouseup);
    }

 
    public String getOnshow() {
        String value = (String) getStateHelper().eval(Properties.onshow);
        return value;
    }
    
    public void setOnshow(String onshow) {
        getStateHelper().put(Properties.onshow, onshow);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
        handleAttribute("style",style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public String getTitle() {
        String value = (String) getStateHelper().eval(Properties.title);
        return value;
    }
    
    public void setTitle(String title) {
        getStateHelper().put(Properties.title, title);
        handleAttribute("title",title);
    }

 
    public Object getValue() {
        Object value = (Object) getStateHelper().eval(Properties.value);
        return value;
    }
    
    public void setValue(Object value) {
        getStateHelper().put(Properties.value, value);
    }

 
    public int getVerticalOffset() {
        Integer value = (Integer) getStateHelper().eval(Properties.verticalOffset, Integer.MIN_VALUE);
        return value;
    }
    
    public void setVerticalOffset(int verticalOffset) {
        getStateHelper().put(Properties.verticalOffset, verticalOffset);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(14);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    



}