/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.convert.DateTimeConverter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.Positioning;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.event.CurrentDateChangeEvent;
import org.richfaces.event.CurrentDateChangeListener;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.CalendarDataModel;
import org.richfaces.model.CalendarDataModelItem;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.utils.CalendarHelper;

public abstract class AbstractCalendar
extends UIInput
implements MetaComponentResolver,
MetaComponentEncoder {
    public static final String DAYSDATA_META_COMPONENT_ID = "daysData";
    public static final String COMPONENT_TYPE = "org.richfaces.Calendar";
    public static final String COMPONENT_FAMILY = "org.richfaces.Calendar";
    public static final String SUB_TIME_PATTERN = "\\s*[hHkKma]+[\\W&&\\S]+[hHkKma]+[\\W&&\\S]*[s]*\\s*";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_DATE_PATTERN = "MMM d, yyyy";
    Logger log = RichfacesLogger.COMPONENTS.getLogger();

    @Attribute
    public abstract String getDatePattern();

    @Attribute
    public abstract TimeZone getTimeZone();

    @Attribute
    public abstract int getFirstWeekDay();

    @Attribute
    public abstract int getMinDaysInFirstWeek();

    @Attribute
    public abstract String getTodayControlMode();

    @Attribute(defaultValue="true")
    public abstract boolean isShowWeekDaysBar();

    @Attribute(defaultValue="true")
    public abstract boolean isShowWeeksBar();

    @Attribute(defaultValue="true")
    public abstract boolean isShowFooter();

    @Attribute(defaultValue="true")
    public abstract boolean isShowHeader();

    @Attribute(defaultValue="true")
    public abstract boolean isShowInput();

    @Attribute(defaultValue="true")
    public abstract boolean isPopup();

    @Attribute
    public abstract boolean isDisabled();

    @Attribute
    public abstract boolean isEnableManualInput();

    @Attribute
    public abstract String getDayDisableFunction();

    @Attribute
    public abstract boolean isShowApplyButton();

    @Attribute
    public abstract boolean isResetTimeOnDateSelect();

    @Attribute
    public abstract Positioning getJointPoint();

    @Attribute
    public abstract Positioning getDirection();

    @Attribute
    public abstract String getBoundaryDatesMode();

    @Attribute
    public abstract int getHorizontalOffset();

    @Attribute
    public abstract int getVerticalOffset();

    @Attribute
    public abstract int getZindex();

    @Attribute
    public abstract Mode getMode();

    @Attribute
    public abstract String getDefaultLabel();

    @Attribute
    public abstract String getStyle();

    @Attribute
    public abstract String getStyleClass();

    @Attribute
    public abstract String getPopupStyle();

    @Attribute
    public abstract String getPopupClass();

    @Attribute
    public abstract Object getMonthLabels();

    @Attribute
    public abstract Object getMonthLabelsShort();

    @Attribute
    public abstract Object getWeekDayLabelsShort();

    @Attribute
    public abstract Object getWeekDayLabels();

    @Attribute
    public abstract String getDayClassFunction();

    @Attribute
    public abstract String getTabindex();

    @Attribute
    public abstract String getInputStyle();

    @Attribute
    public abstract String getButtonClass();

    @Attribute
    public abstract String getInputClass();

    @Attribute
    public abstract String getButtonLabel();

    @Attribute
    public abstract String getInputSize();

    @Attribute
    public abstract Object getCurrentDate();

    @Attribute
    public abstract void setCurrentDate(Object var1);

    @Attribute
    public abstract String getButtonIcon();

    @Attribute
    public abstract String getButtonDisabledIcon();

    @Attribute
    public abstract Object getDefaultTime();

    @Attribute
    public abstract Object getPreloadDateRangeBegin();

    public abstract void setPreloadDateRangeBegin(Object var1);

    @Attribute
    public abstract Object getPreloadDateRangeEnd();

    public abstract void setPreloadDateRangeEnd(Object var1);

    @Attribute
    public abstract CalendarDataModel getDataModel();

    @Attribute(events={@EventName(value="inputclick")})
    public abstract String getOninputclick();

    @Attribute(events={@EventName(value="inputdblclick")})
    public abstract String getOninputdblclick();

    @Attribute(events={@EventName(value="inputchange")})
    public abstract String getOninputchange();

    @Attribute(events={@EventName(value="inputselect")})
    public abstract String getOninputselect();

    @Attribute(events={@EventName(value="inputmousedown")})
    public abstract String getOninputmousedown();

    @Attribute(events={@EventName(value="inputmousemove")})
    public abstract String getOninputmousemove();

    @Attribute(events={@EventName(value="inputmouseout")})
    public abstract String getOninputmouseout();

    @Attribute(events={@EventName(value="inputmouseover")})
    public abstract String getOninputmouseover();

    @Attribute(events={@EventName(value="inputmouseup")})
    public abstract String getOninputmouseup();

    @Attribute(events={@EventName(value="inputkeydown")})
    public abstract String getOninputkeydown();

    @Attribute(events={@EventName(value="inputkeypress")})
    public abstract String getOninputkeypress();

    @Attribute(events={@EventName(value="inputkeyup")})
    public abstract String getOninputkeyup();

    @Attribute(events={@EventName(value="inputfocus")})
    public abstract String getOninputfocus();

    @Attribute(events={@EventName(value="inputblur")})
    public abstract String getOninputblur();

    @Attribute(events={@EventName(value="change", defaultEvent=true)})
    public abstract String getOnchange();

    @Attribute(events={@EventName(value="dateselect")})
    public abstract String getOndateselect();

    @Attribute(events={@EventName(value="beforedateselect")})
    public abstract String getOnbeforedateselect();

    @Attribute(events={@EventName(value="currentdateselect")})
    public abstract String getOncurrentdateselect();

    @Attribute(events={@EventName(value="beforecurrentdateselect")})
    public abstract String getOnbeforecurrentdateselect();

    @Attribute(events={@EventName(value="complete")})
    public abstract String getOncomplete();

    @Attribute(events={@EventName(value="hide")})
    public abstract String getOnhide();

    @Attribute(events={@EventName(value="datemouseout")})
    public abstract String getOndatemouseout();

    @Attribute(events={@EventName(value="datemouseover")})
    public abstract String getOndatemouseover();

    @Attribute(events={@EventName(value="show")})
    public abstract String getOnshow();

    @Attribute(events={@EventName(value="timeselect")})
    public abstract String getOntimeselect();

    @Attribute(events={@EventName(value="beforetimeselect")})
    public abstract String getOnbeforetimeselect();

    @Attribute(events={@EventName(value="clean")})
    public abstract String getOnclean();

    @Attribute
    public Object getLocale() {
        FacesContext facesContext;
        UIViewRoot viewRoot;
        Object locale = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale));
        if (locale == null && (viewRoot = (facesContext = this.getFacesContext()).getViewRoot()) != null) {
            locale = viewRoot.getLocale();
        }
        return locale != null ? locale : Locale.US;
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof CurrentDateChangeEvent) {
            FacesContext facesContext = this.getFacesContext();
            CurrentDateChangeEvent currentDateChangeEvent = (CurrentDateChangeEvent)event;
            String currentDateString = currentDateChangeEvent.getCurrentDateString();
            try {
                Date currentDate = CalendarHelper.getAsDate(facesContext, this, this.getCurrentDate());
                Date submittedCurrentDate = CalendarHelper.convertCurrentDate(currentDateString, facesContext, this);
                currentDateChangeEvent.setCurrentDate(submittedCurrentDate);
                if (!submittedCurrentDate.equals(currentDate)) {
                    this.updateCurrentDate(facesContext, submittedCurrentDate);
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)(" currentDate convertion fails with following exception: " + e.toString()), (Throwable)e);
                }
                this.setValid(false);
                String messageString = e.toString();
                FacesMessage message = new FacesMessage(messageString);
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                facesContext.addMessage(this.getClientId(facesContext), message);
                facesContext.renderResponse();
            }
        }
        super.broadcast(event);
    }

    public void updateCurrentDate(FacesContext facesContext, Object currentDate) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        try {
            ValueExpression ve = this.getValueExpression("currentDate");
            if (ve != null) {
                ELContext elContext = facesContext.getELContext();
                if (ve.getType(elContext).equals(String.class)) {
                    DateTimeConverter convert = new DateTimeConverter();
                    convert.setLocale(CalendarHelper.getAsLocale(facesContext, this, this.getLocale()));
                    convert.setPattern(CalendarHelper.getDatePatternOrDefault(this));
                    ve.setValue(facesContext.getELContext(), (Object)convert.getAsString(facesContext, (UIComponent)this, currentDate));
                    return;
                }
                if (ve.getType(elContext).equals(Calendar.class)) {
                    Calendar c = CalendarHelper.getCalendar(facesContext, this);
                    c.setTime((Date)currentDate);
                    ve.setValue(elContext, (Object)c);
                    return;
                }
                ve.setValue(elContext, currentDate);
                return;
            }
            this.setCurrentDate(currentDate);
        }
        catch (Exception e) {
            this.setValid(false);
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)(" updateCurrentDate method throws exception: " + e.toString()), (Throwable)e);
            }
            String messageString = e.toString();
            FacesMessage message = new FacesMessage(messageString);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            facesContext.addMessage(this.getClientId(facesContext), message);
        }
    }

    public void addCurrentDateChangeListener(CurrentDateChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void removeCurrentDateChangeListener(CurrentDateChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public CurrentDateChangeListener[] getCurrentDateChangeListeners() {
        return (CurrentDateChangeListener[])this.getFacesListeners(CurrentDateChangeListener.class);
    }

    public static Object getDefaultValueOfDefaultTime(FacesContext facesContext, AbstractCalendar calendarComponent) {
        if (calendarComponent == null) {
            return null;
        }
        Calendar calendar = CalendarHelper.getCalendar(facesContext, calendarComponent);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    protected Date getDefaultPreloadBegin(Date date) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Calendar calendar = Calendar.getInstance(CalendarHelper.getTimeZoneOrDefault(this), CalendarHelper.getAsLocale(facesContext, this, this.getLocale()));
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    protected Date getDefaultPreloadEnd(Date date) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Calendar calendar = Calendar.getInstance(CalendarHelper.getTimeZoneOrDefault(this), CalendarHelper.getAsLocale(facesContext, this, this.getLocale()));
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public Date getCurrentDateOrDefault() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Date date = CalendarHelper.getAsDate(facesContext, this, this.getCurrentDate());
        if (date != null) {
            return date;
        }
        Date value = CalendarHelper.getAsDate(facesContext, this, this.getValue());
        if (value != null) {
            return value;
        }
        return Calendar.getInstance(CalendarHelper.getTimeZoneOrDefault(this)).getTime();
    }

    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (DAYSDATA_META_COMPONENT_ID.equals(metaComponentId)) {
            return this.getClientId(facesContext) + '@' + metaComponentId;
        }
        return null;
    }

    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block10: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext facesContext = context.getFacesContext();
            this.pushComponentToEL(facesContext, null);
            try {
                ExtendedVisitContext extendedVisitContext;
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result == VisitResult.ACCEPT && context instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)context).getVisitMode() == ExtendedVisitContextMode.RENDER && (result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, DAYSDATA_META_COMPONENT_ID)) == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT) break block10;
                Iterator kids = this.getFacetsAndChildren();
                while (kids.hasNext()) {
                    boolean done = ((UIComponent)kids.next()).visitTree(context, callback);
                    if (!done) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
            }
        }
        return false;
    }

    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        ((MetaComponentRenderer)this.getRenderer(context)).encodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    public Object getPreload() {
        CalendarDataModel calendarDataModel;
        Date[] preloadDateRange = this.getPreloadDateRange();
        if (preloadDateRange != null && preloadDateRange.length != 0 && (calendarDataModel = this.getDataModel()) != null) {
            CalendarDataModelItem[] calendarDataModelItems = calendarDataModel.getData(preloadDateRange);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("startDate", AbstractCalendar.formatStartDate(preloadDateRange[0]));
            args.put("days", this.deleteEmptyPropeties(calendarDataModelItems));
            return args;
        }
        return null;
    }

    public static Object formatStartDate(Date date) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        AbstractCalendar calendarInstance = (AbstractCalendar)AbstractCalendar.getCurrentComponent((FacesContext)facesContext);
        Calendar calendar = CalendarHelper.getCalendar(facesContext, calendarInstance);
        calendar.setTime(date);
        HashMap<String, Integer> hashDate = new HashMap<String, Integer>();
        hashDate.put("month", calendar.get(2));
        hashDate.put("year", calendar.get(1));
        return hashDate;
    }

    public ArrayList<Object> deleteEmptyPropeties(CalendarDataModelItem[] calendarDataModelItems) {
        ArrayList<Object> hashItems = new ArrayList<Object>();
        for (CalendarDataModelItem item : calendarDataModelItems) {
            HashMap<String, Object> itemPropertiesMap = new HashMap<String, Object>();
            if (null != item) {
                if (!item.isEnabled()) {
                    itemPropertiesMap.put("enabled", item.isEnabled());
                }
                if (null != item.getStyleClass() && !item.getStyleClass().equalsIgnoreCase("")) {
                    itemPropertiesMap.put("styleClass", item.getStyleClass());
                }
            }
            hashItems.add(itemPropertiesMap);
        }
        return hashItems;
    }

    public Date[] getPreloadDateRange() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Date dateRangeBegin = null;
        Date dateRangeEnd = null;
        Mode mode = this.getMode();
        if (mode == null) {
            mode = Mode.client;
        }
        if (Mode.ajax.equals((Object)mode)) {
            dateRangeBegin = CalendarHelper.getAsDate(facesContext, this, this.getDefaultPreloadBegin(this.getCurrentDateOrDefault()));
            dateRangeEnd = CalendarHelper.getAsDate(facesContext, this, this.getDefaultPreloadEnd(this.getCurrentDateOrDefault()));
        } else {
            Object date = this.getPreloadDateRangeBegin();
            if (date == null) {
                date = this.getDefaultPreloadBegin(this.getCurrentDateOrDefault());
            }
            dateRangeBegin = CalendarHelper.getAsDate(facesContext, this, date);
            date = this.getPreloadDateRangeEnd();
            if (date == null) {
                date = this.getDefaultPreloadEnd(this.getCurrentDateOrDefault());
            }
            dateRangeEnd = CalendarHelper.getAsDate(facesContext, this, date);
        }
        if (dateRangeBegin == null && dateRangeEnd == null) {
            return null;
        }
        if (dateRangeBegin.after(dateRangeEnd)) {
            FacesMessage message = new FacesMessage("preloadDateRangeBegin is greater than preloadDateRangeEnd");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            facesContext.addMessage(this.getClientId(facesContext), message);
            throw new IllegalArgumentException();
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance(CalendarHelper.getTimeZoneOrDefault(this), CalendarHelper.getAsLocale(facesContext, this, this.getLocale()));
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar.setTime(dateRangeBegin);
        calendar2.setTime(dateRangeEnd);
        do {
            dates.add(calendar.getTime());
            calendar.add(5, 1);
        } while (!calendar.after(calendar2));
        return dates.toArray(new Date[dates.size()]);
    }

    public static enum Mode {
        client,
        ajax;

    }

    protected static enum PropertyKeys {
        locale;

    }
}

