package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.FileUploadRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import static org.richfaces.renderkit.RenderKitUtils.*;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.RenderKitUtils.ScriptHashVariableWrapper;


@ResourceDependencies({@ResourceDependency(name="ajax.reslib",library="org.richfaces",target=""),@ResourceDependency(name="base-component.reslib",library="org.richfaces",target=""),@ResourceDependency(name="richfaces-event.js",library="",target=""),@ResourceDependency(name="fileupload.js",library="org.richfaces",target=""),@ResourceDependency(name="fileupload.ecss",library="org.richfaces",target="")})
public class FileUploadRenderer extends FileUploadRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES82 = attributes()
	     .generic("align","align")
	     

	     .generic("dir","dir")
	     

	     .generic("lang","lang")
	     

	     .generic("onclick","onclick","click")
	     

	     .generic("ondblclick","ondblclick","dblclick")
	     

	     .generic("onkeydown","onkeydown","keydown")
	     

	     .generic("onkeypress","onkeypress","keypress")
	     

	     .generic("onkeyup","onkeyup","keyup")
	     

	     .generic("onmousedown","onmousedown","mousedown")
	     

	     .generic("onmousemove","onmousemove","mousemove")
	     

	     .generic("onmouseout","onmouseout","mouseout")
	     

	     .generic("onmouseover","onmouseover","mouseover")
	     

	     .generic("onmouseup","onmouseup","mouseup")
	     

	     .generic("style","style")
	     

	     .generic("title","title")
	     
;
	
private static final Attributes ATTRIBUTES_FOR_SCRIPT_HASH59 = attributes()
	     .generic("acceptedTypes","acceptedTypes")
	     

	     .generic("maxFilesQuantity","maxFilesQuantity")
	     

	     .generic("noDuplicate","noDuplicate")
	     .defaultValue(false)

	     .generic("onfilesubmit","onfilesubmit","filesubmit")
	     

	     .generic("ontyperejected","ontyperejected","typerejected")
	     

	     .generic("onuploadcomplete","onuploadcomplete","uploadcomplete")
	     

	     .generic("doneLabel","doneLabel")
	     

	     .generic("sizeExceededLabel","sizeExceededLabel")
	     

	     .generic("stoppedLabel","stoppedLabel")
	     

	     .generic("serverErrorLabel","serverErrorLabel")
	     

	     .generic("clearLabel","clearLabel")
	     

	     .generic("deleteLabel","deleteLabel")
	     

	     .generic("onclear","onclear","clear")
	     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
Map<String, Object> attributes  =  component.getAttributes(); 
Object disabled  =  attributes.get("disabled"); 
responseWriter.startElement("div", component); 
   {
      String value = "rf-fu " + convertToString(attributes.get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	
renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES82);

responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-fu-hdr",null);


responseWriter.startElement("span", component); 
  responseWriter.writeAttribute("class","rf-fu-btns-lft",null);


responseWriter.startElement("span", component); 
   {
      String value = "rf-fu-btn-add" + convertToString((convertToBoolean(disabled) ? "-dis" : ""));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


responseWriter.startElement("span", component); 
   {
      String value = "rf-fu-btn-cnt-add" + convertToString((convertToBoolean(disabled) ? "-dis" : ""));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }


	if ((!convertToBoolean(disabled))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-fu-inp-cntr",null);


	responseWriter.startElement("input", component); 
	  responseWriter.writeAttribute("class","rf-fu-inp",null);

  responseWriter.writeAttribute("type","file",null);


	responseWriter.endElement("input"); 
	responseWriter.endElement("span"); 
}
Object addLabel  =  attributes.get("addLabel"); 
{
	Object text = ((addLabel != null) ? addLabel : "Add...");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("span"); 
responseWriter.endElement("span"); 
	if ((!convertToBoolean(disabled))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-fu-btn-upl",null);


	Object uploadLabel  =  attributes.get("uploadLabel"); 
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-fu-btn-cnt-upl",null);


	{
	Object text = ((uploadLabel != null) ? uploadLabel : "Upload");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
}
responseWriter.endElement("span"); 
	if ((!convertToBoolean(disabled))) {
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-fu-btns-rgh",null);


	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-fu-btn-clr",null);


	Object clearAllLabel  =  attributes.get("clearAllLabel"); 
	responseWriter.startElement("span", component); 
	  responseWriter.writeAttribute("class","rf-fu-btn-cnt-clr",null);


	{
	Object text = ((clearAllLabel != null) ? clearAllLabel : "Clear All");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
	responseWriter.endElement("span"); 
}
responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","rf-fu-lst",null);

   {
      String value = "height: " + convertToString(attributes.get("listHeight"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


responseWriter.endElement("div"); 
	if ((!convertToBoolean(disabled))) {
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","rf-fu-cntr-hdn",null);


	responseWriter.startElement("iframe", component); 
	   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }


	responseWriter.endElement("iframe"); 
	UIComponent progressBar  =  component.getFacets().get("progress"); 
		if (((progressBar != null) && convertToBoolean(progressBar.isRendered()))) {
	progressBar.encodeAll(facesContext);
}
	responseWriter.endElement("div"); 
	Map<String, Object> options = new LinkedHashMap<String, Object>(); 

	
addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH59, null);

	responseWriter.startElement("script", component); 
	  responseWriter.writeAttribute("type","text/javascript",null);


	{
	Object text = "new RichFaces.ui.FileUpload(" + convertToString(toScriptArgs(clientId,options)) + ");";
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("script"); 
}
responseWriter.endElement("div"); 

	}
}

