/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractAutocomplete;
import javax.el.MethodExpression;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;

/**
 *  <p>The &lt;rich:autocomplete&gt; component is an auto-completing input-box with built-in Ajax capabilities. It
 supports client-side suggestions, browser-like selection, and customization of the look and feel.</p>

 @author Nick Belaevski

 **/
@Generated({"RichFaces CDK", "4.3.0.Final"})
public class UIAutocomplete extends AbstractAutocomplete
    implements ClientBehaviorHolder,MetaComponentEncoder,MetaComponentResolver    {

    public static final String COMPONENT_TYPE="org.richfaces.Autocomplete";

    public static final String COMPONENT_FAMILY="javax.faces.Input";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIAutocomplete() {
        super();
        setRendererType("org.richfaces.AutocompleteRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "mousedown",
        "listdblclick",
        "mouseover",
        "begin",
        "error",
        "mousemove",
        "keydown",
        "mouseout",
        "keypress",
        "selectitem",
        "dblclick",
        "listmousemove",
        "listmouseout",
        "listclick",
        "mouseup",
        "keyup",
        "listkeyup",
        "click",
        "listmouseover",
        "blur",
        "listkeypress",
        "beforedomupdate",
        "complete",
        "listkeydown",
        "listmousedown",
        "focus",
        "change",
        "listmouseup"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "change";
    }


    protected enum Properties {
        autocompleteList,
        autocompleteMethod,
        autofill,
        clientFilterFunction,
        disabled,
        fetchValue,
        inputClass,
        layout,
        minChars,
        mode,
        onbeforedomupdate,
        onbegin,
        onblur,
        onchange,
        onclick,
        oncomplete,
        ondblclick,
        onerror,
        onfocus,
        onkeydown,
        onkeypress,
        onkeyup,
        onlistclick,
        onlistdblclick,
        onlistkeydown,
        onlistkeypress,
        onlistkeyup,
        onlistmousedown,
        onlistmousemove,
        onlistmouseout,
        onlistmouseover,
        onlistmouseup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onselectitem,
        popupClass,
        selectFirst,
        selectedItemClass,
        showButton,
        style,
        styleClass,
        tabindex,
        tokens,
        var
        
    }

 
    public Object getAutocompleteList() {
        Object value = (Object) getStateHelper().eval(Properties.autocompleteList);
        return value;
    }
    
    public void setAutocompleteList(Object autocompleteList) {
        getStateHelper().put(Properties.autocompleteList, autocompleteList);
    }

 
    public MethodExpression getAutocompleteMethod() {
        MethodExpression value = (MethodExpression) getStateHelper().get(Properties.autocompleteMethod);
        return value;
    }
    
    public void setAutocompleteMethod(MethodExpression autocompleteMethod) {
        getStateHelper().put(Properties.autocompleteMethod, autocompleteMethod);
    }

 
    public boolean isAutofill() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.autofill, true);
        return value;
    }
    
    public void setAutofill(boolean autofill) {
        getStateHelper().put(Properties.autofill, autofill);
    }

 
    public String getClientFilterFunction() {
        String value = (String) getStateHelper().eval(Properties.clientFilterFunction);
        return value;
    }
    
    public void setClientFilterFunction(String clientFilterFunction) {
        getStateHelper().put(Properties.clientFilterFunction, clientFilterFunction);
    }

 
    public boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled, false);
        return value;
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public Object getFetchValue() {
        Object value = (Object) getStateHelper().eval(Properties.fetchValue);
        return value;
    }
    
    public void setFetchValue(Object fetchValue) {
        getStateHelper().put(Properties.fetchValue, fetchValue);
    }

 
    public String getInputClass() {
        String value = (String) getStateHelper().eval(Properties.inputClass);
        return value;
    }
    
    public void setInputClass(String inputClass) {
        getStateHelper().put(Properties.inputClass, inputClass);
    }

 
    public String getLayout() {
        String value = (String) getStateHelper().eval(Properties.layout);
        return value;
    }
    
    public void setLayout(String layout) {
        getStateHelper().put(Properties.layout, layout);
    }

 
    public int getMinChars() {
        Integer value = (Integer) getStateHelper().eval(Properties.minChars, Integer.MIN_VALUE);
        return value;
    }
    
    public void setMinChars(int minChars) {
        getStateHelper().put(Properties.minChars, minChars);
    }

 
    public AutocompleteMode getMode() {
        AutocompleteMode value = (AutocompleteMode) getStateHelper().eval(Properties.mode);
        return value;
    }
    
    public void setMode(AutocompleteMode mode) {
        getStateHelper().put(Properties.mode, mode);
    }

 
    public String getOnbeforedomupdate() {
        String value = (String) getStateHelper().eval(Properties.onbeforedomupdate);
        return value;
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOnbegin() {
        String value = (String) getStateHelper().eval(Properties.onbegin);
        return value;
    }
    
    public void setOnbegin(String onbegin) {
        getStateHelper().put(Properties.onbegin, onbegin);
    }

 
    public String getOnblur() {
        String value = (String) getStateHelper().eval(Properties.onblur);
        return value;
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
        handleAttribute("onblur",onblur);
    }

 
    public String getOnchange() {
        String value = (String) getStateHelper().eval(Properties.onchange);
        return value;
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public String getOnclick() {
        String value = (String) getStateHelper().eval(Properties.onclick);
        return value;
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
        handleAttribute("onclick",onclick);
    }

 
    public String getOncomplete() {
        String value = (String) getStateHelper().eval(Properties.oncomplete);
        return value;
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public String getOndblclick() {
        String value = (String) getStateHelper().eval(Properties.ondblclick);
        return value;
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
        handleAttribute("ondblclick",ondblclick);
    }

 
    public String getOnerror() {
        String value = (String) getStateHelper().eval(Properties.onerror);
        return value;
    }
    
    public void setOnerror(String onerror) {
        getStateHelper().put(Properties.onerror, onerror);
    }

 
    public String getOnfocus() {
        String value = (String) getStateHelper().eval(Properties.onfocus);
        return value;
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
        handleAttribute("onfocus",onfocus);
    }

 
    public String getOnkeydown() {
        String value = (String) getStateHelper().eval(Properties.onkeydown);
        return value;
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
        handleAttribute("onkeydown",onkeydown);
    }

 
    public String getOnkeypress() {
        String value = (String) getStateHelper().eval(Properties.onkeypress);
        return value;
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
        handleAttribute("onkeypress",onkeypress);
    }

 
    public String getOnkeyup() {
        String value = (String) getStateHelper().eval(Properties.onkeyup);
        return value;
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
        handleAttribute("onkeyup",onkeyup);
    }

 
    public String getOnlistclick() {
        String value = (String) getStateHelper().eval(Properties.onlistclick);
        return value;
    }
    
    public void setOnlistclick(String onlistclick) {
        getStateHelper().put(Properties.onlistclick, onlistclick);
    }

 
    public String getOnlistdblclick() {
        String value = (String) getStateHelper().eval(Properties.onlistdblclick);
        return value;
    }
    
    public void setOnlistdblclick(String onlistdblclick) {
        getStateHelper().put(Properties.onlistdblclick, onlistdblclick);
    }

 
    public String getOnlistkeydown() {
        String value = (String) getStateHelper().eval(Properties.onlistkeydown);
        return value;
    }
    
    public void setOnlistkeydown(String onlistkeydown) {
        getStateHelper().put(Properties.onlistkeydown, onlistkeydown);
    }

 
    public String getOnlistkeypress() {
        String value = (String) getStateHelper().eval(Properties.onlistkeypress);
        return value;
    }
    
    public void setOnlistkeypress(String onlistkeypress) {
        getStateHelper().put(Properties.onlistkeypress, onlistkeypress);
    }

 
    public String getOnlistkeyup() {
        String value = (String) getStateHelper().eval(Properties.onlistkeyup);
        return value;
    }
    
    public void setOnlistkeyup(String onlistkeyup) {
        getStateHelper().put(Properties.onlistkeyup, onlistkeyup);
    }

 
    public String getOnlistmousedown() {
        String value = (String) getStateHelper().eval(Properties.onlistmousedown);
        return value;
    }
    
    public void setOnlistmousedown(String onlistmousedown) {
        getStateHelper().put(Properties.onlistmousedown, onlistmousedown);
    }

 
    public String getOnlistmousemove() {
        String value = (String) getStateHelper().eval(Properties.onlistmousemove);
        return value;
    }
    
    public void setOnlistmousemove(String onlistmousemove) {
        getStateHelper().put(Properties.onlistmousemove, onlistmousemove);
    }

 
    public String getOnlistmouseout() {
        String value = (String) getStateHelper().eval(Properties.onlistmouseout);
        return value;
    }
    
    public void setOnlistmouseout(String onlistmouseout) {
        getStateHelper().put(Properties.onlistmouseout, onlistmouseout);
    }

 
    public String getOnlistmouseover() {
        String value = (String) getStateHelper().eval(Properties.onlistmouseover);
        return value;
    }
    
    public void setOnlistmouseover(String onlistmouseover) {
        getStateHelper().put(Properties.onlistmouseover, onlistmouseover);
    }

 
    public String getOnlistmouseup() {
        String value = (String) getStateHelper().eval(Properties.onlistmouseup);
        return value;
    }
    
    public void setOnlistmouseup(String onlistmouseup) {
        getStateHelper().put(Properties.onlistmouseup, onlistmouseup);
    }

 
    public String getOnmousedown() {
        String value = (String) getStateHelper().eval(Properties.onmousedown);
        return value;
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
        handleAttribute("onmousedown",onmousedown);
    }

 
    public String getOnmousemove() {
        String value = (String) getStateHelper().eval(Properties.onmousemove);
        return value;
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
        handleAttribute("onmousemove",onmousemove);
    }

 
    public String getOnmouseout() {
        String value = (String) getStateHelper().eval(Properties.onmouseout);
        return value;
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
        handleAttribute("onmouseout",onmouseout);
    }

 
    public String getOnmouseover() {
        String value = (String) getStateHelper().eval(Properties.onmouseover);
        return value;
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
        handleAttribute("onmouseover",onmouseover);
    }

 
    public String getOnmouseup() {
        String value = (String) getStateHelper().eval(Properties.onmouseup);
        return value;
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
        handleAttribute("onmouseup",onmouseup);
    }

 
    public String getOnselectitem() {
        String value = (String) getStateHelper().eval(Properties.onselectitem);
        return value;
    }
    
    public void setOnselectitem(String onselectitem) {
        getStateHelper().put(Properties.onselectitem, onselectitem);
    }

 
    public String getPopupClass() {
        String value = (String) getStateHelper().eval(Properties.popupClass);
        return value;
    }
    
    public void setPopupClass(String popupClass) {
        getStateHelper().put(Properties.popupClass, popupClass);
    }

 
    public boolean isSelectFirst() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.selectFirst, true);
        return value;
    }
    
    public void setSelectFirst(boolean selectFirst) {
        getStateHelper().put(Properties.selectFirst, selectFirst);
    }

 
    public String getSelectedItemClass() {
        String value = (String) getStateHelper().eval(Properties.selectedItemClass, "rf-au-itm-sel");
        return value;
    }
    
    public void setSelectedItemClass(String selectedItemClass) {
        getStateHelper().put(Properties.selectedItemClass, selectedItemClass);
    }

 
    public boolean isShowButton() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.showButton, false);
        return value;
    }
    
    public void setShowButton(boolean showButton) {
        getStateHelper().put(Properties.showButton, showButton);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public String getTabindex() {
        String value = (String) getStateHelper().eval(Properties.tabindex);
        return value;
    }
    
    public void setTabindex(String tabindex) {
        getStateHelper().put(Properties.tabindex, tabindex);
        handleAttribute("tabindex",tabindex);
    }

 
    public String getTokens() {
        String value = (String) getStateHelper().eval(Properties.tokens);
        return value;
    }
    
    public void setTokens(String tokens) {
        getStateHelper().put(Properties.tokens, tokens);
    }

 
    public String getVar() {
        String value = (String) getStateHelper().get(Properties.var);
        return value;
    }
    
    public void setVar(String var) {
        getStateHelper().put(Properties.var, var);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(13);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    

}